# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/reasoning_engine_execution_service_pb"
require "google/cloud/ai_platform/v1/reasoning_engine_execution_service"

class ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_query_reasoning_engine
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::QueryReasoningEngineResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    input = {}
    class_method = "hello world"

    query_reasoning_engine_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_reasoning_engine, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::QueryReasoningEngineRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["input"]
      assert_equal "hello world", request["class_method"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_reasoning_engine_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_reasoning_engine({ name: name, input: input, class_method: class_method }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_reasoning_engine name: name, input: input, class_method: class_method do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_reasoning_engine ::Google::Cloud::AIPlatform::V1::QueryReasoningEngineRequest.new(name: name, input: input, class_method: class_method) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_reasoning_engine({ name: name, input: input, class_method: class_method }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_reasoning_engine(::Google::Cloud::AIPlatform::V1::QueryReasoningEngineRequest.new(name: name, input: input, class_method: class_method), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_reasoning_engine_client_stub.call_rpc_count
    end
  end

  def test_stream_query_reasoning_engine
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    name = "hello world"
    input = {}
    class_method = "hello world"

    stream_query_reasoning_engine_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :stream_query_reasoning_engine, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamQueryReasoningEngineRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Struct), request["input"]
      assert_equal "hello world", request["class_method"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stream_query_reasoning_engine_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stream_query_reasoning_engine({ name: name, input: input, class_method: class_method }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stream_query_reasoning_engine name: name, input: input, class_method: class_method do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stream_query_reasoning_engine ::Google::Cloud::AIPlatform::V1::StreamQueryReasoningEngineRequest.new(name: name, input: input, class_method: class_method) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stream_query_reasoning_engine({ name: name, input: input, class_method: class_method }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stream_query_reasoning_engine(::Google::Cloud::AIPlatform::V1::StreamQueryReasoningEngineRequest.new(name: name, input: input, class_method: class_method), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stream_query_reasoning_engine_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ReasoningEngineExecutionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
