# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/prediction_service_pb"
require "google/cloud/ai_platform/v1/prediction_service"

class ::Google::Cloud::AIPlatform::V1::PredictionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::PredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    instances = [{}]
    parameters = {}
    labels = {}

    predict_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :predict, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::PredictRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_kind_of ::Google::Protobuf::Value, request["instances"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Value), request["parameters"]
      assert_equal({}, request["labels"].to_h)
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.predict({ endpoint: endpoint, instances: instances, parameters: parameters, labels: labels }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.predict endpoint: endpoint, instances: instances, parameters: parameters, labels: labels do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.predict ::Google::Cloud::AIPlatform::V1::PredictRequest.new(endpoint: endpoint, instances: instances, parameters: parameters, labels: labels) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.predict({ endpoint: endpoint, instances: instances, parameters: parameters, labels: labels }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.predict(::Google::Cloud::AIPlatform::V1::PredictRequest.new(endpoint: endpoint, instances: instances, parameters: parameters, labels: labels), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, predict_client_stub.call_rpc_count
    end
  end

  def test_raw_predict
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    http_body = {}

    raw_predict_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :raw_predict, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::RawPredictRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Api::HttpBody), request["http_body"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, raw_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.raw_predict({ endpoint: endpoint, http_body: http_body }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.raw_predict endpoint: endpoint, http_body: http_body do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.raw_predict ::Google::Cloud::AIPlatform::V1::RawPredictRequest.new(endpoint: endpoint, http_body: http_body) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.raw_predict({ endpoint: endpoint, http_body: http_body }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.raw_predict(::Google::Cloud::AIPlatform::V1::RawPredictRequest.new(endpoint: endpoint, http_body: http_body), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, raw_predict_client_stub.call_rpc_count
    end
  end

  def test_stream_raw_predict
    # Create GRPC objects.
    grpc_response = ::Google::Api::HttpBody.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    endpoint = "hello world"
    http_body = {}

    stream_raw_predict_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :stream_raw_predict, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamRawPredictRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Api::HttpBody), request["http_body"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stream_raw_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stream_raw_predict({ endpoint: endpoint, http_body: http_body }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stream_raw_predict endpoint: endpoint, http_body: http_body do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stream_raw_predict ::Google::Cloud::AIPlatform::V1::StreamRawPredictRequest.new(endpoint: endpoint, http_body: http_body) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stream_raw_predict({ endpoint: endpoint, http_body: http_body }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stream_raw_predict(::Google::Cloud::AIPlatform::V1::StreamRawPredictRequest.new(endpoint: endpoint, http_body: http_body), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Api::HttpBody, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stream_raw_predict_client_stub.call_rpc_count
    end
  end

  def test_direct_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::DirectPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    inputs = [{}]
    parameters = {}

    direct_predict_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :direct_predict, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DirectPredictRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Tensor, request["inputs"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Tensor), request["parameters"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, direct_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.direct_predict({ endpoint: endpoint, inputs: inputs, parameters: parameters }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.direct_predict endpoint: endpoint, inputs: inputs, parameters: parameters do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.direct_predict ::Google::Cloud::AIPlatform::V1::DirectPredictRequest.new(endpoint: endpoint, inputs: inputs, parameters: parameters) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.direct_predict({ endpoint: endpoint, inputs: inputs, parameters: parameters }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.direct_predict(::Google::Cloud::AIPlatform::V1::DirectPredictRequest.new(endpoint: endpoint, inputs: inputs, parameters: parameters), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, direct_predict_client_stub.call_rpc_count
    end
  end

  def test_direct_raw_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::DirectRawPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    method_name = "hello world"
    input = "hello world"

    direct_raw_predict_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :direct_raw_predict, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DirectRawPredictRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_equal "hello world", request["method_name"]
      assert_equal "hello world", request["input"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, direct_raw_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.direct_raw_predict({ endpoint: endpoint, method_name: method_name, input: input }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.direct_raw_predict endpoint: endpoint, method_name: method_name, input: input do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.direct_raw_predict ::Google::Cloud::AIPlatform::V1::DirectRawPredictRequest.new(endpoint: endpoint, method_name: method_name, input: input) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.direct_raw_predict({ endpoint: endpoint, method_name: method_name, input: input }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.direct_raw_predict(::Google::Cloud::AIPlatform::V1::DirectRawPredictRequest.new(endpoint: endpoint, method_name: method_name, input: input), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, direct_raw_predict_client_stub.call_rpc_count
    end
  end

  def test_stream_direct_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    endpoint = "hello world"
    inputs = [{}]
    parameters = {}

    stream_direct_predict_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :stream_direct_predict, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, stream_direct_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      enum_input = [request_hash, request_proto].to_enum
      client.stream_direct_predict enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      stream_input = Gapic::StreamInput.new
      client.stream_direct_predict stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      enum_input = [request_hash, request_proto].to_enum
      client.stream_direct_predict enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      stream_input = Gapic::StreamInput.new
      client.stream_direct_predict stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, stream_direct_predict_client_stub.call_rpc_count
      stream_direct_predict_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectPredictRequest, r
          assert_equal "hello world", r["endpoint"]
          assert_kind_of ::Google::Cloud::AIPlatform::V1::Tensor, r["inputs"].first
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Tensor), r["parameters"]
        end
      end
    end
  end

  def test_stream_direct_raw_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    endpoint = "hello world"
    method_name = "hello world"
    input = "hello world"

    stream_direct_raw_predict_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :stream_direct_raw_predict, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, stream_direct_raw_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      enum_input = [request_hash, request_proto].to_enum
      client.stream_direct_raw_predict enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      stream_input = Gapic::StreamInput.new
      client.stream_direct_raw_predict stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      enum_input = [request_hash, request_proto].to_enum
      client.stream_direct_raw_predict enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      stream_input = Gapic::StreamInput.new
      client.stream_direct_raw_predict stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, stream_direct_raw_predict_client_stub.call_rpc_count
      stream_direct_raw_predict_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamDirectRawPredictRequest, r
          assert_equal "hello world", r["endpoint"]
          assert_equal "hello world", r["method_name"]
          assert_equal "hello world", r["input"]
        end
      end
    end
  end

  def test_streaming_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    endpoint = "hello world"
    inputs = [{}]
    parameters = {}

    streaming_predict_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :streaming_predict, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, streaming_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_predict enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      stream_input = Gapic::StreamInput.new
      client.streaming_predict stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_predict enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { endpoint: endpoint, inputs: inputs, parameters: parameters }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new endpoint: endpoint, inputs: inputs, parameters: parameters
      stream_input = Gapic::StreamInput.new
      client.streaming_predict stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, streaming_predict_client_stub.call_rpc_count
      streaming_predict_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest, r
          assert_equal "hello world", r["endpoint"]
          assert_kind_of ::Google::Cloud::AIPlatform::V1::Tensor, r["inputs"].first
          assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Tensor), r["parameters"]
        end
      end
    end
  end

  def test_server_streaming_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    endpoint = "hello world"
    inputs = [{}]
    parameters = {}

    server_streaming_predict_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :server_streaming_predict, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Tensor, request["inputs"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Tensor), request["parameters"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, server_streaming_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.server_streaming_predict({ endpoint: endpoint, inputs: inputs, parameters: parameters }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.server_streaming_predict endpoint: endpoint, inputs: inputs, parameters: parameters do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.server_streaming_predict ::Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new(endpoint: endpoint, inputs: inputs, parameters: parameters) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.server_streaming_predict({ endpoint: endpoint, inputs: inputs, parameters: parameters }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.server_streaming_predict(::Google::Cloud::AIPlatform::V1::StreamingPredictRequest.new(endpoint: endpoint, inputs: inputs, parameters: parameters), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, server_streaming_predict_client_stub.call_rpc_count
    end
  end

  def test_streaming_raw_predict
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    endpoint = "hello world"
    method_name = "hello world"
    input = "hello world"

    streaming_raw_predict_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :streaming_raw_predict, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, streaming_raw_predict_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_raw_predict enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      stream_input = Gapic::StreamInput.new
      client.streaming_raw_predict stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      enum_input = [request_hash, request_proto].to_enum
      client.streaming_raw_predict enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { endpoint: endpoint, method_name: method_name, input: input }
      request_proto = ::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest.new endpoint: endpoint, method_name: method_name, input: input
      stream_input = Gapic::StreamInput.new
      client.streaming_raw_predict stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingRawPredictResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, streaming_raw_predict_client_stub.call_rpc_count
      streaming_raw_predict_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::StreamingRawPredictRequest, r
          assert_equal "hello world", r["endpoint"]
          assert_equal "hello world", r["method_name"]
          assert_equal "hello world", r["input"]
        end
      end
    end
  end

  def test_explain
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ExplainResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    instances = [{}]
    parameters = {}
    explanation_spec_override = {}
    deployed_model_id = "hello world"

    explain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :explain, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ExplainRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_kind_of ::Google::Protobuf::Value, request["instances"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Value), request["parameters"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ExplanationSpecOverride), request["explanation_spec_override"]
      assert_equal "hello world", request["deployed_model_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, explain_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.explain({ endpoint: endpoint, instances: instances, parameters: parameters, explanation_spec_override: explanation_spec_override, deployed_model_id: deployed_model_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.explain endpoint: endpoint, instances: instances, parameters: parameters, explanation_spec_override: explanation_spec_override, deployed_model_id: deployed_model_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.explain ::Google::Cloud::AIPlatform::V1::ExplainRequest.new(endpoint: endpoint, instances: instances, parameters: parameters, explanation_spec_override: explanation_spec_override, deployed_model_id: deployed_model_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.explain({ endpoint: endpoint, instances: instances, parameters: parameters, explanation_spec_override: explanation_spec_override, deployed_model_id: deployed_model_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.explain(::Google::Cloud::AIPlatform::V1::ExplainRequest.new(endpoint: endpoint, instances: instances, parameters: parameters, explanation_spec_override: explanation_spec_override, deployed_model_id: deployed_model_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, explain_client_stub.call_rpc_count
    end
  end

  def test_generate_content
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::GenerateContentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    contents = [{}]
    system_instruction = {}
    cached_content = "hello world"
    tools = [{}]
    tool_config = {}
    labels = {}
    safety_settings = [{}]
    model_armor_config = {}
    generation_config = {}

    generate_content_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_content, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentRequest, request
      assert_equal "hello world", request["model"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Content, request["contents"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Content), request["system_instruction"]
      assert request.has_system_instruction?
      assert_equal "hello world", request["cached_content"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Tool, request["tools"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ToolConfig), request["tool_config"]
      assert_equal({}, request["labels"].to_h)
      assert_kind_of ::Google::Cloud::AIPlatform::V1::SafetySetting, request["safety_settings"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ModelArmorConfig), request["model_armor_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::GenerationConfig), request["generation_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_content_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_content({ model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_content model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_content ::Google::Cloud::AIPlatform::V1::GenerateContentRequest.new(model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_content({ model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_content(::Google::Cloud::AIPlatform::V1::GenerateContentRequest.new(model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_content_client_stub.call_rpc_count
    end
  end

  def test_stream_generate_content
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::GenerateContentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a server streaming method.
    model = "hello world"
    contents = [{}]
    system_instruction = {}
    cached_content = "hello world"
    tools = [{}]
    tool_config = {}
    labels = {}
    safety_settings = [{}]
    model_armor_config = {}
    generation_config = {}

    stream_generate_content_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :stream_generate_content, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentRequest, request
      assert_equal "hello world", request["model"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Content, request["contents"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Content), request["system_instruction"]
      assert request.has_system_instruction?
      assert_equal "hello world", request["cached_content"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Tool, request["tools"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ToolConfig), request["tool_config"]
      assert_equal({}, request["labels"].to_h)
      assert_kind_of ::Google::Cloud::AIPlatform::V1::SafetySetting, request["safety_settings"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ModelArmorConfig), request["model_armor_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::GenerationConfig), request["generation_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, stream_generate_content_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.stream_generate_content({ model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config }) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.stream_generate_content model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.stream_generate_content ::Google::Cloud::AIPlatform::V1::GenerateContentRequest.new(model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.stream_generate_content({ model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config }, grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.stream_generate_content(::Google::Cloud::AIPlatform::V1::GenerateContentRequest.new(model: model, contents: contents, system_instruction: system_instruction, cached_content: cached_content, tools: tools, tool_config: tool_config, labels: labels, safety_settings: safety_settings, model_armor_config: model_armor_config, generation_config: generation_config), grpc_options) do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateContentResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, stream_generate_content_client_stub.call_rpc_count
    end
  end

  def test_embed_content
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::EmbedContentResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    content = {}
    title = "hello world"
    task_type = :UNSPECIFIED
    output_dimensionality = 42
    auto_truncate = true

    embed_content_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :embed_content, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::EmbedContentRequest, request
      assert_equal "hello world", request["model"]
      assert request.has_model?
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Content), request["content"]
      assert request.has_content?
      assert_equal "hello world", request["title"]
      assert request.has_title?
      assert_equal :UNSPECIFIED, request["task_type"]
      assert request.has_task_type?
      assert_equal 42, request["output_dimensionality"]
      assert request.has_output_dimensionality?
      assert_equal true, request["auto_truncate"]
      assert request.has_auto_truncate?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, embed_content_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.embed_content({ model: model, content: content, title: title, task_type: task_type, output_dimensionality: output_dimensionality, auto_truncate: auto_truncate }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.embed_content model: model, content: content, title: title, task_type: task_type, output_dimensionality: output_dimensionality, auto_truncate: auto_truncate do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.embed_content ::Google::Cloud::AIPlatform::V1::EmbedContentRequest.new(model: model, content: content, title: title, task_type: task_type, output_dimensionality: output_dimensionality, auto_truncate: auto_truncate) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.embed_content({ model: model, content: content, title: title, task_type: task_type, output_dimensionality: output_dimensionality, auto_truncate: auto_truncate }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.embed_content(::Google::Cloud::AIPlatform::V1::EmbedContentRequest.new(model: model, content: content, title: title, task_type: task_type, output_dimensionality: output_dimensionality, auto_truncate: auto_truncate), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, embed_content_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::PredictionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::PredictionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::PredictionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
