# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/pipeline_service_pb"
require "google/cloud/ai_platform/v1/pipeline_service/rest"


class ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_training_pipeline
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TrainingPipeline.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    training_pipeline = {}

    create_training_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_create_training_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_training_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_training_pipeline({ parent: parent, training_pipeline: training_pipeline }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_training_pipeline parent: parent, training_pipeline: training_pipeline do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_training_pipeline ::Google::Cloud::AIPlatform::V1::CreateTrainingPipelineRequest.new(parent: parent, training_pipeline: training_pipeline) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_training_pipeline({ parent: parent, training_pipeline: training_pipeline }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_training_pipeline(::Google::Cloud::AIPlatform::V1::CreateTrainingPipelineRequest.new(parent: parent, training_pipeline: training_pipeline), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_training_pipeline_client_stub.call_count
      end
    end
  end

  def test_get_training_pipeline
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::TrainingPipeline.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_training_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_get_training_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_training_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_training_pipeline({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_training_pipeline name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_training_pipeline ::Google::Cloud::AIPlatform::V1::GetTrainingPipelineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_training_pipeline({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_training_pipeline(::Google::Cloud::AIPlatform::V1::GetTrainingPipelineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_training_pipeline_client_stub.call_count
      end
    end
  end

  def test_list_training_pipelines
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_training_pipelines_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_list_training_pipelines_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_training_pipelines_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_training_pipelines({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_training_pipelines parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_training_pipelines ::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_training_pipelines({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_training_pipelines(::Google::Cloud::AIPlatform::V1::ListTrainingPipelinesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_training_pipelines_client_stub.call_count
      end
    end
  end

  def test_delete_training_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_training_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_delete_training_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_training_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_training_pipeline({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_training_pipeline name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_training_pipeline ::Google::Cloud::AIPlatform::V1::DeleteTrainingPipelineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_training_pipeline({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_training_pipeline(::Google::Cloud::AIPlatform::V1::DeleteTrainingPipelineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_training_pipeline_client_stub.call_count
      end
    end
  end

  def test_cancel_training_pipeline
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_training_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_cancel_training_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_training_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_training_pipeline({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_training_pipeline name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_training_pipeline ::Google::Cloud::AIPlatform::V1::CancelTrainingPipelineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_training_pipeline({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_training_pipeline(::Google::Cloud::AIPlatform::V1::CancelTrainingPipelineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_training_pipeline_client_stub.call_count
      end
    end
  end

  def test_create_pipeline_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::PipelineJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pipeline_job = {}
    pipeline_job_id = "hello world"

    create_pipeline_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_create_pipeline_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_pipeline_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_pipeline_job({ parent: parent, pipeline_job: pipeline_job, pipeline_job_id: pipeline_job_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_pipeline_job parent: parent, pipeline_job: pipeline_job, pipeline_job_id: pipeline_job_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_pipeline_job ::Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest.new(parent: parent, pipeline_job: pipeline_job, pipeline_job_id: pipeline_job_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_pipeline_job({ parent: parent, pipeline_job: pipeline_job, pipeline_job_id: pipeline_job_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_pipeline_job(::Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest.new(parent: parent, pipeline_job: pipeline_job, pipeline_job_id: pipeline_job_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_pipeline_job_client_stub.call_count
      end
    end
  end

  def test_get_pipeline_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::PipelineJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pipeline_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_get_pipeline_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_pipeline_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_pipeline_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_pipeline_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_pipeline_job ::Google::Cloud::AIPlatform::V1::GetPipelineJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_pipeline_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_pipeline_job(::Google::Cloud::AIPlatform::V1::GetPipelineJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_pipeline_job_client_stub.call_count
      end
    end
  end

  def test_list_pipeline_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListPipelineJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_pipeline_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_list_pipeline_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_pipeline_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_pipeline_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_pipeline_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_pipeline_jobs ::Google::Cloud::AIPlatform::V1::ListPipelineJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_pipeline_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_pipeline_jobs(::Google::Cloud::AIPlatform::V1::ListPipelineJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_pipeline_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_pipeline_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_pipeline_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_delete_pipeline_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_pipeline_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_pipeline_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_pipeline_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_pipeline_job ::Google::Cloud::AIPlatform::V1::DeletePipelineJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_pipeline_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_pipeline_job(::Google::Cloud::AIPlatform::V1::DeletePipelineJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_pipeline_job_client_stub.call_count
      end
    end
  end

  def test_batch_delete_pipeline_jobs
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]

    batch_delete_pipeline_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_batch_delete_pipeline_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_delete_pipeline_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_delete_pipeline_jobs({ parent: parent, names: names }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_delete_pipeline_jobs parent: parent, names: names do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_delete_pipeline_jobs ::Google::Cloud::AIPlatform::V1::BatchDeletePipelineJobsRequest.new(parent: parent, names: names) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_delete_pipeline_jobs({ parent: parent, names: names }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_delete_pipeline_jobs(::Google::Cloud::AIPlatform::V1::BatchDeletePipelineJobsRequest.new(parent: parent, names: names), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_delete_pipeline_jobs_client_stub.call_count
      end
    end
  end

  def test_cancel_pipeline_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_pipeline_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_cancel_pipeline_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_pipeline_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_pipeline_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_pipeline_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_pipeline_job ::Google::Cloud::AIPlatform::V1::CancelPipelineJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_pipeline_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_pipeline_job(::Google::Cloud::AIPlatform::V1::CancelPipelineJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_pipeline_job_client_stub.call_count
      end
    end
  end

  def test_batch_cancel_pipeline_jobs
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    names = ["hello world"]

    batch_cancel_pipeline_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::ServiceStub.stub :transcode_batch_cancel_pipeline_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_cancel_pipeline_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_cancel_pipeline_jobs({ parent: parent, names: names }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_cancel_pipeline_jobs parent: parent, names: names do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_cancel_pipeline_jobs ::Google::Cloud::AIPlatform::V1::BatchCancelPipelineJobsRequest.new(parent: parent, names: names) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_cancel_pipeline_jobs({ parent: parent, names: names }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_cancel_pipeline_jobs(::Google::Cloud::AIPlatform::V1::BatchCancelPipelineJobsRequest.new(parent: parent, names: names), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_cancel_pipeline_jobs_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::PipelineService::Rest::Client::Configuration, config
  end
end
