# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/notebook_service_pb"
require "google/cloud/ai_platform/v1/notebook_service/rest"


class ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_notebook_runtime_template
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    notebook_runtime_template = {}
    notebook_runtime_template_id = "hello world"

    create_notebook_runtime_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_create_notebook_runtime_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_notebook_runtime_template_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_notebook_runtime_template({ parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime_template_id: notebook_runtime_template_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_notebook_runtime_template parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime_template_id: notebook_runtime_template_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_notebook_runtime_template ::Google::Cloud::AIPlatform::V1::CreateNotebookRuntimeTemplateRequest.new(parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime_template_id: notebook_runtime_template_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_notebook_runtime_template({ parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime_template_id: notebook_runtime_template_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_notebook_runtime_template(::Google::Cloud::AIPlatform::V1::CreateNotebookRuntimeTemplateRequest.new(parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime_template_id: notebook_runtime_template_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_notebook_runtime_template_client_stub.call_count
      end
    end
  end

  def test_get_notebook_runtime_template
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notebook_runtime_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_notebook_runtime_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_notebook_runtime_template_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_notebook_runtime_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_notebook_runtime_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_notebook_runtime_template ::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_notebook_runtime_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_notebook_runtime_template(::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_notebook_runtime_template_client_stub.call_count
      end
    end
  end

  def test_list_notebook_runtime_templates
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_notebook_runtime_templates_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_notebook_runtime_templates_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_notebook_runtime_templates_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_notebook_runtime_templates({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_notebook_runtime_templates parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_notebook_runtime_templates ::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_notebook_runtime_templates({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_notebook_runtime_templates(::Google::Cloud::AIPlatform::V1::ListNotebookRuntimeTemplatesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_notebook_runtime_templates_client_stub.call_count
      end
    end
  end

  def test_delete_notebook_runtime_template
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notebook_runtime_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_notebook_runtime_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_notebook_runtime_template_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_notebook_runtime_template({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_notebook_runtime_template name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_notebook_runtime_template ::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeTemplateRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_notebook_runtime_template({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_notebook_runtime_template(::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeTemplateRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_notebook_runtime_template_client_stub.call_count
      end
    end
  end

  def test_update_notebook_runtime_template
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NotebookRuntimeTemplate.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    notebook_runtime_template = {}
    update_mask = {}

    update_notebook_runtime_template_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_update_notebook_runtime_template_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_notebook_runtime_template_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_notebook_runtime_template({ notebook_runtime_template: notebook_runtime_template, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_notebook_runtime_template notebook_runtime_template: notebook_runtime_template, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_notebook_runtime_template ::Google::Cloud::AIPlatform::V1::UpdateNotebookRuntimeTemplateRequest.new(notebook_runtime_template: notebook_runtime_template, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_notebook_runtime_template({ notebook_runtime_template: notebook_runtime_template, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_notebook_runtime_template(::Google::Cloud::AIPlatform::V1::UpdateNotebookRuntimeTemplateRequest.new(notebook_runtime_template: notebook_runtime_template, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_notebook_runtime_template_client_stub.call_count
      end
    end
  end

  def test_assign_notebook_runtime
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    notebook_runtime_template = "hello world"
    notebook_runtime = {}
    notebook_runtime_id = "hello world"

    assign_notebook_runtime_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_assign_notebook_runtime_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, assign_notebook_runtime_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.assign_notebook_runtime({ parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime: notebook_runtime, notebook_runtime_id: notebook_runtime_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.assign_notebook_runtime parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime: notebook_runtime, notebook_runtime_id: notebook_runtime_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.assign_notebook_runtime ::Google::Cloud::AIPlatform::V1::AssignNotebookRuntimeRequest.new(parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime: notebook_runtime, notebook_runtime_id: notebook_runtime_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.assign_notebook_runtime({ parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime: notebook_runtime, notebook_runtime_id: notebook_runtime_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.assign_notebook_runtime(::Google::Cloud::AIPlatform::V1::AssignNotebookRuntimeRequest.new(parent: parent, notebook_runtime_template: notebook_runtime_template, notebook_runtime: notebook_runtime, notebook_runtime_id: notebook_runtime_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, assign_notebook_runtime_client_stub.call_count
      end
    end
  end

  def test_get_notebook_runtime
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NotebookRuntime.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_notebook_runtime_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_notebook_runtime_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_notebook_runtime_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_notebook_runtime({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_notebook_runtime name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_notebook_runtime ::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_notebook_runtime({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_notebook_runtime(::Google::Cloud::AIPlatform::V1::GetNotebookRuntimeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_notebook_runtime_client_stub.call_count
      end
    end
  end

  def test_list_notebook_runtimes
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_notebook_runtimes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_notebook_runtimes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_notebook_runtimes_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_notebook_runtimes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_notebook_runtimes parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_notebook_runtimes ::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_notebook_runtimes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_notebook_runtimes(::Google::Cloud::AIPlatform::V1::ListNotebookRuntimesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_notebook_runtimes_client_stub.call_count
      end
    end
  end

  def test_delete_notebook_runtime
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notebook_runtime_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_notebook_runtime_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_notebook_runtime_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_notebook_runtime({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_notebook_runtime name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_notebook_runtime ::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_notebook_runtime({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_notebook_runtime(::Google::Cloud::AIPlatform::V1::DeleteNotebookRuntimeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_notebook_runtime_client_stub.call_count
      end
    end
  end

  def test_upgrade_notebook_runtime
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    upgrade_notebook_runtime_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_upgrade_notebook_runtime_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upgrade_notebook_runtime_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upgrade_notebook_runtime({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upgrade_notebook_runtime name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upgrade_notebook_runtime ::Google::Cloud::AIPlatform::V1::UpgradeNotebookRuntimeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upgrade_notebook_runtime({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upgrade_notebook_runtime(::Google::Cloud::AIPlatform::V1::UpgradeNotebookRuntimeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upgrade_notebook_runtime_client_stub.call_count
      end
    end
  end

  def test_start_notebook_runtime
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    start_notebook_runtime_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_start_notebook_runtime_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_notebook_runtime_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_notebook_runtime({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_notebook_runtime name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_notebook_runtime ::Google::Cloud::AIPlatform::V1::StartNotebookRuntimeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_notebook_runtime({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_notebook_runtime(::Google::Cloud::AIPlatform::V1::StartNotebookRuntimeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_notebook_runtime_client_stub.call_count
      end
    end
  end

  def test_stop_notebook_runtime
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    stop_notebook_runtime_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_stop_notebook_runtime_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_notebook_runtime_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_notebook_runtime({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_notebook_runtime name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_notebook_runtime ::Google::Cloud::AIPlatform::V1::StopNotebookRuntimeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_notebook_runtime({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_notebook_runtime(::Google::Cloud::AIPlatform::V1::StopNotebookRuntimeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_notebook_runtime_client_stub.call_count
      end
    end
  end

  def test_create_notebook_execution_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    notebook_execution_job = {}
    notebook_execution_job_id = "hello world"

    create_notebook_execution_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_create_notebook_execution_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_notebook_execution_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_notebook_execution_job({ parent: parent, notebook_execution_job: notebook_execution_job, notebook_execution_job_id: notebook_execution_job_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_notebook_execution_job parent: parent, notebook_execution_job: notebook_execution_job, notebook_execution_job_id: notebook_execution_job_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_notebook_execution_job ::Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest.new(parent: parent, notebook_execution_job: notebook_execution_job, notebook_execution_job_id: notebook_execution_job_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_notebook_execution_job({ parent: parent, notebook_execution_job: notebook_execution_job, notebook_execution_job_id: notebook_execution_job_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_notebook_execution_job(::Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest.new(parent: parent, notebook_execution_job: notebook_execution_job, notebook_execution_job_id: notebook_execution_job_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_notebook_execution_job_client_stub.call_count
      end
    end
  end

  def test_get_notebook_execution_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NotebookExecutionJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :NOTEBOOK_EXECUTION_JOB_VIEW_UNSPECIFIED

    get_notebook_execution_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_get_notebook_execution_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_notebook_execution_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_notebook_execution_job({ name: name, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_notebook_execution_job name: name, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_notebook_execution_job ::Google::Cloud::AIPlatform::V1::GetNotebookExecutionJobRequest.new(name: name, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_notebook_execution_job({ name: name, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_notebook_execution_job(::Google::Cloud::AIPlatform::V1::GetNotebookExecutionJobRequest.new(name: name, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_notebook_execution_job_client_stub.call_count
      end
    end
  end

  def test_list_notebook_execution_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    view = :NOTEBOOK_EXECUTION_JOB_VIEW_UNSPECIFIED

    list_notebook_execution_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_list_notebook_execution_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_notebook_execution_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_notebook_execution_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, view: view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_notebook_execution_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, view: view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_notebook_execution_jobs ::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, view: view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_notebook_execution_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, view: view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_notebook_execution_jobs(::Google::Cloud::AIPlatform::V1::ListNotebookExecutionJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, view: view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_notebook_execution_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_notebook_execution_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_notebook_execution_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::ServiceStub.stub :transcode_delete_notebook_execution_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_notebook_execution_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_notebook_execution_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_notebook_execution_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_notebook_execution_job ::Google::Cloud::AIPlatform::V1::DeleteNotebookExecutionJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_notebook_execution_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_notebook_execution_job(::Google::Cloud::AIPlatform::V1::DeleteNotebookExecutionJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_notebook_execution_job_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::NotebookService::Rest::Client::Configuration, config
  end
end
