# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/model_service_pb"
require "google/cloud/ai_platform/v1/model_service"

class ::Google::Cloud::AIPlatform::V1::ModelService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_upload_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    parent_model = "hello world"
    model_id = "hello world"
    model = {}
    service_account = "hello world"

    upload_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :upload_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UploadModelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["parent_model"]
      assert_equal "hello world", request["model_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Model), request["model"]
      assert_equal "hello world", request["service_account"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, upload_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.upload_model({ parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.upload_model parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.upload_model ::Google::Cloud::AIPlatform::V1::UploadModelRequest.new(parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.upload_model({ parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.upload_model(::Google::Cloud::AIPlatform::V1::UploadModelRequest.new(parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, upload_model_client_stub.call_rpc_count
    end
  end

  def test_get_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Model.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_model({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_model name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_model ::Google::Cloud::AIPlatform::V1::GetModelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_model({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_model(::Google::Cloud::AIPlatform::V1::GetModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_model_client_stub.call_rpc_count
    end
  end

  def test_list_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_models, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListModelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_models_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_models parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_models ::Google::Cloud::AIPlatform::V1::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_models(::Google::Cloud::AIPlatform::V1::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_models_client_stub.call_rpc_count
    end
  end

  def test_list_model_versions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListModelVersionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_model_versions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_model_versions, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_model_versions_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_model_versions({ name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_model_versions name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_model_versions ::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_model_versions({ name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_model_versions(::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_model_versions_client_stub.call_rpc_count
    end
  end

  def test_list_model_version_checkpoints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_model_version_checkpoints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_model_version_checkpoints, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_model_version_checkpoints_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_model_version_checkpoints({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_model_version_checkpoints name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_model_version_checkpoints ::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_model_version_checkpoints({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_model_version_checkpoints(::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_model_version_checkpoints_client_stub.call_rpc_count
    end
  end

  def test_update_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Model.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = {}
    update_mask = {}

    update_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateModelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Model), request["model"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_model({ model: model, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_model model: model, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_model ::Google::Cloud::AIPlatform::V1::UpdateModelRequest.new(model: model, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_model({ model: model, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_model(::Google::Cloud::AIPlatform::V1::UpdateModelRequest.new(model: model, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_model_client_stub.call_rpc_count
    end
  end

  def test_update_explanation_dataset
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    examples = {}

    update_explanation_dataset_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_explanation_dataset, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest, request
      assert_equal "hello world", request["model"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Examples), request["examples"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_explanation_dataset_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_explanation_dataset({ model: model, examples: examples }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_explanation_dataset model: model, examples: examples do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_explanation_dataset ::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest.new(model: model, examples: examples) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_explanation_dataset({ model: model, examples: examples }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_explanation_dataset(::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest.new(model: model, examples: examples), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_explanation_dataset_client_stub.call_rpc_count
    end
  end

  def test_delete_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteModelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_model({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_model name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_model ::Google::Cloud::AIPlatform::V1::DeleteModelRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_model({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_model(::Google::Cloud::AIPlatform::V1::DeleteModelRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_model_client_stub.call_rpc_count
    end
  end

  def test_delete_model_version
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_version_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_model_version, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_model_version_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_model_version({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_model_version name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_model_version ::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_model_version({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_model_version(::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_model_version_client_stub.call_rpc_count
    end
  end

  def test_merge_version_aliases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Model.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    version_aliases = ["hello world"]

    merge_version_aliases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :merge_version_aliases, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["version_aliases"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, merge_version_aliases_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.merge_version_aliases({ name: name, version_aliases: version_aliases }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.merge_version_aliases name: name, version_aliases: version_aliases do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.merge_version_aliases ::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest.new(name: name, version_aliases: version_aliases) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.merge_version_aliases({ name: name, version_aliases: version_aliases }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.merge_version_aliases(::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest.new(name: name, version_aliases: version_aliases), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, merge_version_aliases_client_stub.call_rpc_count
    end
  end

  def test_export_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    output_config = {}

    export_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ExportModelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ExportModelRequest::OutputConfig), request["output_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_model({ name: name, output_config: output_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_model name: name, output_config: output_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_model ::Google::Cloud::AIPlatform::V1::ExportModelRequest.new(name: name, output_config: output_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_model({ name: name, output_config: output_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_model(::Google::Cloud::AIPlatform::V1::ExportModelRequest.new(name: name, output_config: output_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_model_client_stub.call_rpc_count
    end
  end

  def test_copy_model
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model_id = "hello world"
    parent = "hello world"
    source_model = "hello world"
    encryption_spec = {}

    copy_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :copy_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CopyModelRequest, request
      assert_equal "hello world", request["model_id"]
      assert_equal :model_id, request.destination_model
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["source_model"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::EncryptionSpec), request["encryption_spec"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, copy_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.copy_model({ model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.copy_model model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.copy_model ::Google::Cloud::AIPlatform::V1::CopyModelRequest.new(model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.copy_model({ model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.copy_model(::Google::Cloud::AIPlatform::V1::CopyModelRequest.new(model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, copy_model_client_stub.call_rpc_count
    end
  end

  def test_import_model_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ModelEvaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_evaluation = {}

    import_model_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_model_evaluation, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ModelEvaluation), request["model_evaluation"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_model_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_model_evaluation({ parent: parent, model_evaluation: model_evaluation }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_model_evaluation parent: parent, model_evaluation: model_evaluation do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_model_evaluation ::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest.new(parent: parent, model_evaluation: model_evaluation) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_model_evaluation({ parent: parent, model_evaluation: model_evaluation }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_model_evaluation(::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest.new(parent: parent, model_evaluation: model_evaluation), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_model_evaluation_client_stub.call_rpc_count
    end
  end

  def test_batch_import_model_evaluation_slices
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_evaluation_slices = [{}]

    batch_import_model_evaluation_slices_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_import_model_evaluation_slices, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice, request["model_evaluation_slices"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_import_model_evaluation_slices_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_import_model_evaluation_slices({ parent: parent, model_evaluation_slices: model_evaluation_slices }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_import_model_evaluation_slices parent: parent, model_evaluation_slices: model_evaluation_slices do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_import_model_evaluation_slices ::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest.new(parent: parent, model_evaluation_slices: model_evaluation_slices) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_import_model_evaluation_slices({ parent: parent, model_evaluation_slices: model_evaluation_slices }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_import_model_evaluation_slices(::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest.new(parent: parent, model_evaluation_slices: model_evaluation_slices), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_import_model_evaluation_slices_client_stub.call_rpc_count
    end
  end

  def test_batch_import_evaluated_annotations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluated_annotations = [{}]

    batch_import_evaluated_annotations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_import_evaluated_annotations, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::EvaluatedAnnotation, request["evaluated_annotations"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_import_evaluated_annotations_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_import_evaluated_annotations({ parent: parent, evaluated_annotations: evaluated_annotations }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_import_evaluated_annotations parent: parent, evaluated_annotations: evaluated_annotations do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_import_evaluated_annotations ::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest.new(parent: parent, evaluated_annotations: evaluated_annotations) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_import_evaluated_annotations({ parent: parent, evaluated_annotations: evaluated_annotations }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_import_evaluated_annotations(::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest.new(parent: parent, evaluated_annotations: evaluated_annotations), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_import_evaluated_annotations_client_stub.call_rpc_count
    end
  end

  def test_get_model_evaluation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ModelEvaluation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_evaluation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_model_evaluation, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_model_evaluation_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_model_evaluation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_model_evaluation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_model_evaluation ::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_model_evaluation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_model_evaluation(::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_model_evaluation_client_stub.call_rpc_count
    end
  end

  def test_list_model_evaluations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListModelEvaluationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_model_evaluations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_model_evaluations, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_model_evaluations_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_model_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_model_evaluations parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_model_evaluations ::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_model_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_model_evaluations(::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_model_evaluations_client_stub.call_rpc_count
    end
  end

  def test_get_model_evaluation_slice
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_evaluation_slice_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_model_evaluation_slice, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_model_evaluation_slice_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_model_evaluation_slice({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_model_evaluation_slice name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_model_evaluation_slice ::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_model_evaluation_slice({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_model_evaluation_slice(::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_model_evaluation_slice_client_stub.call_rpc_count
    end
  end

  def test_list_model_evaluation_slices
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_model_evaluation_slices_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_model_evaluation_slices, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_model_evaluation_slices_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_model_evaluation_slices({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_model_evaluation_slices parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_model_evaluation_slices ::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_model_evaluation_slices({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_model_evaluation_slices(::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_model_evaluation_slices_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelService::Operations, client.operations_client
  end
end
