# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/model_service_pb"
require "google/cloud/ai_platform/v1/model_service/rest"


class ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_upload_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    parent_model = "hello world"
    model_id = "hello world"
    model = {}
    service_account = "hello world"

    upload_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_upload_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upload_model_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upload_model({ parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upload_model parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upload_model ::Google::Cloud::AIPlatform::V1::UploadModelRequest.new(parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upload_model({ parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upload_model(::Google::Cloud::AIPlatform::V1::UploadModelRequest.new(parent: parent, parent_model: parent_model, model_id: model_id, model: model, service_account: service_account), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upload_model_client_stub.call_count
      end
    end
  end

  def test_get_model
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_get_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model ::Google::Cloud::AIPlatform::V1::GetModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model(::Google::Cloud::AIPlatform::V1::GetModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_client_stub.call_count
      end
    end
  end

  def test_list_models
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListModelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_models_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_list_models_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_models_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_models parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_models ::Google::Cloud::AIPlatform::V1::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_models({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_models(::Google::Cloud::AIPlatform::V1::ListModelsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_models_client_stub.call_count
      end
    end
  end

  def test_list_model_versions
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListModelVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_model_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_list_model_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_model_versions_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_model_versions({ name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_model_versions name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_model_versions ::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_model_versions({ name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_model_versions(::Google::Cloud::AIPlatform::V1::ListModelVersionsRequest.new(name: name, page_size: page_size, page_token: page_token, filter: filter, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_model_versions_client_stub.call_count
      end
    end
  end

  def test_list_model_version_checkpoints
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    list_model_version_checkpoints_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_list_model_version_checkpoints_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_model_version_checkpoints_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_model_version_checkpoints({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_model_version_checkpoints name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_model_version_checkpoints ::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_model_version_checkpoints({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_model_version_checkpoints(::Google::Cloud::AIPlatform::V1::ListModelVersionCheckpointsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_model_version_checkpoints_client_stub.call_count
      end
    end
  end

  def test_update_model
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = {}
    update_mask = {}

    update_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_update_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_model_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_model({ model: model, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_model model: model, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_model ::Google::Cloud::AIPlatform::V1::UpdateModelRequest.new(model: model, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_model({ model: model, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_model(::Google::Cloud::AIPlatform::V1::UpdateModelRequest.new(model: model, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_model_client_stub.call_count
      end
    end
  end

  def test_update_explanation_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model = "hello world"
    examples = {}

    update_explanation_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_update_explanation_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_explanation_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_explanation_dataset({ model: model, examples: examples }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_explanation_dataset model: model, examples: examples do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_explanation_dataset ::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest.new(model: model, examples: examples) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_explanation_dataset({ model: model, examples: examples }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_explanation_dataset(::Google::Cloud::AIPlatform::V1::UpdateExplanationDatasetRequest.new(model: model, examples: examples), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_explanation_dataset_client_stub.call_count
      end
    end
  end

  def test_delete_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_delete_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_model_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_model({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_model name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_model ::Google::Cloud::AIPlatform::V1::DeleteModelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_model({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_model(::Google::Cloud::AIPlatform::V1::DeleteModelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_model_client_stub.call_count
      end
    end
  end

  def test_delete_model_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_delete_model_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_model_version_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_model_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_model_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_model_version ::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_model_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_model_version(::Google::Cloud::AIPlatform::V1::DeleteModelVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_model_version_client_stub.call_count
      end
    end
  end

  def test_merge_version_aliases
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Model.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    version_aliases = ["hello world"]

    merge_version_aliases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_merge_version_aliases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, merge_version_aliases_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.merge_version_aliases({ name: name, version_aliases: version_aliases }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.merge_version_aliases name: name, version_aliases: version_aliases do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.merge_version_aliases ::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest.new(name: name, version_aliases: version_aliases) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.merge_version_aliases({ name: name, version_aliases: version_aliases }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.merge_version_aliases(::Google::Cloud::AIPlatform::V1::MergeVersionAliasesRequest.new(name: name, version_aliases: version_aliases), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, merge_version_aliases_client_stub.call_count
      end
    end
  end

  def test_export_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    output_config = {}

    export_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_export_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_model_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_model({ name: name, output_config: output_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_model name: name, output_config: output_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_model ::Google::Cloud::AIPlatform::V1::ExportModelRequest.new(name: name, output_config: output_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_model({ name: name, output_config: output_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_model(::Google::Cloud::AIPlatform::V1::ExportModelRequest.new(name: name, output_config: output_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_model_client_stub.call_count
      end
    end
  end

  def test_copy_model
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model_id = "hello world"
    parent = "hello world"
    source_model = "hello world"
    encryption_spec = {}

    copy_model_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_copy_model_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, copy_model_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.copy_model({ model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.copy_model model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.copy_model ::Google::Cloud::AIPlatform::V1::CopyModelRequest.new(model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.copy_model({ model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.copy_model(::Google::Cloud::AIPlatform::V1::CopyModelRequest.new(model_id: model_id, parent: parent, source_model: source_model, encryption_spec: encryption_spec), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, copy_model_client_stub.call_count
      end
    end
  end

  def test_import_model_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ModelEvaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_evaluation = {}

    import_model_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_import_model_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_model_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_model_evaluation({ parent: parent, model_evaluation: model_evaluation }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_model_evaluation parent: parent, model_evaluation: model_evaluation do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_model_evaluation ::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest.new(parent: parent, model_evaluation: model_evaluation) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_model_evaluation({ parent: parent, model_evaluation: model_evaluation }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_model_evaluation(::Google::Cloud::AIPlatform::V1::ImportModelEvaluationRequest.new(parent: parent, model_evaluation: model_evaluation), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_model_evaluation_client_stub.call_count
      end
    end
  end

  def test_batch_import_model_evaluation_slices
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_evaluation_slices = [{}]

    batch_import_model_evaluation_slices_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_batch_import_model_evaluation_slices_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_import_model_evaluation_slices_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_import_model_evaluation_slices({ parent: parent, model_evaluation_slices: model_evaluation_slices }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_import_model_evaluation_slices parent: parent, model_evaluation_slices: model_evaluation_slices do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_import_model_evaluation_slices ::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest.new(parent: parent, model_evaluation_slices: model_evaluation_slices) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_import_model_evaluation_slices({ parent: parent, model_evaluation_slices: model_evaluation_slices }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_import_model_evaluation_slices(::Google::Cloud::AIPlatform::V1::BatchImportModelEvaluationSlicesRequest.new(parent: parent, model_evaluation_slices: model_evaluation_slices), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_import_model_evaluation_slices_client_stub.call_count
      end
    end
  end

  def test_batch_import_evaluated_annotations
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    evaluated_annotations = [{}]

    batch_import_evaluated_annotations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_batch_import_evaluated_annotations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_import_evaluated_annotations_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_import_evaluated_annotations({ parent: parent, evaluated_annotations: evaluated_annotations }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_import_evaluated_annotations parent: parent, evaluated_annotations: evaluated_annotations do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_import_evaluated_annotations ::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest.new(parent: parent, evaluated_annotations: evaluated_annotations) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_import_evaluated_annotations({ parent: parent, evaluated_annotations: evaluated_annotations }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_import_evaluated_annotations(::Google::Cloud::AIPlatform::V1::BatchImportEvaluatedAnnotationsRequest.new(parent: parent, evaluated_annotations: evaluated_annotations), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_import_evaluated_annotations_client_stub.call_count
      end
    end
  end

  def test_get_model_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ModelEvaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_get_model_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model_evaluation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model_evaluation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model_evaluation ::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model_evaluation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model_evaluation(::Google::Cloud::AIPlatform::V1::GetModelEvaluationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_evaluation_client_stub.call_count
      end
    end
  end

  def test_list_model_evaluations
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListModelEvaluationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_model_evaluations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_list_model_evaluations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_model_evaluations_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_model_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_model_evaluations parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_model_evaluations ::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_model_evaluations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_model_evaluations(::Google::Cloud::AIPlatform::V1::ListModelEvaluationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_model_evaluations_client_stub.call_count
      end
    end
  end

  def test_get_model_evaluation_slice
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ModelEvaluationSlice.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_evaluation_slice_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_get_model_evaluation_slice_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_evaluation_slice_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model_evaluation_slice({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model_evaluation_slice name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model_evaluation_slice ::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model_evaluation_slice({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model_evaluation_slice(::Google::Cloud::AIPlatform::V1::GetModelEvaluationSliceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_evaluation_slice_client_stub.call_count
      end
    end
  end

  def test_list_model_evaluation_slices
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_model_evaluation_slices_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::ModelService::Rest::ServiceStub.stub :transcode_list_model_evaluation_slices_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_model_evaluation_slices_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_model_evaluation_slices({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_model_evaluation_slices parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_model_evaluation_slices ::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_model_evaluation_slices({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_model_evaluation_slices(::Google::Cloud::AIPlatform::V1::ListModelEvaluationSlicesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_model_evaluation_slices_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelService::Rest::Client::Configuration, config
  end
end
