# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/model_garden_service_pb"
require "google/cloud/ai_platform/v1/model_garden_service"

class ::Google::Cloud::AIPlatform::V1::ModelGardenService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_publisher_model
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::PublisherModel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    language_code = "hello world"
    view = :PUBLISHER_MODEL_VIEW_UNSPECIFIED
    is_hugging_face_model = true
    hugging_face_token = "hello world"

    get_publisher_model_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_publisher_model, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetPublisherModelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["language_code"]
      assert_equal :PUBLISHER_MODEL_VIEW_UNSPECIFIED, request["view"]
      assert_equal true, request["is_hugging_face_model"]
      assert_equal "hello world", request["hugging_face_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_publisher_model_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_publisher_model({ name: name, language_code: language_code, view: view, is_hugging_face_model: is_hugging_face_model, hugging_face_token: hugging_face_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_publisher_model name: name, language_code: language_code, view: view, is_hugging_face_model: is_hugging_face_model, hugging_face_token: hugging_face_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_publisher_model ::Google::Cloud::AIPlatform::V1::GetPublisherModelRequest.new(name: name, language_code: language_code, view: view, is_hugging_face_model: is_hugging_face_model, hugging_face_token: hugging_face_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_publisher_model({ name: name, language_code: language_code, view: view, is_hugging_face_model: is_hugging_face_model, hugging_face_token: hugging_face_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_publisher_model(::Google::Cloud::AIPlatform::V1::GetPublisherModelRequest.new(name: name, language_code: language_code, view: view, is_hugging_face_model: is_hugging_face_model, hugging_face_token: hugging_face_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_publisher_model_client_stub.call_rpc_count
    end
  end

  def test_deploy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    publisher_model_name = "hello world"
    destination = "hello world"
    model_config = {}
    endpoint_config = {}
    deploy_config = {}

    deploy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeployRequest, request
      assert_equal "hello world", request["publisher_model_name"]
      assert_equal :publisher_model_name, request.artifacts
      assert_equal "hello world", request["destination"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeployRequest::ModelConfig), request["model_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeployRequest::EndpointConfig), request["endpoint_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeployRequest::DeployConfig), request["deploy_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy({ publisher_model_name: publisher_model_name, destination: destination, model_config: model_config, endpoint_config: endpoint_config, deploy_config: deploy_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy publisher_model_name: publisher_model_name, destination: destination, model_config: model_config, endpoint_config: endpoint_config, deploy_config: deploy_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy ::Google::Cloud::AIPlatform::V1::DeployRequest.new(publisher_model_name: publisher_model_name, destination: destination, model_config: model_config, endpoint_config: endpoint_config, deploy_config: deploy_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy({ publisher_model_name: publisher_model_name, destination: destination, model_config: model_config, endpoint_config: endpoint_config, deploy_config: deploy_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy(::Google::Cloud::AIPlatform::V1::DeployRequest.new(publisher_model_name: publisher_model_name, destination: destination, model_config: model_config, endpoint_config: endpoint_config, deploy_config: deploy_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::ModelGardenService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::ModelGardenService::Operations, client.operations_client
  end
end
