# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/metadata_service_pb"
require "google/cloud/ai_platform/v1/metadata_service"

class ::Google::Cloud::AIPlatform::V1::MetadataService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_metadata_store
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    metadata_store = {}
    metadata_store_id = "hello world"

    create_metadata_store_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_metadata_store, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::MetadataStore), request["metadata_store"]
      assert_equal "hello world", request["metadata_store_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_metadata_store_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_metadata_store({ parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_metadata_store parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_metadata_store ::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest.new(parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_metadata_store({ parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_metadata_store(::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest.new(parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_metadata_store_client_stub.call_rpc_count
    end
  end

  def test_get_metadata_store
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::MetadataStore.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_metadata_store_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_metadata_store, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_metadata_store_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_metadata_store({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_metadata_store name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_metadata_store ::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_metadata_store({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_metadata_store(::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_metadata_store_client_stub.call_rpc_count
    end
  end

  def test_list_metadata_stores
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListMetadataStoresResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_metadata_stores_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_metadata_stores, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_metadata_stores_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_metadata_stores({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_metadata_stores parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_metadata_stores ::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_metadata_stores({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_metadata_stores(::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_metadata_stores_client_stub.call_rpc_count
    end
  end

  def test_delete_metadata_store
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_metadata_store_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_metadata_store, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_metadata_store_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_metadata_store({ name: name, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_metadata_store name: name, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_metadata_store ::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest.new(name: name, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_metadata_store({ name: name, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_metadata_store(::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_metadata_store_client_stub.call_rpc_count
    end
  end

  def test_create_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Artifact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    artifact = {}
    artifact_id = "hello world"

    create_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_artifact, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateArtifactRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Artifact), request["artifact"]
      assert_equal "hello world", request["artifact_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_artifact parent: parent, artifact: artifact, artifact_id: artifact_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_artifact ::Google::Cloud::AIPlatform::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_artifact(::Google::Cloud::AIPlatform::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_artifact_client_stub.call_rpc_count
    end
  end

  def test_get_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Artifact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_artifact, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetArtifactRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_artifact({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_artifact name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_artifact ::Google::Cloud::AIPlatform::V1::GetArtifactRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_artifact({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_artifact(::Google::Cloud::AIPlatform::V1::GetArtifactRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_artifact_client_stub.call_rpc_count
    end
  end

  def test_list_artifacts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListArtifactsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_artifacts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_artifacts, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListArtifactsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_artifacts_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_artifacts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_artifacts ::Google::Cloud::AIPlatform::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_artifacts(::Google::Cloud::AIPlatform::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_artifacts_client_stub.call_rpc_count
    end
  end

  def test_update_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Artifact.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    artifact = {}
    update_mask = {}
    allow_missing = true

    update_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_artifact, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Artifact), request["artifact"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_artifact({ artifact: artifact, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_artifact artifact: artifact, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_artifact ::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest.new(artifact: artifact, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_artifact({ artifact: artifact, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_artifact(::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest.new(artifact: artifact, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_artifact_client_stub.call_rpc_count
    end
  end

  def test_delete_artifact
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_artifact_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_artifact, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_artifact_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_artifact({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_artifact name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_artifact ::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_artifact({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_artifact(::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_artifact_client_stub.call_rpc_count
    end
  end

  def test_purge_artifacts
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_artifacts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :purge_artifacts, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, purge_artifacts_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.purge_artifacts({ parent: parent, filter: filter, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.purge_artifacts parent: parent, filter: filter, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.purge_artifacts ::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest.new(parent: parent, filter: filter, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.purge_artifacts({ parent: parent, filter: filter, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.purge_artifacts(::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest.new(parent: parent, filter: filter, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, purge_artifacts_client_stub.call_rpc_count
    end
  end

  def test_create_context
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Context.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    context = {}
    context_id = "hello world"

    create_context_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_context, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateContextRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Context), request["context"]
      assert_equal "hello world", request["context_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_context_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_context({ parent: parent, context: context, context_id: context_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_context parent: parent, context: context, context_id: context_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_context ::Google::Cloud::AIPlatform::V1::CreateContextRequest.new(parent: parent, context: context, context_id: context_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_context({ parent: parent, context: context, context_id: context_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_context(::Google::Cloud::AIPlatform::V1::CreateContextRequest.new(parent: parent, context: context, context_id: context_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_context_client_stub.call_rpc_count
    end
  end

  def test_get_context
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Context.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_context_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_context, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetContextRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_context_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_context({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_context name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_context ::Google::Cloud::AIPlatform::V1::GetContextRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_context({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_context(::Google::Cloud::AIPlatform::V1::GetContextRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_context_client_stub.call_rpc_count
    end
  end

  def test_list_contexts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListContextsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_contexts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_contexts, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListContextsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_contexts_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_contexts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_contexts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_contexts ::Google::Cloud::AIPlatform::V1::ListContextsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_contexts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_contexts(::Google::Cloud::AIPlatform::V1::ListContextsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_contexts_client_stub.call_rpc_count
    end
  end

  def test_update_context
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Context.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    context = {}
    update_mask = {}
    allow_missing = true

    update_context_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_context, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateContextRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Context), request["context"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_context_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_context({ context: context, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_context context: context, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_context ::Google::Cloud::AIPlatform::V1::UpdateContextRequest.new(context: context, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_context({ context: context, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_context(::Google::Cloud::AIPlatform::V1::UpdateContextRequest.new(context: context, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_context_client_stub.call_rpc_count
    end
  end

  def test_delete_context
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_context_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_context, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteContextRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_context_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_context({ name: name, force: force, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_context name: name, force: force, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_context ::Google::Cloud::AIPlatform::V1::DeleteContextRequest.new(name: name, force: force, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_context({ name: name, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_context(::Google::Cloud::AIPlatform::V1::DeleteContextRequest.new(name: name, force: force, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_context_client_stub.call_rpc_count
    end
  end

  def test_purge_contexts
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_contexts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :purge_contexts, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::PurgeContextsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, purge_contexts_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.purge_contexts({ parent: parent, filter: filter, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.purge_contexts parent: parent, filter: filter, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.purge_contexts ::Google::Cloud::AIPlatform::V1::PurgeContextsRequest.new(parent: parent, filter: filter, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.purge_contexts({ parent: parent, filter: filter, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.purge_contexts(::Google::Cloud::AIPlatform::V1::PurgeContextsRequest.new(parent: parent, filter: filter, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, purge_contexts_client_stub.call_rpc_count
    end
  end

  def test_add_context_artifacts_and_executions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    context = "hello world"
    artifacts = ["hello world"]
    executions = ["hello world"]

    add_context_artifacts_and_executions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_context_artifacts_and_executions, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest, request
      assert_equal "hello world", request["context"]
      assert_equal ["hello world"], request["artifacts"]
      assert_equal ["hello world"], request["executions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_context_artifacts_and_executions_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_context_artifacts_and_executions({ context: context, artifacts: artifacts, executions: executions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_context_artifacts_and_executions context: context, artifacts: artifacts, executions: executions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_context_artifacts_and_executions ::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest.new(context: context, artifacts: artifacts, executions: executions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_context_artifacts_and_executions({ context: context, artifacts: artifacts, executions: executions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_context_artifacts_and_executions(::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest.new(context: context, artifacts: artifacts, executions: executions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_context_artifacts_and_executions_client_stub.call_rpc_count
    end
  end

  def test_add_context_children
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::AddContextChildrenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    context = "hello world"
    child_contexts = ["hello world"]

    add_context_children_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_context_children, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest, request
      assert_equal "hello world", request["context"]
      assert_equal ["hello world"], request["child_contexts"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_context_children_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_context_children({ context: context, child_contexts: child_contexts }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_context_children context: context, child_contexts: child_contexts do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_context_children ::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest.new(context: context, child_contexts: child_contexts) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_context_children({ context: context, child_contexts: child_contexts }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_context_children(::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest.new(context: context, child_contexts: child_contexts), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_context_children_client_stub.call_rpc_count
    end
  end

  def test_remove_context_children
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::RemoveContextChildrenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    context = "hello world"
    child_contexts = ["hello world"]

    remove_context_children_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :remove_context_children, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest, request
      assert_equal "hello world", request["context"]
      assert_equal ["hello world"], request["child_contexts"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, remove_context_children_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.remove_context_children({ context: context, child_contexts: child_contexts }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.remove_context_children context: context, child_contexts: child_contexts do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.remove_context_children ::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest.new(context: context, child_contexts: child_contexts) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.remove_context_children({ context: context, child_contexts: child_contexts }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.remove_context_children(::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest.new(context: context, child_contexts: child_contexts), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, remove_context_children_client_stub.call_rpc_count
    end
  end

  def test_query_context_lineage_subgraph
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::LineageSubgraph.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    context = "hello world"

    query_context_lineage_subgraph_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_context_lineage_subgraph, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest, request
      assert_equal "hello world", request["context"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_context_lineage_subgraph_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_context_lineage_subgraph({ context: context }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_context_lineage_subgraph context: context do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_context_lineage_subgraph ::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest.new(context: context) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_context_lineage_subgraph({ context: context }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_context_lineage_subgraph(::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest.new(context: context), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_context_lineage_subgraph_client_stub.call_rpc_count
    end
  end

  def test_create_execution
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Execution.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    execution = {}
    execution_id = "hello world"

    create_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_execution, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateExecutionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Execution), request["execution"]
      assert_equal "hello world", request["execution_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_execution_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_execution({ parent: parent, execution: execution, execution_id: execution_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_execution parent: parent, execution: execution, execution_id: execution_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_execution ::Google::Cloud::AIPlatform::V1::CreateExecutionRequest.new(parent: parent, execution: execution, execution_id: execution_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_execution({ parent: parent, execution: execution, execution_id: execution_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_execution(::Google::Cloud::AIPlatform::V1::CreateExecutionRequest.new(parent: parent, execution: execution, execution_id: execution_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_execution_client_stub.call_rpc_count
    end
  end

  def test_get_execution
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Execution.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_execution, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetExecutionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_execution_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_execution({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_execution name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_execution ::Google::Cloud::AIPlatform::V1::GetExecutionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_execution({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_execution(::Google::Cloud::AIPlatform::V1::GetExecutionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_execution_client_stub.call_rpc_count
    end
  end

  def test_list_executions
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListExecutionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_executions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_executions, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListExecutionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_executions_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_executions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_executions ::Google::Cloud::AIPlatform::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_executions(::Google::Cloud::AIPlatform::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_executions_client_stub.call_rpc_count
    end
  end

  def test_update_execution
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Execution.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    execution = {}
    update_mask = {}
    allow_missing = true

    update_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_execution, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Execution), request["execution"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_execution_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_execution({ execution: execution, update_mask: update_mask, allow_missing: allow_missing }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_execution execution: execution, update_mask: update_mask, allow_missing: allow_missing do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_execution ::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest.new(execution: execution, update_mask: update_mask, allow_missing: allow_missing) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_execution({ execution: execution, update_mask: update_mask, allow_missing: allow_missing }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_execution(::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest.new(execution: execution, update_mask: update_mask, allow_missing: allow_missing), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_execution_client_stub.call_rpc_count
    end
  end

  def test_delete_execution
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_execution_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_execution, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_execution_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_execution({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_execution name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_execution ::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_execution({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_execution(::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_execution_client_stub.call_rpc_count
    end
  end

  def test_purge_executions
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_executions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :purge_executions, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, purge_executions_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.purge_executions({ parent: parent, filter: filter, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.purge_executions parent: parent, filter: filter, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.purge_executions ::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest.new(parent: parent, filter: filter, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.purge_executions({ parent: parent, filter: filter, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.purge_executions(::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest.new(parent: parent, filter: filter, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, purge_executions_client_stub.call_rpc_count
    end
  end

  def test_add_execution_events
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::AddExecutionEventsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    execution = "hello world"
    events = [{}]

    add_execution_events_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :add_execution_events, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest, request
      assert_equal "hello world", request["execution"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Event, request["events"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, add_execution_events_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.add_execution_events({ execution: execution, events: events }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.add_execution_events execution: execution, events: events do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.add_execution_events ::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest.new(execution: execution, events: events) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.add_execution_events({ execution: execution, events: events }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.add_execution_events(::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest.new(execution: execution, events: events), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, add_execution_events_client_stub.call_rpc_count
    end
  end

  def test_query_execution_inputs_and_outputs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::LineageSubgraph.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    execution = "hello world"

    query_execution_inputs_and_outputs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_execution_inputs_and_outputs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest, request
      assert_equal "hello world", request["execution"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_execution_inputs_and_outputs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_execution_inputs_and_outputs({ execution: execution }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_execution_inputs_and_outputs execution: execution do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_execution_inputs_and_outputs ::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest.new(execution: execution) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_execution_inputs_and_outputs({ execution: execution }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_execution_inputs_and_outputs(::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest.new(execution: execution), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_execution_inputs_and_outputs_client_stub.call_rpc_count
    end
  end

  def test_create_metadata_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::MetadataSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    metadata_schema = {}
    metadata_schema_id = "hello world"

    create_metadata_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_metadata_schema, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::MetadataSchema), request["metadata_schema"]
      assert_equal "hello world", request["metadata_schema_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_metadata_schema_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_metadata_schema({ parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_metadata_schema parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_metadata_schema ::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest.new(parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_metadata_schema({ parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_metadata_schema(::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest.new(parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_metadata_schema_client_stub.call_rpc_count
    end
  end

  def test_get_metadata_schema
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::MetadataSchema.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_metadata_schema_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_metadata_schema, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_metadata_schema_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_metadata_schema({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_metadata_schema name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_metadata_schema ::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_metadata_schema({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_metadata_schema(::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_metadata_schema_client_stub.call_rpc_count
    end
  end

  def test_list_metadata_schemas
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListMetadataSchemasResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_metadata_schemas_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_metadata_schemas, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_metadata_schemas_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_metadata_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_metadata_schemas parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_metadata_schemas ::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_metadata_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_metadata_schemas(::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_metadata_schemas_client_stub.call_rpc_count
    end
  end

  def test_query_artifact_lineage_subgraph
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::LineageSubgraph.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    artifact = "hello world"
    max_hops = 42
    filter = "hello world"

    query_artifact_lineage_subgraph_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_artifact_lineage_subgraph, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest, request
      assert_equal "hello world", request["artifact"]
      assert_equal 42, request["max_hops"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_artifact_lineage_subgraph_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_artifact_lineage_subgraph({ artifact: artifact, max_hops: max_hops, filter: filter }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_artifact_lineage_subgraph artifact: artifact, max_hops: max_hops, filter: filter do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_artifact_lineage_subgraph ::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest.new(artifact: artifact, max_hops: max_hops, filter: filter) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_artifact_lineage_subgraph({ artifact: artifact, max_hops: max_hops, filter: filter }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_artifact_lineage_subgraph(::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest.new(artifact: artifact, max_hops: max_hops, filter: filter), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_artifact_lineage_subgraph_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::MetadataService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::MetadataService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::MetadataService::Operations, client.operations_client
  end
end
