# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/metadata_service_pb"
require "google/cloud/ai_platform/v1/metadata_service/rest"


class ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_metadata_store
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    metadata_store = {}
    metadata_store_id = "hello world"

    create_metadata_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_create_metadata_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_metadata_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_metadata_store({ parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_metadata_store parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_metadata_store ::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest.new(parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_metadata_store({ parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_metadata_store(::Google::Cloud::AIPlatform::V1::CreateMetadataStoreRequest.new(parent: parent, metadata_store: metadata_store, metadata_store_id: metadata_store_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_metadata_store_client_stub.call_count
      end
    end
  end

  def test_get_metadata_store
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::MetadataStore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_metadata_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_get_metadata_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_metadata_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_metadata_store({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_metadata_store name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_metadata_store ::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_metadata_store({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_metadata_store(::Google::Cloud::AIPlatform::V1::GetMetadataStoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_metadata_store_client_stub.call_count
      end
    end
  end

  def test_list_metadata_stores
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListMetadataStoresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_metadata_stores_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_list_metadata_stores_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_metadata_stores_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_metadata_stores({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_metadata_stores parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_metadata_stores ::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_metadata_stores({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_metadata_stores(::Google::Cloud::AIPlatform::V1::ListMetadataStoresRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_metadata_stores_client_stub.call_count
      end
    end
  end

  def test_delete_metadata_store
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_metadata_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_delete_metadata_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_metadata_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_metadata_store({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_metadata_store name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_metadata_store ::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_metadata_store({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_metadata_store(::Google::Cloud::AIPlatform::V1::DeleteMetadataStoreRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_metadata_store_client_stub.call_count
      end
    end
  end

  def test_create_artifact
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Artifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    artifact = {}
    artifact_id = "hello world"

    create_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_create_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_artifact parent: parent, artifact: artifact, artifact_id: artifact_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_artifact ::Google::Cloud::AIPlatform::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_artifact({ parent: parent, artifact: artifact, artifact_id: artifact_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_artifact(::Google::Cloud::AIPlatform::V1::CreateArtifactRequest.new(parent: parent, artifact: artifact, artifact_id: artifact_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_artifact_client_stub.call_count
      end
    end
  end

  def test_get_artifact
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Artifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_get_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_artifact({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_artifact name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_artifact ::Google::Cloud::AIPlatform::V1::GetArtifactRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_artifact({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_artifact(::Google::Cloud::AIPlatform::V1::GetArtifactRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_artifact_client_stub.call_count
      end
    end
  end

  def test_list_artifacts
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListArtifactsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_list_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_artifacts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_artifacts ::Google::Cloud::AIPlatform::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_artifacts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_artifacts(::Google::Cloud::AIPlatform::V1::ListArtifactsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_artifacts_client_stub.call_count
      end
    end
  end

  def test_update_artifact
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Artifact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    artifact = {}
    update_mask = {}
    allow_missing = true

    update_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_update_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_artifact({ artifact: artifact, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_artifact artifact: artifact, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_artifact ::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest.new(artifact: artifact, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_artifact({ artifact: artifact, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_artifact(::Google::Cloud::AIPlatform::V1::UpdateArtifactRequest.new(artifact: artifact, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_artifact_client_stub.call_count
      end
    end
  end

  def test_delete_artifact
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_artifact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_delete_artifact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_artifact_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_artifact({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_artifact name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_artifact ::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_artifact({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_artifact(::Google::Cloud::AIPlatform::V1::DeleteArtifactRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_artifact_client_stub.call_count
      end
    end
  end

  def test_purge_artifacts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_artifacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_purge_artifacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, purge_artifacts_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.purge_artifacts({ parent: parent, filter: filter, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.purge_artifacts parent: parent, filter: filter, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.purge_artifacts ::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest.new(parent: parent, filter: filter, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.purge_artifacts({ parent: parent, filter: filter, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.purge_artifacts(::Google::Cloud::AIPlatform::V1::PurgeArtifactsRequest.new(parent: parent, filter: filter, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, purge_artifacts_client_stub.call_count
      end
    end
  end

  def test_create_context
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Context.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    context = {}
    context_id = "hello world"

    create_context_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_create_context_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_context_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_context({ parent: parent, context: context, context_id: context_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_context parent: parent, context: context, context_id: context_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_context ::Google::Cloud::AIPlatform::V1::CreateContextRequest.new(parent: parent, context: context, context_id: context_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_context({ parent: parent, context: context, context_id: context_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_context(::Google::Cloud::AIPlatform::V1::CreateContextRequest.new(parent: parent, context: context, context_id: context_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_context_client_stub.call_count
      end
    end
  end

  def test_get_context
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Context.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_context_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_get_context_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_context_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_context({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_context name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_context ::Google::Cloud::AIPlatform::V1::GetContextRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_context({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_context(::Google::Cloud::AIPlatform::V1::GetContextRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_context_client_stub.call_count
      end
    end
  end

  def test_list_contexts
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListContextsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_contexts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_list_contexts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_contexts_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_contexts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_contexts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_contexts ::Google::Cloud::AIPlatform::V1::ListContextsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_contexts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_contexts(::Google::Cloud::AIPlatform::V1::ListContextsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_contexts_client_stub.call_count
      end
    end
  end

  def test_update_context
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Context.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    context = {}
    update_mask = {}
    allow_missing = true

    update_context_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_update_context_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_context_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_context({ context: context, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_context context: context, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_context ::Google::Cloud::AIPlatform::V1::UpdateContextRequest.new(context: context, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_context({ context: context, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_context(::Google::Cloud::AIPlatform::V1::UpdateContextRequest.new(context: context, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_context_client_stub.call_count
      end
    end
  end

  def test_delete_context
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true
    etag = "hello world"

    delete_context_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_delete_context_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_context_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_context({ name: name, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_context name: name, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_context ::Google::Cloud::AIPlatform::V1::DeleteContextRequest.new(name: name, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_context({ name: name, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_context(::Google::Cloud::AIPlatform::V1::DeleteContextRequest.new(name: name, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_context_client_stub.call_count
      end
    end
  end

  def test_purge_contexts
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_contexts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_purge_contexts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, purge_contexts_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.purge_contexts({ parent: parent, filter: filter, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.purge_contexts parent: parent, filter: filter, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.purge_contexts ::Google::Cloud::AIPlatform::V1::PurgeContextsRequest.new(parent: parent, filter: filter, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.purge_contexts({ parent: parent, filter: filter, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.purge_contexts(::Google::Cloud::AIPlatform::V1::PurgeContextsRequest.new(parent: parent, filter: filter, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, purge_contexts_client_stub.call_count
      end
    end
  end

  def test_add_context_artifacts_and_executions
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    context = "hello world"
    artifacts = ["hello world"]
    executions = ["hello world"]

    add_context_artifacts_and_executions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_add_context_artifacts_and_executions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_context_artifacts_and_executions_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_context_artifacts_and_executions({ context: context, artifacts: artifacts, executions: executions }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_context_artifacts_and_executions context: context, artifacts: artifacts, executions: executions do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_context_artifacts_and_executions ::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest.new(context: context, artifacts: artifacts, executions: executions) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_context_artifacts_and_executions({ context: context, artifacts: artifacts, executions: executions }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_context_artifacts_and_executions(::Google::Cloud::AIPlatform::V1::AddContextArtifactsAndExecutionsRequest.new(context: context, artifacts: artifacts, executions: executions), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_context_artifacts_and_executions_client_stub.call_count
      end
    end
  end

  def test_add_context_children
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::AddContextChildrenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    context = "hello world"
    child_contexts = ["hello world"]

    add_context_children_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_add_context_children_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_context_children_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_context_children({ context: context, child_contexts: child_contexts }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_context_children context: context, child_contexts: child_contexts do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_context_children ::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest.new(context: context, child_contexts: child_contexts) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_context_children({ context: context, child_contexts: child_contexts }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_context_children(::Google::Cloud::AIPlatform::V1::AddContextChildrenRequest.new(context: context, child_contexts: child_contexts), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_context_children_client_stub.call_count
      end
    end
  end

  def test_remove_context_children
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::RemoveContextChildrenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    context = "hello world"
    child_contexts = ["hello world"]

    remove_context_children_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_remove_context_children_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_context_children_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_context_children({ context: context, child_contexts: child_contexts }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_context_children context: context, child_contexts: child_contexts do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_context_children ::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest.new(context: context, child_contexts: child_contexts) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_context_children({ context: context, child_contexts: child_contexts }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_context_children(::Google::Cloud::AIPlatform::V1::RemoveContextChildrenRequest.new(context: context, child_contexts: child_contexts), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_context_children_client_stub.call_count
      end
    end
  end

  def test_query_context_lineage_subgraph
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::LineageSubgraph.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    context = "hello world"

    query_context_lineage_subgraph_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_query_context_lineage_subgraph_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_context_lineage_subgraph_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_context_lineage_subgraph({ context: context }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_context_lineage_subgraph context: context do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_context_lineage_subgraph ::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest.new(context: context) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_context_lineage_subgraph({ context: context }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_context_lineage_subgraph(::Google::Cloud::AIPlatform::V1::QueryContextLineageSubgraphRequest.new(context: context), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_context_lineage_subgraph_client_stub.call_count
      end
    end
  end

  def test_create_execution
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Execution.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    execution = {}
    execution_id = "hello world"

    create_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_create_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_execution_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_execution({ parent: parent, execution: execution, execution_id: execution_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_execution parent: parent, execution: execution, execution_id: execution_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_execution ::Google::Cloud::AIPlatform::V1::CreateExecutionRequest.new(parent: parent, execution: execution, execution_id: execution_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_execution({ parent: parent, execution: execution, execution_id: execution_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_execution(::Google::Cloud::AIPlatform::V1::CreateExecutionRequest.new(parent: parent, execution: execution, execution_id: execution_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_execution_client_stub.call_count
      end
    end
  end

  def test_get_execution
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Execution.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_get_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_execution_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_execution({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_execution name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_execution ::Google::Cloud::AIPlatform::V1::GetExecutionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_execution({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_execution(::Google::Cloud::AIPlatform::V1::GetExecutionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_execution_client_stub.call_count
      end
    end
  end

  def test_list_executions
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListExecutionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_executions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_list_executions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_executions_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_executions parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_executions ::Google::Cloud::AIPlatform::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_executions({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_executions(::Google::Cloud::AIPlatform::V1::ListExecutionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_executions_client_stub.call_count
      end
    end
  end

  def test_update_execution
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Execution.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    execution = {}
    update_mask = {}
    allow_missing = true

    update_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_update_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_execution_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_execution({ execution: execution, update_mask: update_mask, allow_missing: allow_missing }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_execution execution: execution, update_mask: update_mask, allow_missing: allow_missing do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_execution ::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest.new(execution: execution, update_mask: update_mask, allow_missing: allow_missing) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_execution({ execution: execution, update_mask: update_mask, allow_missing: allow_missing }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_execution(::Google::Cloud::AIPlatform::V1::UpdateExecutionRequest.new(execution: execution, update_mask: update_mask, allow_missing: allow_missing), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_execution_client_stub.call_count
      end
    end
  end

  def test_delete_execution
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_execution_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_delete_execution_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_execution_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_execution({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_execution name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_execution ::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_execution({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_execution(::Google::Cloud::AIPlatform::V1::DeleteExecutionRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_execution_client_stub.call_count
      end
    end
  end

  def test_purge_executions
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    force = true

    purge_executions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_purge_executions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, purge_executions_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.purge_executions({ parent: parent, filter: filter, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.purge_executions parent: parent, filter: filter, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.purge_executions ::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest.new(parent: parent, filter: filter, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.purge_executions({ parent: parent, filter: filter, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.purge_executions(::Google::Cloud::AIPlatform::V1::PurgeExecutionsRequest.new(parent: parent, filter: filter, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, purge_executions_client_stub.call_count
      end
    end
  end

  def test_add_execution_events
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::AddExecutionEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    execution = "hello world"
    events = [{}]

    add_execution_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_add_execution_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, add_execution_events_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.add_execution_events({ execution: execution, events: events }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.add_execution_events execution: execution, events: events do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.add_execution_events ::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest.new(execution: execution, events: events) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.add_execution_events({ execution: execution, events: events }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.add_execution_events(::Google::Cloud::AIPlatform::V1::AddExecutionEventsRequest.new(execution: execution, events: events), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, add_execution_events_client_stub.call_count
      end
    end
  end

  def test_query_execution_inputs_and_outputs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::LineageSubgraph.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    execution = "hello world"

    query_execution_inputs_and_outputs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_query_execution_inputs_and_outputs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_execution_inputs_and_outputs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_execution_inputs_and_outputs({ execution: execution }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_execution_inputs_and_outputs execution: execution do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_execution_inputs_and_outputs ::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest.new(execution: execution) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_execution_inputs_and_outputs({ execution: execution }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_execution_inputs_and_outputs(::Google::Cloud::AIPlatform::V1::QueryExecutionInputsAndOutputsRequest.new(execution: execution), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_execution_inputs_and_outputs_client_stub.call_count
      end
    end
  end

  def test_create_metadata_schema
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::MetadataSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    metadata_schema = {}
    metadata_schema_id = "hello world"

    create_metadata_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_create_metadata_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_metadata_schema_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_metadata_schema({ parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_metadata_schema parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_metadata_schema ::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest.new(parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_metadata_schema({ parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_metadata_schema(::Google::Cloud::AIPlatform::V1::CreateMetadataSchemaRequest.new(parent: parent, metadata_schema: metadata_schema, metadata_schema_id: metadata_schema_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_metadata_schema_client_stub.call_count
      end
    end
  end

  def test_get_metadata_schema
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::MetadataSchema.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_metadata_schema_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_get_metadata_schema_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_metadata_schema_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_metadata_schema({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_metadata_schema name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_metadata_schema ::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_metadata_schema({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_metadata_schema(::Google::Cloud::AIPlatform::V1::GetMetadataSchemaRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_metadata_schema_client_stub.call_count
      end
    end
  end

  def test_list_metadata_schemas
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListMetadataSchemasResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_metadata_schemas_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_list_metadata_schemas_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_metadata_schemas_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_metadata_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_metadata_schemas parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_metadata_schemas ::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_metadata_schemas({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_metadata_schemas(::Google::Cloud::AIPlatform::V1::ListMetadataSchemasRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_metadata_schemas_client_stub.call_count
      end
    end
  end

  def test_query_artifact_lineage_subgraph
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::LineageSubgraph.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    artifact = "hello world"
    max_hops = 42
    filter = "hello world"

    query_artifact_lineage_subgraph_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::ServiceStub.stub :transcode_query_artifact_lineage_subgraph_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, query_artifact_lineage_subgraph_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.query_artifact_lineage_subgraph({ artifact: artifact, max_hops: max_hops, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.query_artifact_lineage_subgraph artifact: artifact, max_hops: max_hops, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.query_artifact_lineage_subgraph ::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest.new(artifact: artifact, max_hops: max_hops, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.query_artifact_lineage_subgraph({ artifact: artifact, max_hops: max_hops, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.query_artifact_lineage_subgraph(::Google::Cloud::AIPlatform::V1::QueryArtifactLineageSubgraphRequest.new(artifact: artifact, max_hops: max_hops, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, query_artifact_lineage_subgraph_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::MetadataService::Rest::Client::Configuration, config
  end
end
