# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/match_service_pb"
require "google/cloud/ai_platform/v1/match_service"

class ::Google::Cloud::AIPlatform::V1::MatchService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_find_neighbors
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::FindNeighborsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index_id = "hello world"
    queries = [{}]
    return_full_datapoint = true

    find_neighbors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :find_neighbors, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::FindNeighborsRequest, request
      assert_equal "hello world", request["index_endpoint"]
      assert_equal "hello world", request["deployed_index_id"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::FindNeighborsRequest::Query, request["queries"].first
      assert_equal true, request["return_full_datapoint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, find_neighbors_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MatchService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.find_neighbors({ index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, queries: queries, return_full_datapoint: return_full_datapoint }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.find_neighbors index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, queries: queries, return_full_datapoint: return_full_datapoint do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.find_neighbors ::Google::Cloud::AIPlatform::V1::FindNeighborsRequest.new(index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, queries: queries, return_full_datapoint: return_full_datapoint) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.find_neighbors({ index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, queries: queries, return_full_datapoint: return_full_datapoint }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.find_neighbors(::Google::Cloud::AIPlatform::V1::FindNeighborsRequest.new(index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, queries: queries, return_full_datapoint: return_full_datapoint), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, find_neighbors_client_stub.call_rpc_count
    end
  end

  def test_read_index_datapoints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ReadIndexDatapointsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index_id = "hello world"
    ids = ["hello world"]

    read_index_datapoints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :read_index_datapoints, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ReadIndexDatapointsRequest, request
      assert_equal "hello world", request["index_endpoint"]
      assert_equal "hello world", request["deployed_index_id"]
      assert_equal ["hello world"], request["ids"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, read_index_datapoints_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::MatchService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.read_index_datapoints({ index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, ids: ids }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.read_index_datapoints index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, ids: ids do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.read_index_datapoints ::Google::Cloud::AIPlatform::V1::ReadIndexDatapointsRequest.new(index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, ids: ids) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.read_index_datapoints({ index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, ids: ids }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.read_index_datapoints(::Google::Cloud::AIPlatform::V1::ReadIndexDatapointsRequest.new(index_endpoint: index_endpoint, deployed_index_id: deployed_index_id, ids: ids), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, read_index_datapoints_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::MatchService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::MatchService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::MatchService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::MatchService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
