# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/llm_utility_service_pb"
require "google/cloud/ai_platform/v1/llm_utility_service"

class ::Google::Cloud::AIPlatform::V1::LlmUtilityService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_count_tokens
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::CountTokensResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    model = "hello world"
    instances = [{}]
    contents = [{}]
    system_instruction = {}
    tools = [{}]
    generation_config = {}

    count_tokens_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :count_tokens, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CountTokensRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_equal "hello world", request["model"]
      assert_kind_of ::Google::Protobuf::Value, request["instances"].first
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Content, request["contents"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Content), request["system_instruction"]
      assert request.has_system_instruction?
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Tool, request["tools"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::GenerationConfig), request["generation_config"]
      assert request.has_generation_config?
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, count_tokens_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::LlmUtilityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.count_tokens({ endpoint: endpoint, model: model, instances: instances, contents: contents, system_instruction: system_instruction, tools: tools, generation_config: generation_config }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.count_tokens endpoint: endpoint, model: model, instances: instances, contents: contents, system_instruction: system_instruction, tools: tools, generation_config: generation_config do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.count_tokens ::Google::Cloud::AIPlatform::V1::CountTokensRequest.new(endpoint: endpoint, model: model, instances: instances, contents: contents, system_instruction: system_instruction, tools: tools, generation_config: generation_config) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.count_tokens({ endpoint: endpoint, model: model, instances: instances, contents: contents, system_instruction: system_instruction, tools: tools, generation_config: generation_config }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.count_tokens(::Google::Cloud::AIPlatform::V1::CountTokensRequest.new(endpoint: endpoint, model: model, instances: instances, contents: contents, system_instruction: system_instruction, tools: tools, generation_config: generation_config), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, count_tokens_client_stub.call_rpc_count
    end
  end

  def test_compute_tokens
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ComputeTokensResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    endpoint = "hello world"
    instances = [{}]
    model = "hello world"
    contents = [{}]

    compute_tokens_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :compute_tokens, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ComputeTokensRequest, request
      assert_equal "hello world", request["endpoint"]
      assert_kind_of ::Google::Protobuf::Value, request["instances"].first
      assert_equal "hello world", request["model"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::Content, request["contents"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, compute_tokens_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::LlmUtilityService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.compute_tokens({ endpoint: endpoint, instances: instances, model: model, contents: contents }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.compute_tokens endpoint: endpoint, instances: instances, model: model, contents: contents do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.compute_tokens ::Google::Cloud::AIPlatform::V1::ComputeTokensRequest.new(endpoint: endpoint, instances: instances, model: model, contents: contents) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.compute_tokens({ endpoint: endpoint, instances: instances, model: model, contents: contents }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.compute_tokens(::Google::Cloud::AIPlatform::V1::ComputeTokensRequest.new(endpoint: endpoint, instances: instances, model: model, contents: contents), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, compute_tokens_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::LlmUtilityService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::LlmUtilityService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::LlmUtilityService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::LlmUtilityService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
