# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/job_service_pb"
require "google/cloud/ai_platform/v1/job_service"

class ::Google::Cloud::AIPlatform::V1::JobService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_custom_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::CustomJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_job = {}

    create_custom_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::CustomJob), request["custom_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_job({ parent: parent, custom_job: custom_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_job parent: parent, custom_job: custom_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_job ::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest.new(parent: parent, custom_job: custom_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_job({ parent: parent, custom_job: custom_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_job(::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest.new(parent: parent, custom_job: custom_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_job_client_stub.call_rpc_count
    end
  end

  def test_get_custom_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::CustomJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetCustomJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_job ::Google::Cloud::AIPlatform::V1::GetCustomJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_job(::Google::Cloud::AIPlatform::V1::GetCustomJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_job_client_stub.call_rpc_count
    end
  end

  def test_list_custom_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListCustomJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_custom_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_jobs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_jobs ::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_jobs(::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_jobs_client_stub.call_rpc_count
    end
  end

  def test_delete_custom_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_custom_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_custom_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_custom_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_custom_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_custom_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_custom_job ::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_custom_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_custom_job(::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_custom_job_client_stub.call_rpc_count
    end
  end

  def test_cancel_custom_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_custom_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_custom_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_custom_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_custom_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_custom_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_custom_job ::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_custom_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_custom_job(::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_custom_job_client_stub.call_rpc_count
    end
  end

  def test_create_data_labeling_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::DataLabelingJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_labeling_job = {}

    create_data_labeling_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_labeling_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DataLabelingJob), request["data_labeling_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_labeling_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_labeling_job({ parent: parent, data_labeling_job: data_labeling_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_labeling_job parent: parent, data_labeling_job: data_labeling_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_labeling_job ::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest.new(parent: parent, data_labeling_job: data_labeling_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_labeling_job({ parent: parent, data_labeling_job: data_labeling_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_labeling_job(::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest.new(parent: parent, data_labeling_job: data_labeling_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_labeling_job_client_stub.call_rpc_count
    end
  end

  def test_get_data_labeling_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::DataLabelingJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_labeling_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_labeling_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_labeling_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_labeling_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_labeling_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_labeling_job ::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_labeling_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_labeling_job(::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_labeling_job_client_stub.call_rpc_count
    end
  end

  def test_list_data_labeling_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_data_labeling_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_labeling_jobs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_labeling_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_labeling_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_labeling_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_labeling_jobs ::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_labeling_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_labeling_jobs(::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_labeling_jobs_client_stub.call_rpc_count
    end
  end

  def test_delete_data_labeling_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_labeling_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_labeling_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_labeling_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_labeling_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_labeling_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_labeling_job ::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_labeling_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_labeling_job(::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_labeling_job_client_stub.call_rpc_count
    end
  end

  def test_cancel_data_labeling_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_data_labeling_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_data_labeling_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_data_labeling_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_data_labeling_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_data_labeling_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_data_labeling_job ::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_data_labeling_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_data_labeling_job(::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_data_labeling_job_client_stub.call_rpc_count
    end
  end

  def test_create_hyperparameter_tuning_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hyperparameter_tuning_job = {}

    create_hyperparameter_tuning_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_hyperparameter_tuning_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob), request["hyperparameter_tuning_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_hyperparameter_tuning_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_hyperparameter_tuning_job({ parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_hyperparameter_tuning_job parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest.new(parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_hyperparameter_tuning_job({ parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest.new(parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_hyperparameter_tuning_job_client_stub.call_rpc_count
    end
  end

  def test_get_hyperparameter_tuning_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hyperparameter_tuning_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_hyperparameter_tuning_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_hyperparameter_tuning_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_hyperparameter_tuning_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_hyperparameter_tuning_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_hyperparameter_tuning_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_hyperparameter_tuning_job_client_stub.call_rpc_count
    end
  end

  def test_list_hyperparameter_tuning_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_hyperparameter_tuning_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_hyperparameter_tuning_jobs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_hyperparameter_tuning_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_hyperparameter_tuning_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_hyperparameter_tuning_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_hyperparameter_tuning_jobs ::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_hyperparameter_tuning_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_hyperparameter_tuning_jobs(::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_hyperparameter_tuning_jobs_client_stub.call_rpc_count
    end
  end

  def test_delete_hyperparameter_tuning_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_hyperparameter_tuning_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_hyperparameter_tuning_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_hyperparameter_tuning_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_hyperparameter_tuning_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_hyperparameter_tuning_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_hyperparameter_tuning_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_hyperparameter_tuning_job_client_stub.call_rpc_count
    end
  end

  def test_cancel_hyperparameter_tuning_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_hyperparameter_tuning_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_hyperparameter_tuning_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_hyperparameter_tuning_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_hyperparameter_tuning_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_hyperparameter_tuning_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_hyperparameter_tuning_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_hyperparameter_tuning_job_client_stub.call_rpc_count
    end
  end

  def test_create_nas_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::NasJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    nas_job = {}

    create_nas_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_nas_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateNasJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::NasJob), request["nas_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_nas_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_nas_job({ parent: parent, nas_job: nas_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_nas_job parent: parent, nas_job: nas_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_nas_job ::Google::Cloud::AIPlatform::V1::CreateNasJobRequest.new(parent: parent, nas_job: nas_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_nas_job({ parent: parent, nas_job: nas_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_nas_job(::Google::Cloud::AIPlatform::V1::CreateNasJobRequest.new(parent: parent, nas_job: nas_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_nas_job_client_stub.call_rpc_count
    end
  end

  def test_get_nas_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::NasJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_nas_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_nas_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetNasJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_nas_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_nas_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_nas_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_nas_job ::Google::Cloud::AIPlatform::V1::GetNasJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_nas_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_nas_job(::Google::Cloud::AIPlatform::V1::GetNasJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_nas_job_client_stub.call_rpc_count
    end
  end

  def test_list_nas_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListNasJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_nas_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_nas_jobs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListNasJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_nas_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_nas_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_nas_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_nas_jobs ::Google::Cloud::AIPlatform::V1::ListNasJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_nas_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_nas_jobs(::Google::Cloud::AIPlatform::V1::ListNasJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_nas_jobs_client_stub.call_rpc_count
    end
  end

  def test_delete_nas_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_nas_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_nas_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_nas_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_nas_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_nas_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_nas_job ::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_nas_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_nas_job(::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_nas_job_client_stub.call_rpc_count
    end
  end

  def test_cancel_nas_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_nas_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_nas_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CancelNasJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_nas_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_nas_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_nas_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_nas_job ::Google::Cloud::AIPlatform::V1::CancelNasJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_nas_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_nas_job(::Google::Cloud::AIPlatform::V1::CancelNasJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_nas_job_client_stub.call_rpc_count
    end
  end

  def test_get_nas_trial_detail
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::NasTrialDetail.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_nas_trial_detail_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_nas_trial_detail, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_nas_trial_detail_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_nas_trial_detail({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_nas_trial_detail name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_nas_trial_detail ::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_nas_trial_detail({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_nas_trial_detail(::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_nas_trial_detail_client_stub.call_rpc_count
    end
  end

  def test_list_nas_trial_details
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_nas_trial_details_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_nas_trial_details, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_nas_trial_details_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_nas_trial_details({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_nas_trial_details parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_nas_trial_details ::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_nas_trial_details({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_nas_trial_details(::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_nas_trial_details_client_stub.call_rpc_count
    end
  end

  def test_create_batch_prediction_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchPredictionJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    batch_prediction_job = {}

    create_batch_prediction_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_batch_prediction_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::BatchPredictionJob), request["batch_prediction_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_batch_prediction_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_batch_prediction_job({ parent: parent, batch_prediction_job: batch_prediction_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_batch_prediction_job parent: parent, batch_prediction_job: batch_prediction_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_batch_prediction_job ::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest.new(parent: parent, batch_prediction_job: batch_prediction_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_batch_prediction_job({ parent: parent, batch_prediction_job: batch_prediction_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_batch_prediction_job(::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest.new(parent: parent, batch_prediction_job: batch_prediction_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_batch_prediction_job_client_stub.call_rpc_count
    end
  end

  def test_get_batch_prediction_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::BatchPredictionJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_batch_prediction_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_batch_prediction_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_batch_prediction_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_batch_prediction_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_batch_prediction_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_batch_prediction_job ::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_batch_prediction_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_batch_prediction_job(::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_batch_prediction_job_client_stub.call_rpc_count
    end
  end

  def test_list_batch_prediction_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_batch_prediction_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_batch_prediction_jobs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_batch_prediction_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_batch_prediction_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_batch_prediction_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_batch_prediction_jobs ::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_batch_prediction_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_batch_prediction_jobs(::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_batch_prediction_jobs_client_stub.call_rpc_count
    end
  end

  def test_delete_batch_prediction_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_batch_prediction_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_batch_prediction_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_batch_prediction_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_batch_prediction_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_batch_prediction_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_batch_prediction_job ::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_batch_prediction_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_batch_prediction_job(::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_batch_prediction_job_client_stub.call_rpc_count
    end
  end

  def test_cancel_batch_prediction_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_batch_prediction_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_batch_prediction_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_batch_prediction_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_batch_prediction_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_batch_prediction_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_batch_prediction_job ::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_batch_prediction_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_batch_prediction_job(::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_batch_prediction_job_client_stub.call_rpc_count
    end
  end

  def test_create_model_deployment_monitoring_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_deployment_monitoring_job = {}

    create_model_deployment_monitoring_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_model_deployment_monitoring_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob), request["model_deployment_monitoring_job"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_model_deployment_monitoring_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_model_deployment_monitoring_job({ parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_model_deployment_monitoring_job parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest.new(parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_model_deployment_monitoring_job({ parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest.new(parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_model_deployment_monitoring_job_client_stub.call_rpc_count
    end
  end

  def test_search_model_deployment_monitoring_stats_anomalies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model_deployment_monitoring_job = "hello world"
    deployed_model_id = "hello world"
    feature_display_name = "hello world"
    objectives = [{}]
    page_size = 42
    page_token = "hello world"
    start_time = {}
    end_time = {}

    search_model_deployment_monitoring_stats_anomalies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_model_deployment_monitoring_stats_anomalies, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest, request
      assert_equal "hello world", request["model_deployment_monitoring_job"]
      assert_equal "hello world", request["deployed_model_id"]
      assert_equal "hello world", request["feature_display_name"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest::StatsAnomaliesObjective, request["objectives"].first
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["end_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_model_deployment_monitoring_stats_anomalies_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_model_deployment_monitoring_stats_anomalies({ model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_model_deployment_monitoring_stats_anomalies model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_model_deployment_monitoring_stats_anomalies ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_model_deployment_monitoring_stats_anomalies({ model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_model_deployment_monitoring_stats_anomalies(::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_model_deployment_monitoring_stats_anomalies_client_stub.call_rpc_count
    end
  end

  def test_get_model_deployment_monitoring_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_deployment_monitoring_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_model_deployment_monitoring_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_model_deployment_monitoring_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_model_deployment_monitoring_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_model_deployment_monitoring_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_model_deployment_monitoring_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_model_deployment_monitoring_job_client_stub.call_rpc_count
    end
  end

  def test_list_model_deployment_monitoring_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_model_deployment_monitoring_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_model_deployment_monitoring_jobs, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_model_deployment_monitoring_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_model_deployment_monitoring_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_model_deployment_monitoring_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_model_deployment_monitoring_jobs ::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_model_deployment_monitoring_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_model_deployment_monitoring_jobs(::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_model_deployment_monitoring_jobs_client_stub.call_rpc_count
    end
  end

  def test_update_model_deployment_monitoring_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    model_deployment_monitoring_job = {}
    update_mask = {}

    update_model_deployment_monitoring_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_model_deployment_monitoring_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob), request["model_deployment_monitoring_job"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_model_deployment_monitoring_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_model_deployment_monitoring_job({ model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_model_deployment_monitoring_job model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_model_deployment_monitoring_job({ model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_model_deployment_monitoring_job_client_stub.call_rpc_count
    end
  end

  def test_delete_model_deployment_monitoring_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_deployment_monitoring_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_model_deployment_monitoring_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_model_deployment_monitoring_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_model_deployment_monitoring_job({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_model_deployment_monitoring_job name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_model_deployment_monitoring_job({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_model_deployment_monitoring_job_client_stub.call_rpc_count
    end
  end

  def test_pause_model_deployment_monitoring_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    pause_model_deployment_monitoring_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :pause_model_deployment_monitoring_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, pause_model_deployment_monitoring_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.pause_model_deployment_monitoring_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.pause_model_deployment_monitoring_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.pause_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.pause_model_deployment_monitoring_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.pause_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, pause_model_deployment_monitoring_job_client_stub.call_rpc_count
    end
  end

  def test_resume_model_deployment_monitoring_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_model_deployment_monitoring_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resume_model_deployment_monitoring_job, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resume_model_deployment_monitoring_job_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resume_model_deployment_monitoring_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resume_model_deployment_monitoring_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resume_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resume_model_deployment_monitoring_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resume_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resume_model_deployment_monitoring_job_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::JobService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::JobService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::JobService::Operations, client.operations_client
  end
end
