# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/job_service_pb"
require "google/cloud/ai_platform/v1/job_service/rest"


class ::Google::Cloud::AIPlatform::V1::JobService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_custom_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::CustomJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_job = {}

    create_custom_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_create_custom_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_custom_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_custom_job({ parent: parent, custom_job: custom_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_custom_job parent: parent, custom_job: custom_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_custom_job ::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest.new(parent: parent, custom_job: custom_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_custom_job({ parent: parent, custom_job: custom_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_custom_job(::Google::Cloud::AIPlatform::V1::CreateCustomJobRequest.new(parent: parent, custom_job: custom_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_custom_job_client_stub.call_count
      end
    end
  end

  def test_get_custom_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::CustomJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_custom_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_custom_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_custom_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_custom_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_custom_job ::Google::Cloud::AIPlatform::V1::GetCustomJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_custom_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_custom_job(::Google::Cloud::AIPlatform::V1::GetCustomJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_custom_job_client_stub.call_count
      end
    end
  end

  def test_list_custom_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListCustomJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_custom_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_custom_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_custom_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_custom_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_custom_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_custom_jobs ::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_custom_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_custom_jobs(::Google::Cloud::AIPlatform::V1::ListCustomJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_custom_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_custom_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_custom_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_delete_custom_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_custom_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_custom_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_custom_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_custom_job ::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_custom_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_custom_job(::Google::Cloud::AIPlatform::V1::DeleteCustomJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_custom_job_client_stub.call_count
      end
    end
  end

  def test_cancel_custom_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_custom_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_cancel_custom_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_custom_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_custom_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_custom_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_custom_job ::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_custom_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_custom_job(::Google::Cloud::AIPlatform::V1::CancelCustomJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_custom_job_client_stub.call_count
      end
    end
  end

  def test_create_data_labeling_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::DataLabelingJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_labeling_job = {}

    create_data_labeling_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_create_data_labeling_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_labeling_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_labeling_job({ parent: parent, data_labeling_job: data_labeling_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_labeling_job parent: parent, data_labeling_job: data_labeling_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_labeling_job ::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest.new(parent: parent, data_labeling_job: data_labeling_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_labeling_job({ parent: parent, data_labeling_job: data_labeling_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_labeling_job(::Google::Cloud::AIPlatform::V1::CreateDataLabelingJobRequest.new(parent: parent, data_labeling_job: data_labeling_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_labeling_job_client_stub.call_count
      end
    end
  end

  def test_get_data_labeling_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::DataLabelingJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_labeling_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_data_labeling_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_labeling_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_labeling_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_labeling_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_labeling_job ::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_labeling_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_labeling_job(::Google::Cloud::AIPlatform::V1::GetDataLabelingJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_labeling_job_client_stub.call_count
      end
    end
  end

  def test_list_data_labeling_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_data_labeling_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_data_labeling_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_labeling_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_labeling_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_labeling_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_labeling_jobs ::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_labeling_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_labeling_jobs(::Google::Cloud::AIPlatform::V1::ListDataLabelingJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_labeling_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_data_labeling_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_data_labeling_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_delete_data_labeling_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_labeling_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_labeling_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_labeling_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_labeling_job ::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_labeling_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_labeling_job(::Google::Cloud::AIPlatform::V1::DeleteDataLabelingJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_labeling_job_client_stub.call_count
      end
    end
  end

  def test_cancel_data_labeling_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_data_labeling_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_cancel_data_labeling_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_data_labeling_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_data_labeling_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_data_labeling_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_data_labeling_job ::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_data_labeling_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_data_labeling_job(::Google::Cloud::AIPlatform::V1::CancelDataLabelingJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_data_labeling_job_client_stub.call_count
      end
    end
  end

  def test_create_hyperparameter_tuning_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    hyperparameter_tuning_job = {}

    create_hyperparameter_tuning_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_create_hyperparameter_tuning_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_hyperparameter_tuning_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_hyperparameter_tuning_job({ parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_hyperparameter_tuning_job parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest.new(parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_hyperparameter_tuning_job({ parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::CreateHyperparameterTuningJobRequest.new(parent: parent, hyperparameter_tuning_job: hyperparameter_tuning_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_hyperparameter_tuning_job_client_stub.call_count
      end
    end
  end

  def test_get_hyperparameter_tuning_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::HyperparameterTuningJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_hyperparameter_tuning_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_hyperparameter_tuning_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_hyperparameter_tuning_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_hyperparameter_tuning_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_hyperparameter_tuning_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_hyperparameter_tuning_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::GetHyperparameterTuningJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_hyperparameter_tuning_job_client_stub.call_count
      end
    end
  end

  def test_list_hyperparameter_tuning_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_hyperparameter_tuning_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_hyperparameter_tuning_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_hyperparameter_tuning_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_hyperparameter_tuning_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_hyperparameter_tuning_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_hyperparameter_tuning_jobs ::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_hyperparameter_tuning_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_hyperparameter_tuning_jobs(::Google::Cloud::AIPlatform::V1::ListHyperparameterTuningJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_hyperparameter_tuning_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_hyperparameter_tuning_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_hyperparameter_tuning_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_delete_hyperparameter_tuning_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_hyperparameter_tuning_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_hyperparameter_tuning_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_hyperparameter_tuning_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_hyperparameter_tuning_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::DeleteHyperparameterTuningJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_hyperparameter_tuning_job_client_stub.call_count
      end
    end
  end

  def test_cancel_hyperparameter_tuning_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_hyperparameter_tuning_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_cancel_hyperparameter_tuning_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_hyperparameter_tuning_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_hyperparameter_tuning_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_hyperparameter_tuning_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_hyperparameter_tuning_job ::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_hyperparameter_tuning_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_hyperparameter_tuning_job(::Google::Cloud::AIPlatform::V1::CancelHyperparameterTuningJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_hyperparameter_tuning_job_client_stub.call_count
      end
    end
  end

  def test_create_nas_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NasJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    nas_job = {}

    create_nas_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_create_nas_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_nas_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_nas_job({ parent: parent, nas_job: nas_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_nas_job parent: parent, nas_job: nas_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_nas_job ::Google::Cloud::AIPlatform::V1::CreateNasJobRequest.new(parent: parent, nas_job: nas_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_nas_job({ parent: parent, nas_job: nas_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_nas_job(::Google::Cloud::AIPlatform::V1::CreateNasJobRequest.new(parent: parent, nas_job: nas_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_nas_job_client_stub.call_count
      end
    end
  end

  def test_get_nas_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NasJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_nas_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_nas_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_nas_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_nas_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_nas_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_nas_job ::Google::Cloud::AIPlatform::V1::GetNasJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_nas_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_nas_job(::Google::Cloud::AIPlatform::V1::GetNasJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_nas_job_client_stub.call_count
      end
    end
  end

  def test_list_nas_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListNasJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_nas_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_nas_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_nas_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_nas_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_nas_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_nas_jobs ::Google::Cloud::AIPlatform::V1::ListNasJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_nas_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_nas_jobs(::Google::Cloud::AIPlatform::V1::ListNasJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_nas_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_nas_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_nas_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_delete_nas_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_nas_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_nas_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_nas_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_nas_job ::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_nas_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_nas_job(::Google::Cloud::AIPlatform::V1::DeleteNasJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_nas_job_client_stub.call_count
      end
    end
  end

  def test_cancel_nas_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_nas_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_cancel_nas_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_nas_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_nas_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_nas_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_nas_job ::Google::Cloud::AIPlatform::V1::CancelNasJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_nas_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_nas_job(::Google::Cloud::AIPlatform::V1::CancelNasJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_nas_job_client_stub.call_count
      end
    end
  end

  def test_get_nas_trial_detail
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::NasTrialDetail.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_nas_trial_detail_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_nas_trial_detail_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_nas_trial_detail_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_nas_trial_detail({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_nas_trial_detail name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_nas_trial_detail ::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_nas_trial_detail({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_nas_trial_detail(::Google::Cloud::AIPlatform::V1::GetNasTrialDetailRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_nas_trial_detail_client_stub.call_count
      end
    end
  end

  def test_list_nas_trial_details
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_nas_trial_details_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_nas_trial_details_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_nas_trial_details_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_nas_trial_details({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_nas_trial_details parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_nas_trial_details ::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_nas_trial_details({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_nas_trial_details(::Google::Cloud::AIPlatform::V1::ListNasTrialDetailsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_nas_trial_details_client_stub.call_count
      end
    end
  end

  def test_create_batch_prediction_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchPredictionJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    batch_prediction_job = {}

    create_batch_prediction_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_create_batch_prediction_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_batch_prediction_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_batch_prediction_job({ parent: parent, batch_prediction_job: batch_prediction_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_batch_prediction_job parent: parent, batch_prediction_job: batch_prediction_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_batch_prediction_job ::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest.new(parent: parent, batch_prediction_job: batch_prediction_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_batch_prediction_job({ parent: parent, batch_prediction_job: batch_prediction_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_batch_prediction_job(::Google::Cloud::AIPlatform::V1::CreateBatchPredictionJobRequest.new(parent: parent, batch_prediction_job: batch_prediction_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_batch_prediction_job_client_stub.call_count
      end
    end
  end

  def test_get_batch_prediction_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::BatchPredictionJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_batch_prediction_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_batch_prediction_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_batch_prediction_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_batch_prediction_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_batch_prediction_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_batch_prediction_job ::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_batch_prediction_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_batch_prediction_job(::Google::Cloud::AIPlatform::V1::GetBatchPredictionJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_batch_prediction_job_client_stub.call_count
      end
    end
  end

  def test_list_batch_prediction_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_batch_prediction_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_batch_prediction_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_batch_prediction_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_batch_prediction_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_batch_prediction_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_batch_prediction_jobs ::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_batch_prediction_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_batch_prediction_jobs(::Google::Cloud::AIPlatform::V1::ListBatchPredictionJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_batch_prediction_jobs_client_stub.call_count
      end
    end
  end

  def test_delete_batch_prediction_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_batch_prediction_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_delete_batch_prediction_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_batch_prediction_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_batch_prediction_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_batch_prediction_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_batch_prediction_job ::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_batch_prediction_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_batch_prediction_job(::Google::Cloud::AIPlatform::V1::DeleteBatchPredictionJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_batch_prediction_job_client_stub.call_count
      end
    end
  end

  def test_cancel_batch_prediction_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_batch_prediction_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_cancel_batch_prediction_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_batch_prediction_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_batch_prediction_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_batch_prediction_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_batch_prediction_job ::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_batch_prediction_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_batch_prediction_job(::Google::Cloud::AIPlatform::V1::CancelBatchPredictionJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_batch_prediction_job_client_stub.call_count
      end
    end
  end

  def test_create_model_deployment_monitoring_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    model_deployment_monitoring_job = {}

    create_model_deployment_monitoring_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_create_model_deployment_monitoring_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_model_deployment_monitoring_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_model_deployment_monitoring_job({ parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_model_deployment_monitoring_job parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest.new(parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_model_deployment_monitoring_job({ parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::CreateModelDeploymentMonitoringJobRequest.new(parent: parent, model_deployment_monitoring_job: model_deployment_monitoring_job), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_model_deployment_monitoring_job_client_stub.call_count
      end
    end
  end

  def test_search_model_deployment_monitoring_stats_anomalies
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model_deployment_monitoring_job = "hello world"
    deployed_model_id = "hello world"
    feature_display_name = "hello world"
    objectives = [{}]
    page_size = 42
    page_token = "hello world"
    start_time = {}
    end_time = {}

    search_model_deployment_monitoring_stats_anomalies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_search_model_deployment_monitoring_stats_anomalies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_model_deployment_monitoring_stats_anomalies_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_model_deployment_monitoring_stats_anomalies({ model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_model_deployment_monitoring_stats_anomalies model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_model_deployment_monitoring_stats_anomalies ::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_model_deployment_monitoring_stats_anomalies({ model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_model_deployment_monitoring_stats_anomalies(::Google::Cloud::AIPlatform::V1::SearchModelDeploymentMonitoringStatsAnomaliesRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, deployed_model_id: deployed_model_id, feature_display_name: feature_display_name, objectives: objectives, page_size: page_size, page_token: page_token, start_time: start_time, end_time: end_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_model_deployment_monitoring_stats_anomalies_client_stub.call_count
      end
    end
  end

  def test_get_model_deployment_monitoring_job
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ModelDeploymentMonitoringJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_model_deployment_monitoring_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_get_model_deployment_monitoring_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_model_deployment_monitoring_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_model_deployment_monitoring_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_model_deployment_monitoring_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_model_deployment_monitoring_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::GetModelDeploymentMonitoringJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_model_deployment_monitoring_job_client_stub.call_count
      end
    end
  end

  def test_list_model_deployment_monitoring_jobs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_model_deployment_monitoring_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_list_model_deployment_monitoring_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_model_deployment_monitoring_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_model_deployment_monitoring_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_model_deployment_monitoring_jobs parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_model_deployment_monitoring_jobs ::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_model_deployment_monitoring_jobs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_model_deployment_monitoring_jobs(::Google::Cloud::AIPlatform::V1::ListModelDeploymentMonitoringJobsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_model_deployment_monitoring_jobs_client_stub.call_count
      end
    end
  end

  def test_update_model_deployment_monitoring_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    model_deployment_monitoring_job = {}
    update_mask = {}

    update_model_deployment_monitoring_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_update_model_deployment_monitoring_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_model_deployment_monitoring_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_model_deployment_monitoring_job({ model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_model_deployment_monitoring_job model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_model_deployment_monitoring_job({ model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::UpdateModelDeploymentMonitoringJobRequest.new(model_deployment_monitoring_job: model_deployment_monitoring_job, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_model_deployment_monitoring_job_client_stub.call_count
      end
    end
  end

  def test_delete_model_deployment_monitoring_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_model_deployment_monitoring_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_delete_model_deployment_monitoring_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_model_deployment_monitoring_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_model_deployment_monitoring_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_model_deployment_monitoring_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_model_deployment_monitoring_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::DeleteModelDeploymentMonitoringJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_model_deployment_monitoring_job_client_stub.call_count
      end
    end
  end

  def test_pause_model_deployment_monitoring_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    pause_model_deployment_monitoring_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_pause_model_deployment_monitoring_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, pause_model_deployment_monitoring_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.pause_model_deployment_monitoring_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.pause_model_deployment_monitoring_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.pause_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.pause_model_deployment_monitoring_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.pause_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::PauseModelDeploymentMonitoringJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, pause_model_deployment_monitoring_job_client_stub.call_count
      end
    end
  end

  def test_resume_model_deployment_monitoring_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    resume_model_deployment_monitoring_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::JobService::Rest::ServiceStub.stub :transcode_resume_model_deployment_monitoring_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resume_model_deployment_monitoring_job_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resume_model_deployment_monitoring_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resume_model_deployment_monitoring_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resume_model_deployment_monitoring_job ::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resume_model_deployment_monitoring_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resume_model_deployment_monitoring_job(::Google::Cloud::AIPlatform::V1::ResumeModelDeploymentMonitoringJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resume_model_deployment_monitoring_job_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::JobService::Rest::Client::Configuration, config
  end
end
