# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/ai_platform/v1/job_service"

class ::Google::Cloud::AIPlatform::V1::JobService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_batch_prediction_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.batch_prediction_job_path project: "value0", location: "value1", batch_prediction_job: "value2"
      assert_equal "projects/value0/locations/value1/batchPredictionJobs/value2", path
    end
  end

  def test_context_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.context_path project: "value0", location: "value1", metadata_store: "value2", context: "value3"
      assert_equal "projects/value0/locations/value1/metadataStores/value2/contexts/value3", path
    end
  end

  def test_custom_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.custom_job_path project: "value0", location: "value1", custom_job: "value2"
      assert_equal "projects/value0/locations/value1/customJobs/value2", path
    end
  end

  def test_data_labeling_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.data_labeling_job_path project: "value0", location: "value1", data_labeling_job: "value2"
      assert_equal "projects/value0/locations/value1/dataLabelingJobs/value2", path
    end
  end

  def test_dataset_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.dataset_path project: "value0", location: "value1", dataset: "value2"
      assert_equal "projects/value0/locations/value1/datasets/value2", path
    end
  end

  def test_endpoint_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.endpoint_path project: "value0", location: "value1", endpoint: "value2"
      assert_equal "projects/value0/locations/value1/endpoints/value2", path

      path = client.endpoint_path project: "value0", location: "value1", publisher: "value2", model: "value3"
      assert_equal "projects/value0/locations/value1/publishers/value2/models/value3", path
    end
  end

  def test_hyperparameter_tuning_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.hyperparameter_tuning_job_path project: "value0", location: "value1", hyperparameter_tuning_job: "value2"
      assert_equal "projects/value0/locations/value1/hyperparameterTuningJobs/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_model_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.model_path project: "value0", location: "value1", model: "value2"
      assert_equal "projects/value0/locations/value1/models/value2", path
    end
  end

  def test_model_deployment_monitoring_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.model_deployment_monitoring_job_path project: "value0", location: "value1", model_deployment_monitoring_job: "value2"
      assert_equal "projects/value0/locations/value1/modelDeploymentMonitoringJobs/value2", path
    end
  end

  def test_nas_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.nas_job_path project: "value0", location: "value1", nas_job: "value2"
      assert_equal "projects/value0/locations/value1/nasJobs/value2", path
    end
  end

  def test_nas_trial_detail_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.nas_trial_detail_path project: "value0", location: "value1", nas_job: "value2", nas_trial_detail: "value3"
      assert_equal "projects/value0/locations/value1/nasJobs/value2/nasTrialDetails/value3", path
    end
  end

  def test_network_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_path project: "value0", network: "value1"
      assert_equal "projects/value0/global/networks/value1", path
    end
  end

  def test_network_attachment_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.network_attachment_path project: "value0", region: "value1", networkattachment: "value2"
      assert_equal "projects/value0/regions/value1/networkAttachments/value2", path
    end
  end

  def test_notification_channel_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.notification_channel_path project: "value0", notification_channel: "value1"
      assert_equal "projects/value0/notificationChannels/value1", path
    end
  end

  def test_persistent_resource_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.persistent_resource_path project: "value0", location: "value1", persistent_resource: "value2"
      assert_equal "projects/value0/locations/value1/persistentResources/value2", path
    end
  end

  def test_reservation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.reservation_path project_id_or_number: "value0", zone: "value1", reservation_name: "value2"
      assert_equal "projects/value0/zones/value1/reservations/value2", path
    end
  end

  def test_tensorboard_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.tensorboard_path project: "value0", location: "value1", tensorboard: "value2"
      assert_equal "projects/value0/locations/value1/tensorboards/value2", path
    end
  end

  def test_trial_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::AIPlatform::V1::JobService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.trial_path project: "value0", location: "value1", study: "value2", trial: "value3"
      assert_equal "projects/value0/locations/value1/studies/value2/trials/value3", path
    end
  end
end
