# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/index_service_pb"
require "google/cloud/ai_platform/v1/index_service/rest"


class ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    index = {}

    create_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_create_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_index_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_index({ parent: parent, index: index }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_index parent: parent, index: index do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_index ::Google::Cloud::AIPlatform::V1::CreateIndexRequest.new(parent: parent, index: index) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_index({ parent: parent, index: index }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_index(::Google::Cloud::AIPlatform::V1::CreateIndexRequest.new(parent: parent, index: index), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_index_client_stub.call_count
      end
    end
  end

  def test_get_index
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Index.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_get_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_index_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_index({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_index name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_index ::Google::Cloud::AIPlatform::V1::GetIndexRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_index({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_index(::Google::Cloud::AIPlatform::V1::GetIndexRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_index_client_stub.call_count
      end
    end
  end

  def test_list_indexes
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListIndexesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_indexes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_list_indexes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_indexes_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_indexes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_indexes parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_indexes ::Google::Cloud::AIPlatform::V1::ListIndexesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_indexes({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_indexes(::Google::Cloud::AIPlatform::V1::ListIndexesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_indexes_client_stub.call_count
      end
    end
  end

  def test_update_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index = {}
    update_mask = {}

    update_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_update_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_index_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_index({ index: index, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_index index: index, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_index ::Google::Cloud::AIPlatform::V1::UpdateIndexRequest.new(index: index, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_index({ index: index, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_index(::Google::Cloud::AIPlatform::V1::UpdateIndexRequest.new(index: index, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_index_client_stub.call_count
      end
    end
  end

  def test_delete_index
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_index_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_delete_index_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_index_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_index({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_index name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_index ::Google::Cloud::AIPlatform::V1::DeleteIndexRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_index({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_index(::Google::Cloud::AIPlatform::V1::DeleteIndexRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_index_client_stub.call_count
      end
    end
  end

  def test_upsert_datapoints
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::UpsertDatapointsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index = "hello world"
    datapoints = [{}]
    update_mask = {}

    upsert_datapoints_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_upsert_datapoints_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upsert_datapoints_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upsert_datapoints({ index: index, datapoints: datapoints, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upsert_datapoints index: index, datapoints: datapoints, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upsert_datapoints ::Google::Cloud::AIPlatform::V1::UpsertDatapointsRequest.new(index: index, datapoints: datapoints, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upsert_datapoints({ index: index, datapoints: datapoints, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upsert_datapoints(::Google::Cloud::AIPlatform::V1::UpsertDatapointsRequest.new(index: index, datapoints: datapoints, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upsert_datapoints_client_stub.call_count
      end
    end
  end

  def test_remove_datapoints
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::RemoveDatapointsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    index = "hello world"
    datapoint_ids = ["hello world"]

    remove_datapoints_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::IndexService::Rest::ServiceStub.stub :transcode_remove_datapoints_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, remove_datapoints_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.remove_datapoints({ index: index, datapoint_ids: datapoint_ids }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.remove_datapoints index: index, datapoint_ids: datapoint_ids do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.remove_datapoints ::Google::Cloud::AIPlatform::V1::RemoveDatapointsRequest.new(index: index, datapoint_ids: datapoint_ids) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.remove_datapoints({ index: index, datapoint_ids: datapoint_ids }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.remove_datapoints(::Google::Cloud::AIPlatform::V1::RemoveDatapointsRequest.new(index: index, datapoint_ids: datapoint_ids), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, remove_datapoints_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::IndexService::Rest::Client::Configuration, config
  end
end
