# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/index_endpoint_service_pb"
require "google/cloud/ai_platform/v1/index_endpoint_service"

class ::Google::Cloud::AIPlatform::V1::IndexEndpointService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    index_endpoint = {}

    create_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_index_endpoint, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateIndexEndpointRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::IndexEndpoint), request["index_endpoint"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_index_endpoint({ parent: parent, index_endpoint: index_endpoint }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_index_endpoint parent: parent, index_endpoint: index_endpoint do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_index_endpoint ::Google::Cloud::AIPlatform::V1::CreateIndexEndpointRequest.new(parent: parent, index_endpoint: index_endpoint) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_index_endpoint({ parent: parent, index_endpoint: index_endpoint }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_index_endpoint(::Google::Cloud::AIPlatform::V1::CreateIndexEndpointRequest.new(parent: parent, index_endpoint: index_endpoint), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_get_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::IndexEndpoint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_index_endpoint, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetIndexEndpointRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_index_endpoint({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_index_endpoint name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_index_endpoint ::Google::Cloud::AIPlatform::V1::GetIndexEndpointRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_index_endpoint({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_index_endpoint(::Google::Cloud::AIPlatform::V1::GetIndexEndpointRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_list_index_endpoints
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListIndexEndpointsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}

    list_index_endpoints_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_index_endpoints, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListIndexEndpointsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_index_endpoints_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_index_endpoints({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_index_endpoints parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_index_endpoints ::Google::Cloud::AIPlatform::V1::ListIndexEndpointsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_index_endpoints({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_index_endpoints(::Google::Cloud::AIPlatform::V1::ListIndexEndpointsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_index_endpoints_client_stub.call_rpc_count
    end
  end

  def test_update_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::IndexEndpoint.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = {}
    update_mask = {}

    update_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_index_endpoint, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateIndexEndpointRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::IndexEndpoint), request["index_endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_index_endpoint({ index_endpoint: index_endpoint, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_index_endpoint index_endpoint: index_endpoint, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_index_endpoint ::Google::Cloud::AIPlatform::V1::UpdateIndexEndpointRequest.new(index_endpoint: index_endpoint, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_index_endpoint({ index_endpoint: index_endpoint, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_index_endpoint(::Google::Cloud::AIPlatform::V1::UpdateIndexEndpointRequest.new(index_endpoint: index_endpoint, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_delete_index_endpoint
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_index_endpoint_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_index_endpoint, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteIndexEndpointRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_index_endpoint_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_index_endpoint({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_index_endpoint name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_index_endpoint ::Google::Cloud::AIPlatform::V1::DeleteIndexEndpointRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_index_endpoint({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_index_endpoint(::Google::Cloud::AIPlatform::V1::DeleteIndexEndpointRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_index_endpoint_client_stub.call_rpc_count
    end
  end

  def test_deploy_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index = {}

    deploy_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :deploy_index, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeployIndexRequest, request
      assert_equal "hello world", request["index_endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeployedIndex), request["deployed_index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, deploy_index_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.deploy_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.deploy_index index_endpoint: index_endpoint, deployed_index: deployed_index do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.deploy_index ::Google::Cloud::AIPlatform::V1::DeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.deploy_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.deploy_index(::Google::Cloud::AIPlatform::V1::DeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, deploy_index_client_stub.call_rpc_count
    end
  end

  def test_undeploy_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index_id = "hello world"

    undeploy_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :undeploy_index, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UndeployIndexRequest, request
      assert_equal "hello world", request["index_endpoint"]
      assert_equal "hello world", request["deployed_index_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, undeploy_index_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.undeploy_index({ index_endpoint: index_endpoint, deployed_index_id: deployed_index_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.undeploy_index index_endpoint: index_endpoint, deployed_index_id: deployed_index_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.undeploy_index ::Google::Cloud::AIPlatform::V1::UndeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index_id: deployed_index_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.undeploy_index({ index_endpoint: index_endpoint, deployed_index_id: deployed_index_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.undeploy_index(::Google::Cloud::AIPlatform::V1::UndeployIndexRequest.new(index_endpoint: index_endpoint, deployed_index_id: deployed_index_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, undeploy_index_client_stub.call_rpc_count
    end
  end

  def test_mutate_deployed_index
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    index_endpoint = "hello world"
    deployed_index = {}

    mutate_deployed_index_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :mutate_deployed_index, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::MutateDeployedIndexRequest, request
      assert_equal "hello world", request["index_endpoint"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeployedIndex), request["deployed_index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, mutate_deployed_index_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.mutate_deployed_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.mutate_deployed_index index_endpoint: index_endpoint, deployed_index: deployed_index do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.mutate_deployed_index ::Google::Cloud::AIPlatform::V1::MutateDeployedIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.mutate_deployed_index({ index_endpoint: index_endpoint, deployed_index: deployed_index }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.mutate_deployed_index(::Google::Cloud::AIPlatform::V1::MutateDeployedIndexRequest.new(index_endpoint: index_endpoint, deployed_index: deployed_index), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, mutate_deployed_index_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::IndexEndpointService::Operations, client.operations_client
  end
end
