# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/featurestore_service_pb"
require "google/cloud/ai_platform/v1/featurestore_service"

class ::Google::Cloud::AIPlatform::V1::FeaturestoreService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_featurestore
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    featurestore = {}
    featurestore_id = "hello world"

    create_featurestore_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_featurestore, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Featurestore), request["featurestore"]
      assert_equal "hello world", request["featurestore_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_featurestore_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_featurestore({ parent: parent, featurestore: featurestore, featurestore_id: featurestore_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_featurestore parent: parent, featurestore: featurestore, featurestore_id: featurestore_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_featurestore ::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest.new(parent: parent, featurestore: featurestore, featurestore_id: featurestore_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_featurestore({ parent: parent, featurestore: featurestore, featurestore_id: featurestore_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_featurestore(::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest.new(parent: parent, featurestore: featurestore, featurestore_id: featurestore_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_featurestore_client_stub.call_rpc_count
    end
  end

  def test_get_featurestore
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Featurestore.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_featurestore_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_featurestore, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_featurestore_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_featurestore({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_featurestore name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_featurestore ::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_featurestore({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_featurestore(::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_featurestore_client_stub.call_rpc_count
    end
  end

  def test_list_featurestores
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListFeaturestoresResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_featurestores_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_featurestores, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_featurestores_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_featurestores({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_featurestores parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_featurestores ::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_featurestores({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_featurestores(::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_featurestores_client_stub.call_rpc_count
    end
  end

  def test_update_featurestore
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    featurestore = {}
    update_mask = {}

    update_featurestore_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_featurestore, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Featurestore), request["featurestore"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_featurestore_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_featurestore({ featurestore: featurestore, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_featurestore featurestore: featurestore, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_featurestore ::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest.new(featurestore: featurestore, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_featurestore({ featurestore: featurestore, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_featurestore(::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest.new(featurestore: featurestore, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_featurestore_client_stub.call_rpc_count
    end
  end

  def test_delete_featurestore
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_featurestore_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_featurestore, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_featurestore_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_featurestore({ name: name, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_featurestore name: name, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_featurestore ::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest.new(name: name, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_featurestore({ name: name, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_featurestore(::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_featurestore_client_stub.call_rpc_count
    end
  end

  def test_create_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entity_type = {}
    entity_type_id = "hello world"

    create_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entity_type, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::EntityType), request["entity_type"]
      assert_equal "hello world", request["entity_type_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entity_type({ parent: parent, entity_type: entity_type, entity_type_id: entity_type_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entity_type parent: parent, entity_type: entity_type, entity_type_id: entity_type_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entity_type ::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest.new(parent: parent, entity_type: entity_type, entity_type_id: entity_type_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entity_type({ parent: parent, entity_type: entity_type, entity_type_id: entity_type_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entity_type(::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest.new(parent: parent, entity_type: entity_type, entity_type_id: entity_type_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entity_type_client_stub.call_rpc_count
    end
  end

  def test_get_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::EntityType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entity_type, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entity_type({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entity_type name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entity_type ::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entity_type({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entity_type(::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entity_type_client_stub.call_rpc_count
    end
  end

  def test_list_entity_types
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListEntityTypesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_entity_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entity_types, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entity_types_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entity_types({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entity_types parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entity_types ::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entity_types({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entity_types(::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entity_types_client_stub.call_rpc_count
    end
  end

  def test_update_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::EntityType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entity_type = {}
    update_mask = {}

    update_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_entity_type, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::EntityType), request["entity_type"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_entity_type({ entity_type: entity_type, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_entity_type entity_type: entity_type, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_entity_type ::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest.new(entity_type: entity_type, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_entity_type({ entity_type: entity_type, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_entity_type(::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest.new(entity_type: entity_type, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_entity_type_client_stub.call_rpc_count
    end
  end

  def test_delete_entity_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_entity_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entity_type, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entity_type_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entity_type({ name: name, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entity_type name: name, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entity_type ::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest.new(name: name, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entity_type({ name: name, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entity_type(::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest.new(name: name, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entity_type_client_stub.call_rpc_count
    end
  end

  def test_create_feature
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feature = {}
    feature_id = "hello world"

    create_feature_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_feature, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateFeatureRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Feature), request["feature"]
      assert_equal "hello world", request["feature_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_feature_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_feature({ parent: parent, feature: feature, feature_id: feature_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_feature parent: parent, feature: feature, feature_id: feature_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_feature ::Google::Cloud::AIPlatform::V1::CreateFeatureRequest.new(parent: parent, feature: feature, feature_id: feature_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_feature({ parent: parent, feature: feature, feature_id: feature_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_feature(::Google::Cloud::AIPlatform::V1::CreateFeatureRequest.new(parent: parent, feature: feature, feature_id: feature_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_feature_client_stub.call_rpc_count
    end
  end

  def test_batch_create_features
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_features_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_create_features, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest, request
      assert_equal "hello world", request["parent"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateFeatureRequest, request["requests"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_create_features_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_create_features({ parent: parent, requests: requests }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_create_features parent: parent, requests: requests do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_create_features ::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest.new(parent: parent, requests: requests) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_create_features({ parent: parent, requests: requests }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_create_features(::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest.new(parent: parent, requests: requests), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_create_features_client_stub.call_rpc_count
    end
  end

  def test_get_feature
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Feature.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feature_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_feature, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetFeatureRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_feature_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_feature({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_feature name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_feature ::Google::Cloud::AIPlatform::V1::GetFeatureRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_feature({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_feature(::Google::Cloud::AIPlatform::V1::GetFeatureRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_feature_client_stub.call_rpc_count
    end
  end

  def test_list_features
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListFeaturesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}
    latest_stats_count = 42

    list_features_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_features, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListFeaturesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["filter"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      assert_equal 42, request["latest_stats_count"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_features_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_features({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_features parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_features ::Google::Cloud::AIPlatform::V1::ListFeaturesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_features({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_features(::Google::Cloud::AIPlatform::V1::ListFeaturesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_features_client_stub.call_rpc_count
    end
  end

  def test_update_feature
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::Feature.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    feature = {}
    update_mask = {}

    update_feature_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_feature, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::Feature), request["feature"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_feature_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_feature({ feature: feature, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_feature feature: feature, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_feature ::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest.new(feature: feature, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_feature({ feature: feature, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_feature(::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest.new(feature: feature, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_feature_client_stub.call_rpc_count
    end
  end

  def test_delete_feature
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_feature_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_feature, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_feature_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_feature({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_feature name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_feature ::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_feature({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_feature(::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_feature_client_stub.call_rpc_count
    end
  end

  def test_import_feature_values
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    avro_source = {}
    feature_time_field = "hello world"
    entity_type = "hello world"
    entity_id_field = "hello world"
    feature_specs = [{}]
    disable_online_serving = true
    worker_count = 42
    disable_ingestion_analysis = true

    import_feature_values_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_feature_values, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::AvroSource), request["avro_source"]
      assert_equal :avro_source, request.source
      assert_equal "hello world", request["feature_time_field"]
      assert_equal :feature_time_field, request.feature_time_source
      assert_equal "hello world", request["entity_type"]
      assert_equal "hello world", request["entity_id_field"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest::FeatureSpec, request["feature_specs"].first
      assert_equal true, request["disable_online_serving"]
      assert_equal 42, request["worker_count"]
      assert_equal true, request["disable_ingestion_analysis"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_feature_values_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_feature_values({ avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_feature_values avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_feature_values ::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest.new(avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_feature_values({ avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_feature_values(::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest.new(avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_feature_values_client_stub.call_rpc_count
    end
  end

  def test_batch_read_feature_values
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    csv_read_instances = {}
    featurestore = "hello world"
    destination = {}
    pass_through_fields = [{}]
    entity_type_specs = [{}]
    start_time = {}

    batch_read_feature_values_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :batch_read_feature_values, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::CsvSource), request["csv_read_instances"]
      assert_equal :csv_read_instances, request.read_option
      assert_equal "hello world", request["featurestore"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::FeatureValueDestination), request["destination"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest::PassThroughField, request["pass_through_fields"].first
      assert_kind_of ::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest::EntityTypeSpec, request["entity_type_specs"].first
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Timestamp), request["start_time"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, batch_read_feature_values_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.batch_read_feature_values({ csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.batch_read_feature_values csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.batch_read_feature_values ::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest.new(csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.batch_read_feature_values({ csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.batch_read_feature_values(::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest.new(csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, batch_read_feature_values_client_stub.call_rpc_count
    end
  end

  def test_export_feature_values
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    snapshot_export = {}
    entity_type = "hello world"
    destination = {}
    feature_selector = {}
    settings = [{}]

    export_feature_values_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_feature_values, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest::SnapshotExport), request["snapshot_export"]
      assert_equal :snapshot_export, request.mode
      assert_equal "hello world", request["entity_type"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::FeatureValueDestination), request["destination"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::FeatureSelector), request["feature_selector"]
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DestinationFeatureSetting, request["settings"].first
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_feature_values_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_feature_values({ snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_feature_values snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_feature_values ::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest.new(snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_feature_values({ snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_feature_values(::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest.new(snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_feature_values_client_stub.call_rpc_count
    end
  end

  def test_delete_feature_values
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    select_entity = {}
    entity_type = "hello world"

    delete_feature_values_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_feature_values, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest::SelectEntity), request["select_entity"]
      assert_equal :select_entity, request.DeleteOption
      assert_equal "hello world", request["entity_type"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_feature_values_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_feature_values({ select_entity: select_entity, entity_type: entity_type }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_feature_values select_entity: select_entity, entity_type: entity_type do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_feature_values ::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest.new(select_entity: select_entity, entity_type: entity_type) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_feature_values({ select_entity: select_entity, entity_type: entity_type }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_feature_values(::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest.new(select_entity: select_entity, entity_type: entity_type), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_feature_values_client_stub.call_rpc_count
    end
  end

  def test_search_features
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::SearchFeaturesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_features_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_features, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest, request
      assert_equal "hello world", request["location"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_features_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_features({ location: location, query: query, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_features location: location, query: query, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_features ::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest.new(location: location, query: query, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_features({ location: location, query: query, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_features(::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest.new(location: location, query: query, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_features_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Operations, client.operations_client
  end
end
