# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/featurestore_service_pb"
require "google/cloud/ai_platform/v1/featurestore_service/rest"


class ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_featurestore
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    featurestore = {}
    featurestore_id = "hello world"

    create_featurestore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_create_featurestore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_featurestore_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_featurestore({ parent: parent, featurestore: featurestore, featurestore_id: featurestore_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_featurestore parent: parent, featurestore: featurestore, featurestore_id: featurestore_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_featurestore ::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest.new(parent: parent, featurestore: featurestore, featurestore_id: featurestore_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_featurestore({ parent: parent, featurestore: featurestore, featurestore_id: featurestore_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_featurestore(::Google::Cloud::AIPlatform::V1::CreateFeaturestoreRequest.new(parent: parent, featurestore: featurestore, featurestore_id: featurestore_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_featurestore_client_stub.call_count
      end
    end
  end

  def test_get_featurestore
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Featurestore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_featurestore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_get_featurestore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_featurestore_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_featurestore({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_featurestore name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_featurestore ::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_featurestore({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_featurestore(::Google::Cloud::AIPlatform::V1::GetFeaturestoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_featurestore_client_stub.call_count
      end
    end
  end

  def test_list_featurestores
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListFeaturestoresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_featurestores_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_list_featurestores_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_featurestores_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_featurestores({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_featurestores parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_featurestores ::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_featurestores({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_featurestores(::Google::Cloud::AIPlatform::V1::ListFeaturestoresRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_featurestores_client_stub.call_count
      end
    end
  end

  def test_update_featurestore
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    featurestore = {}
    update_mask = {}

    update_featurestore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_update_featurestore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_featurestore_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_featurestore({ featurestore: featurestore, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_featurestore featurestore: featurestore, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_featurestore ::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest.new(featurestore: featurestore, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_featurestore({ featurestore: featurestore, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_featurestore(::Google::Cloud::AIPlatform::V1::UpdateFeaturestoreRequest.new(featurestore: featurestore, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_featurestore_client_stub.call_count
      end
    end
  end

  def test_delete_featurestore
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_featurestore_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_delete_featurestore_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_featurestore_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_featurestore({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_featurestore name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_featurestore ::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_featurestore({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_featurestore(::Google::Cloud::AIPlatform::V1::DeleteFeaturestoreRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_featurestore_client_stub.call_count
      end
    end
  end

  def test_create_entity_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entity_type = {}
    entity_type_id = "hello world"

    create_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_create_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entity_type({ parent: parent, entity_type: entity_type, entity_type_id: entity_type_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entity_type parent: parent, entity_type: entity_type, entity_type_id: entity_type_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entity_type ::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest.new(parent: parent, entity_type: entity_type, entity_type_id: entity_type_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entity_type({ parent: parent, entity_type: entity_type, entity_type_id: entity_type_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entity_type(::Google::Cloud::AIPlatform::V1::CreateEntityTypeRequest.new(parent: parent, entity_type: entity_type, entity_type_id: entity_type_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entity_type_client_stub.call_count
      end
    end
  end

  def test_get_entity_type
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::EntityType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_get_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entity_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entity_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entity_type ::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entity_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entity_type(::Google::Cloud::AIPlatform::V1::GetEntityTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entity_type_client_stub.call_count
      end
    end
  end

  def test_list_entity_types
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListEntityTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}

    list_entity_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_list_entity_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entity_types_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entity_types({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entity_types parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entity_types ::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entity_types({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entity_types(::Google::Cloud::AIPlatform::V1::ListEntityTypesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entity_types_client_stub.call_count
      end
    end
  end

  def test_update_entity_type
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::EntityType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entity_type = {}
    update_mask = {}

    update_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_update_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_entity_type({ entity_type: entity_type, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_entity_type entity_type: entity_type, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_entity_type ::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest.new(entity_type: entity_type, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_entity_type({ entity_type: entity_type, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_entity_type(::Google::Cloud::AIPlatform::V1::UpdateEntityTypeRequest.new(entity_type: entity_type, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_entity_type_client_stub.call_count
      end
    end
  end

  def test_delete_entity_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_entity_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_delete_entity_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entity_type_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entity_type({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entity_type name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entity_type ::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entity_type({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entity_type(::Google::Cloud::AIPlatform::V1::DeleteEntityTypeRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entity_type_client_stub.call_count
      end
    end
  end

  def test_create_feature
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feature = {}
    feature_id = "hello world"

    create_feature_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_create_feature_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_feature_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_feature({ parent: parent, feature: feature, feature_id: feature_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_feature parent: parent, feature: feature, feature_id: feature_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_feature ::Google::Cloud::AIPlatform::V1::CreateFeatureRequest.new(parent: parent, feature: feature, feature_id: feature_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_feature({ parent: parent, feature: feature, feature_id: feature_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_feature(::Google::Cloud::AIPlatform::V1::CreateFeatureRequest.new(parent: parent, feature: feature, feature_id: feature_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_feature_client_stub.call_count
      end
    end
  end

  def test_batch_create_features
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_features_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_batch_create_features_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_features_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_features({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_features parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_features ::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_features({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_features(::Google::Cloud::AIPlatform::V1::BatchCreateFeaturesRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_features_client_stub.call_count
      end
    end
  end

  def test_get_feature
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Feature.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feature_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_get_feature_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_feature_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_feature({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_feature name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_feature ::Google::Cloud::AIPlatform::V1::GetFeatureRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_feature({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_feature(::Google::Cloud::AIPlatform::V1::GetFeatureRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_feature_client_stub.call_count
      end
    end
  end

  def test_list_features
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListFeaturesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    read_mask = {}
    latest_stats_count = 42

    list_features_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_list_features_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_features_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_features({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_features parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_features ::Google::Cloud::AIPlatform::V1::ListFeaturesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_features({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_features(::Google::Cloud::AIPlatform::V1::ListFeaturesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by, read_mask: read_mask, latest_stats_count: latest_stats_count), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_features_client_stub.call_count
      end
    end
  end

  def test_update_feature
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Feature.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature = {}
    update_mask = {}

    update_feature_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_update_feature_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_feature_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_feature({ feature: feature, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_feature feature: feature, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_feature ::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest.new(feature: feature, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_feature({ feature: feature, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_feature(::Google::Cloud::AIPlatform::V1::UpdateFeatureRequest.new(feature: feature, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_feature_client_stub.call_count
      end
    end
  end

  def test_delete_feature
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_feature_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_delete_feature_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_feature_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_feature({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_feature name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_feature ::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_feature({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_feature(::Google::Cloud::AIPlatform::V1::DeleteFeatureRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_feature_client_stub.call_count
      end
    end
  end

  def test_import_feature_values
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    avro_source = {}
    feature_time_field = "hello world"
    entity_type = "hello world"
    entity_id_field = "hello world"
    feature_specs = [{}]
    disable_online_serving = true
    worker_count = 42
    disable_ingestion_analysis = true

    import_feature_values_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_import_feature_values_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_feature_values_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_feature_values({ avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_feature_values avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_feature_values ::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest.new(avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_feature_values({ avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_feature_values(::Google::Cloud::AIPlatform::V1::ImportFeatureValuesRequest.new(avro_source: avro_source, feature_time_field: feature_time_field, entity_type: entity_type, entity_id_field: entity_id_field, feature_specs: feature_specs, disable_online_serving: disable_online_serving, worker_count: worker_count, disable_ingestion_analysis: disable_ingestion_analysis), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_feature_values_client_stub.call_count
      end
    end
  end

  def test_batch_read_feature_values
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    csv_read_instances = {}
    featurestore = "hello world"
    destination = {}
    pass_through_fields = [{}]
    entity_type_specs = [{}]
    start_time = {}

    batch_read_feature_values_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_batch_read_feature_values_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_read_feature_values_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_read_feature_values({ csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_read_feature_values csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_read_feature_values ::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest.new(csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_read_feature_values({ csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_read_feature_values(::Google::Cloud::AIPlatform::V1::BatchReadFeatureValuesRequest.new(csv_read_instances: csv_read_instances, featurestore: featurestore, destination: destination, pass_through_fields: pass_through_fields, entity_type_specs: entity_type_specs, start_time: start_time), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_read_feature_values_client_stub.call_count
      end
    end
  end

  def test_export_feature_values
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    snapshot_export = {}
    entity_type = "hello world"
    destination = {}
    feature_selector = {}
    settings = [{}]

    export_feature_values_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_export_feature_values_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_feature_values_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_feature_values({ snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_feature_values snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_feature_values ::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest.new(snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_feature_values({ snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_feature_values(::Google::Cloud::AIPlatform::V1::ExportFeatureValuesRequest.new(snapshot_export: snapshot_export, entity_type: entity_type, destination: destination, feature_selector: feature_selector, settings: settings), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_feature_values_client_stub.call_count
      end
    end
  end

  def test_delete_feature_values
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    select_entity = {}
    entity_type = "hello world"

    delete_feature_values_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_delete_feature_values_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_feature_values_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_feature_values({ select_entity: select_entity, entity_type: entity_type }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_feature_values select_entity: select_entity, entity_type: entity_type do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_feature_values ::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest.new(select_entity: select_entity, entity_type: entity_type) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_feature_values({ select_entity: select_entity, entity_type: entity_type }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_feature_values(::Google::Cloud::AIPlatform::V1::DeleteFeatureValuesRequest.new(select_entity: select_entity, entity_type: entity_type), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_feature_values_client_stub.call_count
      end
    end
  end

  def test_search_features
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::SearchFeaturesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    location = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"

    search_features_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::ServiceStub.stub :transcode_search_features_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_features_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_features({ location: location, query: query, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_features location: location, query: query, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_features ::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest.new(location: location, query: query, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_features({ location: location, query: query, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_features(::Google::Cloud::AIPlatform::V1::SearchFeaturesRequest.new(location: location, query: query, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_features_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::FeaturestoreService::Rest::Client::Configuration, config
  end
end
