# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/feature_online_store_service_pb"
require "google/cloud/ai_platform/v1/feature_online_store_service"

class ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_fetch_feature_values
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::FetchFeatureValuesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"
    data_key = {}
    data_format = :FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED

    fetch_feature_values_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_feature_values, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::FetchFeatureValuesRequest, request
      assert_equal "hello world", request["feature_view"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::FeatureViewDataKey), request["data_key"]
      assert_equal :FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED, request["data_format"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_feature_values_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_feature_values({ feature_view: feature_view, data_key: data_key, data_format: data_format }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_feature_values feature_view: feature_view, data_key: data_key, data_format: data_format do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_feature_values ::Google::Cloud::AIPlatform::V1::FetchFeatureValuesRequest.new(feature_view: feature_view, data_key: data_key, data_format: data_format) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_feature_values({ feature_view: feature_view, data_key: data_key, data_format: data_format }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_feature_values(::Google::Cloud::AIPlatform::V1::FetchFeatureValuesRequest.new(feature_view: feature_view, data_key: data_key, data_format: data_format), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_feature_values_client_stub.call_rpc_count
    end
  end

  def test_search_nearest_entities
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"
    query = {}
    return_full_entity = true

    search_nearest_entities_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_nearest_entities, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesRequest, request
      assert_equal "hello world", request["feature_view"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::NearestNeighborQuery), request["query"]
      assert_equal true, request["return_full_entity"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_nearest_entities_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_nearest_entities({ feature_view: feature_view, query: query, return_full_entity: return_full_entity }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_nearest_entities feature_view: feature_view, query: query, return_full_entity: return_full_entity do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_nearest_entities ::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesRequest.new(feature_view: feature_view, query: query, return_full_entity: return_full_entity) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_nearest_entities({ feature_view: feature_view, query: query, return_full_entity: return_full_entity }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_nearest_entities(::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesRequest.new(feature_view: feature_view, query: query, return_full_entity: return_full_entity), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_nearest_entities_client_stub.call_rpc_count
    end
  end

  def test_feature_view_direct_write
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a bidi streaming method.
    feature_view = "hello world"
    data_key_and_feature_values = [{}]

    feature_view_direct_write_client_stub = ClientStub.new [grpc_response].to_enum, grpc_operation do |name, request, options:|
      assert_equal :feature_view_direct_write, name
      assert_kind_of Enumerable, request
      refute_nil options
      request
    end

    Gapic::ServiceStub.stub :new, feature_view_direct_write_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use enumerable object with hash and protobuf object.
      request_hash = { feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values }
      request_proto = ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteRequest.new feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values
      enum_input = [request_hash, request_proto].to_enum
      client.feature_view_direct_write enum_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common).
      request_hash = { feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values }
      request_proto = ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteRequest.new feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values
      stream_input = Gapic::StreamInput.new
      client.feature_view_direct_write stream_input do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Use enumerable object with hash and protobuf object with options.
      request_hash = { feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values }
      request_proto = ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteRequest.new feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values
      enum_input = [request_hash, request_proto].to_enum
      client.feature_view_direct_write enum_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end

      # Use stream input object (from gapic-common) with options.
      request_hash = { feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values }
      request_proto = ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteRequest.new feature_view: feature_view, data_key_and_feature_values: data_key_and_feature_values
      stream_input = Gapic::StreamInput.new
      client.feature_view_direct_write stream_input, grpc_options do |response, operation|
        assert_kind_of Enumerable, response
        response.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteResponse, r
        end
        assert_equal grpc_operation, operation
      end
      stream_input << request_hash
      stream_input << request_proto
      stream_input.close

      # Verify method calls
      assert_equal 4, feature_view_direct_write_client_stub.call_rpc_count
      feature_view_direct_write_client_stub.requests.each do |request|
        request.to_a.each do |r|
          assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteRequest, r
          assert_equal "hello world", r["feature_view"]
          assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureViewDirectWriteRequest::DataKeyAndFeatureValues, r["data_key_and_feature_values"].first
        end
      end
    end
  end

  def test_generate_fetch_access_token
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"

    generate_fetch_access_token_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :generate_fetch_access_token, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenRequest, request
      assert_equal "hello world", request["feature_view"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, generate_fetch_access_token_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.generate_fetch_access_token({ feature_view: feature_view }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.generate_fetch_access_token feature_view: feature_view do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.generate_fetch_access_token ::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenRequest.new(feature_view: feature_view) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.generate_fetch_access_token({ feature_view: feature_view }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.generate_fetch_access_token(::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenRequest.new(feature_view: feature_view), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, generate_fetch_access_token_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
