# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/feature_online_store_service_pb"
require "google/cloud/ai_platform/v1/feature_online_store_service/rest"


class ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_fetch_feature_values
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::FetchFeatureValuesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"
    data_key = {}
    data_format = :FEATURE_VIEW_DATA_FORMAT_UNSPECIFIED

    fetch_feature_values_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::ServiceStub.stub :transcode_fetch_feature_values_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_feature_values_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_feature_values({ feature_view: feature_view, data_key: data_key, data_format: data_format }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_feature_values feature_view: feature_view, data_key: data_key, data_format: data_format do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_feature_values ::Google::Cloud::AIPlatform::V1::FetchFeatureValuesRequest.new(feature_view: feature_view, data_key: data_key, data_format: data_format) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_feature_values({ feature_view: feature_view, data_key: data_key, data_format: data_format }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_feature_values(::Google::Cloud::AIPlatform::V1::FetchFeatureValuesRequest.new(feature_view: feature_view, data_key: data_key, data_format: data_format), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_feature_values_client_stub.call_count
      end
    end
  end

  def test_search_nearest_entities
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"
    query = {}
    return_full_entity = true

    search_nearest_entities_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::ServiceStub.stub :transcode_search_nearest_entities_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_nearest_entities_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_nearest_entities({ feature_view: feature_view, query: query, return_full_entity: return_full_entity }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_nearest_entities feature_view: feature_view, query: query, return_full_entity: return_full_entity do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_nearest_entities ::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesRequest.new(feature_view: feature_view, query: query, return_full_entity: return_full_entity) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_nearest_entities({ feature_view: feature_view, query: query, return_full_entity: return_full_entity }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_nearest_entities(::Google::Cloud::AIPlatform::V1::SearchNearestEntitiesRequest.new(feature_view: feature_view, query: query, return_full_entity: return_full_entity), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_nearest_entities_client_stub.call_count
      end
    end
  end

  def test_generate_fetch_access_token
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"

    generate_fetch_access_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::ServiceStub.stub :transcode_generate_fetch_access_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_fetch_access_token_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_fetch_access_token({ feature_view: feature_view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_fetch_access_token feature_view: feature_view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_fetch_access_token ::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenRequest.new(feature_view: feature_view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_fetch_access_token({ feature_view: feature_view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_fetch_access_token(::Google::Cloud::AIPlatform::V1::GenerateFetchAccessTokenRequest.new(feature_view: feature_view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_fetch_access_token_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreService::Rest::Client::Configuration, config
  end
end
