# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/feature_online_store_admin_service_pb"
require "google/cloud/ai_platform/v1/feature_online_store_admin_service/rest"


class ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_feature_online_store
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feature_online_store = {}
    feature_online_store_id = "hello world"

    create_feature_online_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_create_feature_online_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_feature_online_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_feature_online_store({ parent: parent, feature_online_store: feature_online_store, feature_online_store_id: feature_online_store_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_feature_online_store parent: parent, feature_online_store: feature_online_store, feature_online_store_id: feature_online_store_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_feature_online_store ::Google::Cloud::AIPlatform::V1::CreateFeatureOnlineStoreRequest.new(parent: parent, feature_online_store: feature_online_store, feature_online_store_id: feature_online_store_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_feature_online_store({ parent: parent, feature_online_store: feature_online_store, feature_online_store_id: feature_online_store_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_feature_online_store(::Google::Cloud::AIPlatform::V1::CreateFeatureOnlineStoreRequest.new(parent: parent, feature_online_store: feature_online_store, feature_online_store_id: feature_online_store_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_feature_online_store_client_stub.call_count
      end
    end
  end

  def test_get_feature_online_store
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStore.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feature_online_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_get_feature_online_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_feature_online_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_feature_online_store({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_feature_online_store name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_feature_online_store ::Google::Cloud::AIPlatform::V1::GetFeatureOnlineStoreRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_feature_online_store({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_feature_online_store(::Google::Cloud::AIPlatform::V1::GetFeatureOnlineStoreRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_feature_online_store_client_stub.call_count
      end
    end
  end

  def test_list_feature_online_stores
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_feature_online_stores_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_list_feature_online_stores_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_feature_online_stores_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_feature_online_stores({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_feature_online_stores parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_feature_online_stores ::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_feature_online_stores({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_feature_online_stores(::Google::Cloud::AIPlatform::V1::ListFeatureOnlineStoresRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_feature_online_stores_client_stub.call_count
      end
    end
  end

  def test_update_feature_online_store
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature_online_store = {}
    update_mask = {}

    update_feature_online_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_update_feature_online_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_feature_online_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_feature_online_store({ feature_online_store: feature_online_store, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_feature_online_store feature_online_store: feature_online_store, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_feature_online_store ::Google::Cloud::AIPlatform::V1::UpdateFeatureOnlineStoreRequest.new(feature_online_store: feature_online_store, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_feature_online_store({ feature_online_store: feature_online_store, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_feature_online_store(::Google::Cloud::AIPlatform::V1::UpdateFeatureOnlineStoreRequest.new(feature_online_store: feature_online_store, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_feature_online_store_client_stub.call_count
      end
    end
  end

  def test_delete_feature_online_store
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    force = true

    delete_feature_online_store_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_delete_feature_online_store_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_feature_online_store_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_feature_online_store({ name: name, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_feature_online_store name: name, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_feature_online_store ::Google::Cloud::AIPlatform::V1::DeleteFeatureOnlineStoreRequest.new(name: name, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_feature_online_store({ name: name, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_feature_online_store(::Google::Cloud::AIPlatform::V1::DeleteFeatureOnlineStoreRequest.new(name: name, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_feature_online_store_client_stub.call_count
      end
    end
  end

  def test_create_feature_view
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    feature_view = {}
    feature_view_id = "hello world"
    run_sync_immediately = true

    create_feature_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_create_feature_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_feature_view_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_feature_view({ parent: parent, feature_view: feature_view, feature_view_id: feature_view_id, run_sync_immediately: run_sync_immediately }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_feature_view parent: parent, feature_view: feature_view, feature_view_id: feature_view_id, run_sync_immediately: run_sync_immediately do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_feature_view ::Google::Cloud::AIPlatform::V1::CreateFeatureViewRequest.new(parent: parent, feature_view: feature_view, feature_view_id: feature_view_id, run_sync_immediately: run_sync_immediately) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_feature_view({ parent: parent, feature_view: feature_view, feature_view_id: feature_view_id, run_sync_immediately: run_sync_immediately }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_feature_view(::Google::Cloud::AIPlatform::V1::CreateFeatureViewRequest.new(parent: parent, feature_view: feature_view, feature_view_id: feature_view_id, run_sync_immediately: run_sync_immediately), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_feature_view_client_stub.call_count
      end
    end
  end

  def test_get_feature_view
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::FeatureView.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feature_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_get_feature_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_feature_view_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_feature_view({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_feature_view name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_feature_view ::Google::Cloud::AIPlatform::V1::GetFeatureViewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_feature_view({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_feature_view(::Google::Cloud::AIPlatform::V1::GetFeatureViewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_feature_view_client_stub.call_count
      end
    end
  end

  def test_list_feature_views
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListFeatureViewsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_feature_views_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_list_feature_views_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_feature_views_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_feature_views({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_feature_views parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_feature_views ::Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_feature_views({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_feature_views(::Google::Cloud::AIPlatform::V1::ListFeatureViewsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_feature_views_client_stub.call_count
      end
    end
  end

  def test_update_feature_view
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature_view = {}
    update_mask = {}

    update_feature_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_update_feature_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_feature_view_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_feature_view({ feature_view: feature_view, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_feature_view feature_view: feature_view, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_feature_view ::Google::Cloud::AIPlatform::V1::UpdateFeatureViewRequest.new(feature_view: feature_view, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_feature_view({ feature_view: feature_view, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_feature_view(::Google::Cloud::AIPlatform::V1::UpdateFeatureViewRequest.new(feature_view: feature_view, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_feature_view_client_stub.call_count
      end
    end
  end

  def test_delete_feature_view
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_feature_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_delete_feature_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_feature_view_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_feature_view({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_feature_view name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_feature_view ::Google::Cloud::AIPlatform::V1::DeleteFeatureViewRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_feature_view({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_feature_view(::Google::Cloud::AIPlatform::V1::DeleteFeatureViewRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_feature_view_client_stub.call_count
      end
    end
  end

  def test_sync_feature_view
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::SyncFeatureViewResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    feature_view = "hello world"

    sync_feature_view_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_sync_feature_view_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, sync_feature_view_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.sync_feature_view({ feature_view: feature_view }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.sync_feature_view feature_view: feature_view do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.sync_feature_view ::Google::Cloud::AIPlatform::V1::SyncFeatureViewRequest.new(feature_view: feature_view) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.sync_feature_view({ feature_view: feature_view }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.sync_feature_view(::Google::Cloud::AIPlatform::V1::SyncFeatureViewRequest.new(feature_view: feature_view), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, sync_feature_view_client_stub.call_count
      end
    end
  end

  def test_get_feature_view_sync
    # Create test objects.
    client_result = ::Google::Cloud::Aiplatform::V1::FeatureViewSync.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_feature_view_sync_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_get_feature_view_sync_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_feature_view_sync_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_feature_view_sync({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_feature_view_sync name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_feature_view_sync ::Google::Cloud::AIPlatform::V1::GetFeatureViewSyncRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_feature_view_sync({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_feature_view_sync(::Google::Cloud::AIPlatform::V1::GetFeatureViewSyncRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_feature_view_sync_client_stub.call_count
      end
    end
  end

  def test_list_feature_view_syncs
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_feature_view_syncs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::ServiceStub.stub :transcode_list_feature_view_syncs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_feature_view_syncs_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_feature_view_syncs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_feature_view_syncs parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_feature_view_syncs ::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_feature_view_syncs({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_feature_view_syncs(::Google::Cloud::AIPlatform::V1::ListFeatureViewSyncsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_feature_view_syncs_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::FeatureOnlineStoreAdminService::Rest::Client::Configuration, config
  end
end
