# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/aiplatform/v1/deployment_resource_pool_service_pb"
require "google/cloud/ai_platform/v1/deployment_resource_pool_service"

class ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_deployment_resource_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deployment_resource_pool = {}
    deployment_resource_pool_id = "hello world"

    create_deployment_resource_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_deployment_resource_pool, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::CreateDeploymentResourcePoolRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeploymentResourcePool), request["deployment_resource_pool"]
      assert_equal "hello world", request["deployment_resource_pool_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_deployment_resource_pool_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_deployment_resource_pool({ parent: parent, deployment_resource_pool: deployment_resource_pool, deployment_resource_pool_id: deployment_resource_pool_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_deployment_resource_pool parent: parent, deployment_resource_pool: deployment_resource_pool, deployment_resource_pool_id: deployment_resource_pool_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_deployment_resource_pool ::Google::Cloud::AIPlatform::V1::CreateDeploymentResourcePoolRequest.new(parent: parent, deployment_resource_pool: deployment_resource_pool, deployment_resource_pool_id: deployment_resource_pool_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_deployment_resource_pool({ parent: parent, deployment_resource_pool: deployment_resource_pool, deployment_resource_pool_id: deployment_resource_pool_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_deployment_resource_pool(::Google::Cloud::AIPlatform::V1::CreateDeploymentResourcePoolRequest.new(parent: parent, deployment_resource_pool: deployment_resource_pool, deployment_resource_pool_id: deployment_resource_pool_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_deployment_resource_pool_client_stub.call_rpc_count
    end
  end

  def test_get_deployment_resource_pool
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePool.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deployment_resource_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_deployment_resource_pool, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::GetDeploymentResourcePoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_deployment_resource_pool_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_deployment_resource_pool({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_deployment_resource_pool name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_deployment_resource_pool ::Google::Cloud::AIPlatform::V1::GetDeploymentResourcePoolRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_deployment_resource_pool({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_deployment_resource_pool(::Google::Cloud::AIPlatform::V1::GetDeploymentResourcePoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_deployment_resource_pool_client_stub.call_rpc_count
    end
  end

  def test_list_deployment_resource_pools
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::ListDeploymentResourcePoolsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_deployment_resource_pools_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_deployment_resource_pools, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::ListDeploymentResourcePoolsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_deployment_resource_pools_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_deployment_resource_pools({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_deployment_resource_pools parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_deployment_resource_pools ::Google::Cloud::AIPlatform::V1::ListDeploymentResourcePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_deployment_resource_pools({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_deployment_resource_pools(::Google::Cloud::AIPlatform::V1::ListDeploymentResourcePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_deployment_resource_pools_client_stub.call_rpc_count
    end
  end

  def test_update_deployment_resource_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    deployment_resource_pool = {}
    update_mask = {}

    update_deployment_resource_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_deployment_resource_pool, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::UpdateDeploymentResourcePoolRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::AIPlatform::V1::DeploymentResourcePool), request["deployment_resource_pool"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_deployment_resource_pool_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_deployment_resource_pool({ deployment_resource_pool: deployment_resource_pool, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_deployment_resource_pool deployment_resource_pool: deployment_resource_pool, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_deployment_resource_pool ::Google::Cloud::AIPlatform::V1::UpdateDeploymentResourcePoolRequest.new(deployment_resource_pool: deployment_resource_pool, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_deployment_resource_pool({ deployment_resource_pool: deployment_resource_pool, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_deployment_resource_pool(::Google::Cloud::AIPlatform::V1::UpdateDeploymentResourcePoolRequest.new(deployment_resource_pool: deployment_resource_pool, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_deployment_resource_pool_client_stub.call_rpc_count
    end
  end

  def test_delete_deployment_resource_pool
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_deployment_resource_pool_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_deployment_resource_pool, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeleteDeploymentResourcePoolRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_deployment_resource_pool_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_deployment_resource_pool({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_deployment_resource_pool name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_deployment_resource_pool ::Google::Cloud::AIPlatform::V1::DeleteDeploymentResourcePoolRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_deployment_resource_pool({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_deployment_resource_pool(::Google::Cloud::AIPlatform::V1::DeleteDeploymentResourcePoolRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_deployment_resource_pool_client_stub.call_rpc_count
    end
  end

  def test_query_deployed_models
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::AIPlatform::V1::QueryDeployedModelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    deployment_resource_pool = "hello world"
    page_size = 42
    page_token = "hello world"

    query_deployed_models_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :query_deployed_models, name
      assert_kind_of ::Google::Cloud::AIPlatform::V1::QueryDeployedModelsRequest, request
      assert_equal "hello world", request["deployment_resource_pool"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, query_deployed_models_client_stub do
      # Create client
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.query_deployed_models({ deployment_resource_pool: deployment_resource_pool, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.query_deployed_models deployment_resource_pool: deployment_resource_pool, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.query_deployed_models ::Google::Cloud::AIPlatform::V1::QueryDeployedModelsRequest.new(deployment_resource_pool: deployment_resource_pool, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.query_deployed_models({ deployment_resource_pool: deployment_resource_pool, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.query_deployed_models(::Google::Cloud::AIPlatform::V1::QueryDeployedModelsRequest.new(deployment_resource_pool: deployment_resource_pool, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, query_deployed_models_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::AIPlatform::V1::DeploymentResourcePoolService::Operations, client.operations_client
  end
end
