# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/aiplatform/v1/dataset_service_pb"
require "google/cloud/ai_platform/v1/dataset_service/rest"


class ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset = {}

    create_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_create_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dataset({ parent: parent, dataset: dataset }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dataset parent: parent, dataset: dataset do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dataset ::Google::Cloud::AIPlatform::V1::CreateDatasetRequest.new(parent: parent, dataset: dataset) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dataset({ parent: parent, dataset: dataset }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dataset(::Google::Cloud::AIPlatform::V1::CreateDatasetRequest.new(parent: parent, dataset: dataset), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dataset_client_stub.call_count
      end
    end
  end

  def test_get_dataset
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Dataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    read_mask = {}

    get_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_get_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dataset({ name: name, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dataset name: name, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dataset ::Google::Cloud::AIPlatform::V1::GetDatasetRequest.new(name: name, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dataset({ name: name, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dataset(::Google::Cloud::AIPlatform::V1::GetDatasetRequest.new(name: name, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dataset_client_stub.call_count
      end
    end
  end

  def test_update_dataset
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::Dataset.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dataset = {}
    update_mask = {}

    update_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_update_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dataset({ dataset: dataset, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dataset dataset: dataset, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dataset ::Google::Cloud::AIPlatform::V1::UpdateDatasetRequest.new(dataset: dataset, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dataset({ dataset: dataset, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dataset(::Google::Cloud::AIPlatform::V1::UpdateDatasetRequest.new(dataset: dataset, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dataset_client_stub.call_count
      end
    end
  end

  def test_list_datasets
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListDatasetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_datasets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_list_datasets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_datasets_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_datasets parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_datasets ::Google::Cloud::AIPlatform::V1::ListDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_datasets({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_datasets(::Google::Cloud::AIPlatform::V1::ListDatasetsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_datasets_client_stub.call_count
      end
    end
  end

  def test_delete_dataset
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dataset_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_delete_dataset_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dataset_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dataset({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dataset name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dataset ::Google::Cloud::AIPlatform::V1::DeleteDatasetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dataset({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dataset(::Google::Cloud::AIPlatform::V1::DeleteDatasetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dataset_client_stub.call_count
      end
    end
  end

  def test_import_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    import_configs = [{}]

    import_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_import_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_data({ name: name, import_configs: import_configs }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_data name: name, import_configs: import_configs do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_data ::Google::Cloud::AIPlatform::V1::ImportDataRequest.new(name: name, import_configs: import_configs) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_data({ name: name, import_configs: import_configs }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_data(::Google::Cloud::AIPlatform::V1::ImportDataRequest.new(name: name, import_configs: import_configs), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_data_client_stub.call_count
      end
    end
  end

  def test_export_data
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    export_config = {}

    export_data_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_export_data_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_data_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_data({ name: name, export_config: export_config }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_data name: name, export_config: export_config do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_data ::Google::Cloud::AIPlatform::V1::ExportDataRequest.new(name: name, export_config: export_config) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_data({ name: name, export_config: export_config }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_data(::Google::Cloud::AIPlatform::V1::ExportDataRequest.new(name: name, export_config: export_config), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_data_client_stub.call_count
      end
    end
  end

  def test_create_dataset_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    dataset_version = {}

    create_dataset_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_create_dataset_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_dataset_version_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_dataset_version({ parent: parent, dataset_version: dataset_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_dataset_version parent: parent, dataset_version: dataset_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_dataset_version ::Google::Cloud::AIPlatform::V1::CreateDatasetVersionRequest.new(parent: parent, dataset_version: dataset_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_dataset_version({ parent: parent, dataset_version: dataset_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_dataset_version(::Google::Cloud::AIPlatform::V1::CreateDatasetVersionRequest.new(parent: parent, dataset_version: dataset_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_dataset_version_client_stub.call_count
      end
    end
  end

  def test_update_dataset_version
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::DatasetVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    dataset_version = {}
    update_mask = {}

    update_dataset_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_update_dataset_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_dataset_version_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_dataset_version({ dataset_version: dataset_version, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_dataset_version dataset_version: dataset_version, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_dataset_version ::Google::Cloud::AIPlatform::V1::UpdateDatasetVersionRequest.new(dataset_version: dataset_version, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_dataset_version({ dataset_version: dataset_version, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_dataset_version(::Google::Cloud::AIPlatform::V1::UpdateDatasetVersionRequest.new(dataset_version: dataset_version, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_dataset_version_client_stub.call_count
      end
    end
  end

  def test_delete_dataset_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_dataset_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_delete_dataset_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_dataset_version_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_dataset_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_dataset_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_dataset_version ::Google::Cloud::AIPlatform::V1::DeleteDatasetVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_dataset_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_dataset_version(::Google::Cloud::AIPlatform::V1::DeleteDatasetVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_dataset_version_client_stub.call_count
      end
    end
  end

  def test_get_dataset_version
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::DatasetVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    read_mask = {}

    get_dataset_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_get_dataset_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_dataset_version_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_dataset_version({ name: name, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_dataset_version name: name, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_dataset_version ::Google::Cloud::AIPlatform::V1::GetDatasetVersionRequest.new(name: name, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_dataset_version({ name: name, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_dataset_version(::Google::Cloud::AIPlatform::V1::GetDatasetVersionRequest.new(name: name, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_dataset_version_client_stub.call_count
      end
    end
  end

  def test_list_dataset_versions
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListDatasetVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_dataset_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_list_dataset_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_dataset_versions_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_dataset_versions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_dataset_versions parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_dataset_versions ::Google::Cloud::AIPlatform::V1::ListDatasetVersionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_dataset_versions({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_dataset_versions(::Google::Cloud::AIPlatform::V1::ListDatasetVersionsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_dataset_versions_client_stub.call_count
      end
    end
  end

  def test_restore_dataset_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    restore_dataset_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_restore_dataset_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, restore_dataset_version_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.restore_dataset_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.restore_dataset_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.restore_dataset_version ::Google::Cloud::AIPlatform::V1::RestoreDatasetVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.restore_dataset_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.restore_dataset_version(::Google::Cloud::AIPlatform::V1::RestoreDatasetVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, restore_dataset_version_client_stub.call_count
      end
    end
  end

  def test_list_data_items
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListDataItemsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_data_items_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_list_data_items_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_items_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_items({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_items parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_items ::Google::Cloud::AIPlatform::V1::ListDataItemsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_items({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_items(::Google::Cloud::AIPlatform::V1::ListDataItemsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_items_client_stub.call_count
      end
    end
  end

  def test_search_data_items
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::SearchDataItemsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    order_by_data_item = "hello world"
    dataset = "hello world"
    saved_query = "hello world"
    data_labeling_job = "hello world"
    data_item_filter = "hello world"
    annotations_filter = "hello world"
    annotation_filters = ["hello world"]
    field_mask = {}
    annotations_limit = 42
    page_size = 42
    order_by = "hello world"
    page_token = "hello world"

    search_data_items_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_search_data_items_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_data_items_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_data_items({ order_by_data_item: order_by_data_item, dataset: dataset, saved_query: saved_query, data_labeling_job: data_labeling_job, data_item_filter: data_item_filter, annotations_filter: annotations_filter, annotation_filters: annotation_filters, field_mask: field_mask, annotations_limit: annotations_limit, page_size: page_size, order_by: order_by, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_data_items order_by_data_item: order_by_data_item, dataset: dataset, saved_query: saved_query, data_labeling_job: data_labeling_job, data_item_filter: data_item_filter, annotations_filter: annotations_filter, annotation_filters: annotation_filters, field_mask: field_mask, annotations_limit: annotations_limit, page_size: page_size, order_by: order_by, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_data_items ::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest.new(order_by_data_item: order_by_data_item, dataset: dataset, saved_query: saved_query, data_labeling_job: data_labeling_job, data_item_filter: data_item_filter, annotations_filter: annotations_filter, annotation_filters: annotation_filters, field_mask: field_mask, annotations_limit: annotations_limit, page_size: page_size, order_by: order_by, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_data_items({ order_by_data_item: order_by_data_item, dataset: dataset, saved_query: saved_query, data_labeling_job: data_labeling_job, data_item_filter: data_item_filter, annotations_filter: annotations_filter, annotation_filters: annotation_filters, field_mask: field_mask, annotations_limit: annotations_limit, page_size: page_size, order_by: order_by, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_data_items(::Google::Cloud::AIPlatform::V1::SearchDataItemsRequest.new(order_by_data_item: order_by_data_item, dataset: dataset, saved_query: saved_query, data_labeling_job: data_labeling_job, data_item_filter: data_item_filter, annotations_filter: annotations_filter, annotation_filters: annotation_filters, field_mask: field_mask, annotations_limit: annotations_limit, page_size: page_size, order_by: order_by, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_data_items_client_stub.call_count
      end
    end
  end

  def test_list_saved_queries
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListSavedQueriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_saved_queries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_list_saved_queries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_saved_queries_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_saved_queries({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_saved_queries parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_saved_queries ::Google::Cloud::AIPlatform::V1::ListSavedQueriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_saved_queries({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_saved_queries(::Google::Cloud::AIPlatform::V1::ListSavedQueriesRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_saved_queries_client_stub.call_count
      end
    end
  end

  def test_delete_saved_query
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_saved_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_delete_saved_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_saved_query_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_saved_query({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_saved_query name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_saved_query ::Google::Cloud::AIPlatform::V1::DeleteSavedQueryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_saved_query({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_saved_query(::Google::Cloud::AIPlatform::V1::DeleteSavedQueryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_saved_query_client_stub.call_count
      end
    end
  end

  def test_get_annotation_spec
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::AnnotationSpec.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    read_mask = {}

    get_annotation_spec_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_get_annotation_spec_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_annotation_spec_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_annotation_spec({ name: name, read_mask: read_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_annotation_spec name: name, read_mask: read_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_annotation_spec ::Google::Cloud::AIPlatform::V1::GetAnnotationSpecRequest.new(name: name, read_mask: read_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_annotation_spec({ name: name, read_mask: read_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_annotation_spec(::Google::Cloud::AIPlatform::V1::GetAnnotationSpecRequest.new(name: name, read_mask: read_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_annotation_spec_client_stub.call_count
      end
    end
  end

  def test_list_annotations
    # Create test objects.
    client_result = ::Google::Cloud::AIPlatform::V1::ListAnnotationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    filter = "hello world"
    page_size = 42
    page_token = "hello world"
    read_mask = {}
    order_by = "hello world"

    list_annotations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::ServiceStub.stub :transcode_list_annotations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_annotations_client_stub do
        # Create client
        client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_annotations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_annotations parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_annotations ::Google::Cloud::AIPlatform::V1::ListAnnotationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_annotations({ parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_annotations(::Google::Cloud::AIPlatform::V1::ListAnnotationsRequest.new(parent: parent, filter: filter, page_size: page_size, page_token: page_token, read_mask: read_mask, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_annotations_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::AIPlatform::V1::DatasetService::Rest::Client::Configuration, config
  end
end
