# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# [START aiplatform_v1_generated_PredictionService_StreamGenerateContent_sync]
require "google/cloud/ai_platform/v1"

##
# Snippet for the stream_generate_content call in the PredictionService service
#
# This snippet has been automatically generated and should be regarded as a code
# template only. It will require modifications to work:
# - It may require correct/in-range values for request initialization.
# - It may require specifying regional endpoints when creating the service
# client as shown in https://cloud.google.com/ruby/docs/reference.
#
# This is an auto-generated example demonstrating basic usage of
# Google::Cloud::AIPlatform::V1::PredictionService::Client#stream_generate_content.
#
def stream_generate_content
  # Create a client object. The client can be reused for multiple calls.
  client = Google::Cloud::AIPlatform::V1::PredictionService::Client.new

  # Create a request. To set request fields, pass in keyword arguments.
  request = Google::Cloud::AIPlatform::V1::GenerateContentRequest.new

  # Call the stream_generate_content method to start streaming.
  output = client.stream_generate_content request

  # The returned object is a streamed enumerable yielding elements of type
  # ::Google::Cloud::AIPlatform::V1::GenerateContentResponse
  output.each do |current_response|
    p current_response
  end
end
# [END aiplatform_v1_generated_PredictionService_StreamGenerateContent_sync]
