# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#get_study VizierService.GetStudy}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Study resource.
        #     Format: `projects/{project}/locations/{location}/studies/{study}`
        class GetStudyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#create_study VizierService.CreateStudy}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create the CustomJob in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] study
        #   @return [::Google::Cloud::AIPlatform::V1::Study]
        #     Required. The Study configuration used to create the Study.
        class CreateStudyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#list_studies VizierService.ListStudies}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list the Study from.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token to request the next page of results.
        #     If unspecified, there are no subsequent pages.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of studies to return per "page" of results.
        #     If unspecified, service will pick an appropriate default.
        class ListStudiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#list_studies VizierService.ListStudies}.
        # @!attribute [rw] studies
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Study>]
        #     The studies associated with the project.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Passes this token as the `page_token` field of the request for a
        #     subsequent call.
        #     If this field is omitted, there are no subsequent pages.
        class ListStudiesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#delete_study VizierService.DeleteStudy}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Study resource to be deleted.
        #     Format: `projects/{project}/locations/{location}/studies/{study}`
        class DeleteStudyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#lookup_study VizierService.LookupStudy}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to get the Study from.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The user-defined display name of the Study
        class LookupStudyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#suggest_trials VizierService.SuggestTrials}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location that the Study belongs to.
        #     Format: `projects/{project}/locations/{location}/studies/{study}`
        # @!attribute [rw] suggestion_count
        #   @return [::Integer]
        #     Required. The number of suggestions requested. It must be positive.
        # @!attribute [rw] client_id
        #   @return [::String]
        #     Required. The identifier of the client that is requesting the suggestion.
        #
        #     If multiple SuggestTrialsRequests have the same `client_id`,
        #     the service will return the identical suggested Trial if the Trial is
        #     pending, and provide a new Trial if the last suggested Trial was completed.
        # @!attribute [rw] contexts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TrialContext>]
        #     Optional. This allows you to specify the "context" for a Trial; a context
        #     is a slice (a subspace) of the search space.
        #
        #     Typical uses for contexts:
        #     1) You are using Vizier to tune a server for best performance, but there's
        #       a strong weekly cycle.  The context specifies the day-of-week.
        #       This allows Tuesday to generalize from Wednesday without assuming that
        #       everything is identical.
        #     2) Imagine you're optimizing some medical treatment for people.
        #       As they walk in the door, you know certain facts about them
        #       (e.g. sex, weight, height, blood-pressure).  Put that information in the
        #       context, and Vizier will adapt its suggestions to the patient.
        #     3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
        #       conditions as contexts, and Vizier will generalize between "A" and "B"
        #       conditions.  If they are similar, this will allow Vizier to converge
        #       to the optimum faster than if "A" and "B" were separate Studies.
        #       NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
        #       CreateTrial() RPC; that's the asynchronous option where you don't need a
        #       close association between contexts and suggestions.
        #
        #     NOTE: All the Parameters you set in a context MUST be defined in the
        #       Study.
        #     NOTE: You must supply 0 or $suggestion_count contexts.
        #       If you don't supply any contexts, Vizier will make suggestions
        #       from the full search space specified in the StudySpec; if you supply
        #       a full set of context, each suggestion will match the corresponding
        #       context.
        #     NOTE: A Context with no features set matches anything, and allows
        #       suggestions from the full search space.
        #     NOTE: Contexts MUST lie within the search space specified in the
        #       StudySpec.  It's an error if they don't.
        #     NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
        #       new suggestions are generated.
        #     NOTE: Generation of suggestions involves a match between a Context and
        #       (optionally) a REQUESTED trial; if that match is not fully specified, a
        #       suggestion will be geneated in the merged subspace.
        class SuggestTrialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#suggest_trials VizierService.SuggestTrials}.
        # @!attribute [rw] trials
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Trial>]
        #     A list of Trials.
        # @!attribute [rw] study_state
        #   @return [::Google::Cloud::AIPlatform::V1::Study::State]
        #     The state of the Study.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the operation was started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which operation processing completed.
        class SuggestTrialsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform Trials suggestion.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for suggesting Trials.
        # @!attribute [rw] client_id
        #   @return [::String]
        #     The identifier of the client that is requesting the suggestion.
        #
        #     If multiple SuggestTrialsRequests have the same `client_id`,
        #     the service will return the identical suggested Trial if the Trial is
        #     pending, and provide a new Trial if the last suggested Trial was completed.
        class SuggestTrialsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#create_trial VizierService.CreateTrial}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Study to create the Trial in.
        #     Format: `projects/{project}/locations/{location}/studies/{study}`
        # @!attribute [rw] trial
        #   @return [::Google::Cloud::AIPlatform::V1::Trial]
        #     Required. The Trial to create.
        class CreateTrialRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#get_trial VizierService.GetTrial}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Trial resource.
        #     Format:
        #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
        class GetTrialRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#list_trials VizierService.ListTrials}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Study to list the Trial from.
        #     Format: `projects/{project}/locations/{location}/studies/{study}`
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token to request the next page of results.
        #     If unspecified, there are no subsequent pages.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The number of Trials to retrieve per "page" of results.
        #     If unspecified, the service will pick an appropriate default.
        class ListTrialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#list_trials VizierService.ListTrials}.
        # @!attribute [rw] trials
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Trial>]
        #     The Trials associated with the Study.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pass this token as the `page_token` field of the request for a
        #     subsequent call.
        #     If this field is omitted, there are no subsequent pages.
        class ListTrialsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#add_trial_measurement VizierService.AddTrialMeasurement}.
        # @!attribute [rw] trial_name
        #   @return [::String]
        #     Required. The name of the trial to add measurement.
        #     Format:
        #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
        # @!attribute [rw] measurement
        #   @return [::Google::Cloud::AIPlatform::V1::Measurement]
        #     Required. The measurement to be added to a Trial.
        class AddTrialMeasurementRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#complete_trial VizierService.CompleteTrial}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Trial's name.
        #     Format:
        #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
        # @!attribute [rw] final_measurement
        #   @return [::Google::Cloud::AIPlatform::V1::Measurement]
        #     Optional. If provided, it will be used as the completed Trial's
        #     final_measurement; Otherwise, the service will auto-select a
        #     previously reported measurement as the final-measurement
        # @!attribute [rw] trial_infeasible
        #   @return [::Boolean]
        #     Optional. True if the Trial cannot be run with the given Parameter, and
        #     final_measurement will be ignored.
        # @!attribute [rw] infeasible_reason
        #   @return [::String]
        #     Optional. A human readable reason why the trial was infeasible. This should
        #     only be provided if `trial_infeasible` is true.
        class CompleteTrialRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#delete_trial VizierService.DeleteTrial}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Trial's name.
        #     Format:
        #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
        class DeleteTrialRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#check_trial_early_stopping_state VizierService.CheckTrialEarlyStoppingState}.
        # @!attribute [rw] trial_name
        #   @return [::String]
        #     Required. The Trial's name.
        #     Format:
        #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
        class CheckTrialEarlyStoppingStateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#check_trial_early_stopping_state VizierService.CheckTrialEarlyStoppingState}.
        # @!attribute [rw] should_stop
        #   @return [::Boolean]
        #     True if the Trial should stop.
        class CheckTrialEarlyStoppingStateResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # This message will be placed in the metadata field of a
        # google.longrunning.Operation associated with a CheckTrialEarlyStoppingState
        # request.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for suggesting Trials.
        # @!attribute [rw] study
        #   @return [::String]
        #     The name of the Study that the Trial belongs to.
        # @!attribute [rw] trial
        #   @return [::String]
        #     The Trial name.
        class CheckTrialEarlyStoppingStateMetatdata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#stop_trial VizierService.StopTrial}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The Trial's name.
        #     Format:
        #     `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
        class StopTrialRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#list_optimal_trials VizierService.ListOptimalTrials}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The name of the Study that the optimal Trial belongs to.
        class ListOptimalTrialsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::VizierService::Client#list_optimal_trials VizierService.ListOptimalTrials}.
        # @!attribute [rw] optimal_trials
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Trial>]
        #     The pareto-optimal Trials for multiple objective Study or the
        #     optimal trial for single objective Study. The definition of
        #     pareto-optimal can be checked in wiki page.
        #     https://en.wikipedia.org/wiki/Pareto_efficiency
        class ListOptimalTrialsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
