# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A query to retrieve relevant contexts.
        # @!attribute [rw] text
        #   @return [::String]
        #     Optional. The query in text format to get relevant contexts.
        # @!attribute [rw] rag_retrieval_config
        #   @return [::Google::Cloud::AIPlatform::V1::RagRetrievalConfig]
        #     Optional. The retrieval config for the query.
        class RagQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::VertexRagService::Client#retrieve_contexts VertexRagService.RetrieveContexts}.
        # @!attribute [rw] vertex_rag_store
        #   @return [::Google::Cloud::AIPlatform::V1::RetrieveContextsRequest::VertexRagStore]
        #     The data source for Vertex RagStore.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location from which to retrieve
        #     RagContexts. The users must have permission to make a call in the project.
        #     Format:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] query
        #   @return [::Google::Cloud::AIPlatform::V1::RagQuery]
        #     Required. Single RAG retrieve query.
        class RetrieveContextsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The data source for Vertex RagStore.
          # @!attribute [rw] rag_resources
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::RetrieveContextsRequest::VertexRagStore::RagResource>]
          #     Optional. The representation of the rag source. It can be used to specify
          #     corpus only or ragfiles. Currently only support one corpus or multiple
          #     files from one corpus. In the future we may open up multiple corpora
          #     support.
          # @!attribute [rw] vector_distance_threshold
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Float]
          #     Optional. Only return contexts with vector distance smaller than the
          #     threshold.
          class VertexRagStore
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The definition of the Rag resource.
            # @!attribute [rw] rag_corpus
            #   @return [::String]
            #     Optional. RagCorpora resource name.
            #     Format:
            #     `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
            # @!attribute [rw] rag_file_ids
            #   @return [::Array<::String>]
            #     Optional. rag_file_id. The files should be in the same rag_corpus set
            #     in rag_corpus field.
            class RagResource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Relevant contexts for one query.
        # @!attribute [rw] contexts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::RagContexts::Context>]
        #     All its contexts.
        class RagContexts
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A context of the query.
          # @!attribute [rw] source_uri
          #   @return [::String]
          #     If the file is imported from Cloud Storage or Google Drive, source_uri
          #     will be original file URI in Cloud Storage or Google Drive; if file is
          #     uploaded, source_uri will be file display name.
          # @!attribute [rw] source_display_name
          #   @return [::String]
          #     The file display name.
          # @!attribute [rw] text
          #   @return [::String]
          #     The text chunk.
          # @!attribute [rw] score
          #   @return [::Float]
          #     According to the underlying Vector DB and the selected metric type, the
          #     score can be either the distance or the similarity between the query and
          #     the context and its range depends on the metric type.
          #
          #     For example, if the metric type is COSINE_DISTANCE, it represents the
          #     distance between the query and the context. The larger the distance, the
          #     less relevant the context is to the query. The range is [0, 2], while 0
          #     means the most relevant and 2 means the least relevant.
          # @!attribute [rw] chunk
          #   @return [::Google::Cloud::AIPlatform::V1::RagChunk]
          #     Context of the retrieved chunk.
          class Context
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::VertexRagService::Client#retrieve_contexts VertexRagService.RetrieveContexts}.
        # @!attribute [rw] contexts
        #   @return [::Google::Cloud::AIPlatform::V1::RagContexts]
        #     The contexts of the query.
        class RetrieveContextsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for AugmentPrompt.
        # @!attribute [rw] vertex_rag_store
        #   @return [::Google::Cloud::AIPlatform::V1::VertexRagStore]
        #     Optional. Retrieves contexts from the Vertex RagStore.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location from which to augment prompt.
        #     The users must have permission to make a call in the project.
        #     Format:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] contents
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Content>]
        #     Optional. Input content to augment, only text format is supported for now.
        # @!attribute [rw] model
        #   @return [::Google::Cloud::AIPlatform::V1::AugmentPromptRequest::Model]
        #     Optional. Metadata of the backend deployed model.
        class AugmentPromptRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Metadata of the backend deployed model.
          # @!attribute [rw] model
          #   @return [::String]
          #     Optional. The model that the user will send the augmented prompt for
          #     content generation.
          # @!attribute [rw] model_version
          #   @return [::String]
          #     Optional. The model version of the backend deployed model.
          class Model
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for AugmentPrompt.
        # @!attribute [rw] augmented_prompt
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Content>]
        #     Augmented prompt, only text format is supported for now.
        # @!attribute [rw] facts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Fact>]
        #     Retrieved facts from RAG data sources.
        class AugmentPromptResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CorroborateContent.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location from which to corroborate text.
        #     The users must have permission to make a call in the project.
        #     Format:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] content
        #   @return [::Google::Cloud::AIPlatform::V1::Content]
        #     Optional. Input content to corroborate, only text format is supported for
        #     now.
        # @!attribute [rw] facts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Fact>]
        #     Optional. Facts used to generate the text can also be used to corroborate
        #     the text.
        # @!attribute [rw] parameters
        #   @return [::Google::Cloud::AIPlatform::V1::CorroborateContentRequest::Parameters]
        #     Optional. Parameters that can be set to override default settings per
        #     request.
        class CorroborateContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Parameters that can be overrided per request.
          # @!attribute [rw] citation_threshold
          #   @return [::Float]
          #     Optional. Only return claims with citation score larger than the
          #     threshold.
          class Parameters
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for CorroborateContent.
        # @!attribute [rw] corroboration_score
        #   @return [::Float]
        #     Confidence score of corroborating content. Value is [0,1] with 1 is the
        #     most confidence.
        # @!attribute [rw] claims
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Claim>]
        #     Claims that are extracted from the input content and facts that support the
        #     claims.
        class CorroborateContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The fact used in grounding.
        # @!attribute [rw] query
        #   @return [::String]
        #     Query that is used to retrieve this fact.
        # @!attribute [rw] title
        #   @return [::String]
        #     If present, it refers to the title of this fact.
        # @!attribute [rw] uri
        #   @return [::String]
        #     If present, this uri links to the source of the fact.
        # @!attribute [rw] summary
        #   @return [::String]
        #     If present, the summary/snippet of the fact.
        # @!attribute [rw] vector_distance
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Float]
        #     If present, the distance between the query vector and this fact vector.
        # @!attribute [rw] score
        #   @return [::Float]
        #     If present, according to the underlying Vector DB and the selected metric
        #     type, the score can be either the distance or the similarity between the
        #     query and the fact and its range depends on the metric type.
        #
        #     For example, if the metric type is COSINE_DISTANCE, it represents the
        #     distance between the query and the fact. The larger the distance, the less
        #     relevant the fact is to the query. The range is [0, 2], while 0 means the
        #     most relevant and 2 means the least relevant.
        # @!attribute [rw] chunk
        #   @return [::Google::Cloud::AIPlatform::V1::RagChunk]
        #     If present, chunk properties.
        class Fact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Claim that is extracted from the input text and facts that support it.
        # @!attribute [rw] start_index
        #   @return [::Integer]
        #     Index in the input text where the claim starts (inclusive).
        # @!attribute [rw] end_index
        #   @return [::Integer]
        #     Index in the input text where the claim ends (exclusive).
        # @!attribute [rw] fact_indexes
        #   @return [::Array<::Integer>]
        #     Indexes of the facts supporting this claim.
        # @!attribute [rw] score
        #   @return [::Float]
        #     Confidence score of this corroboration.
        class Claim
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
