# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Usage metadata about the content generation request and response.
        # This message provides a detailed breakdown of token usage and other
        # relevant metrics.
        # @!attribute [rw] prompt_token_count
        #   @return [::Integer]
        #     The total number of tokens in the prompt. This includes any text, images,
        #     or other media provided in the request. When `cached_content` is set,
        #     this also includes the number of tokens in the cached content.
        # @!attribute [rw] candidates_token_count
        #   @return [::Integer]
        #     The total number of tokens in the generated candidates.
        # @!attribute [rw] total_token_count
        #   @return [::Integer]
        #     The total number of tokens for the entire request. This is the sum of
        #     `prompt_token_count`, `candidates_token_count`,
        #     `tool_use_prompt_token_count`, and `thoughts_token_count`.
        # @!attribute [r] tool_use_prompt_token_count
        #   @return [::Integer]
        #     Output only. The number of tokens in the results from tool executions,
        #     which are provided back to the model as input, if applicable.
        # @!attribute [r] thoughts_token_count
        #   @return [::Integer]
        #     Output only. The number of tokens that were part of the model's generated
        #     "thoughts" output, if applicable.
        # @!attribute [r] cached_content_token_count
        #   @return [::Integer]
        #     Output only. The number of tokens in the cached content that was used for
        #     this request.
        # @!attribute [r] prompt_tokens_details
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModalityTokenCount>]
        #     Output only. A detailed breakdown of the token count for each modality in
        #     the prompt.
        # @!attribute [r] cache_tokens_details
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModalityTokenCount>]
        #     Output only. A detailed breakdown of the token count for each modality in
        #     the cached content.
        # @!attribute [r] candidates_tokens_details
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModalityTokenCount>]
        #     Output only. A detailed breakdown of the token count for each modality in
        #     the generated candidates.
        # @!attribute [r] tool_use_prompt_tokens_details
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::ModalityTokenCount>]
        #     Output only. A detailed breakdown by modality of the token counts from the
        #     results of tool executions, which are provided back to the model as input.
        # @!attribute [r] traffic_type
        #   @return [::Google::Cloud::AIPlatform::V1::UsageMetadata::TrafficType]
        #     Output only. The traffic type for this request.
        class UsageMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of traffic that this request was processed with, indicating which
          # quota gets consumed.
          module TrafficType
            # Unspecified request traffic type.
            TRAFFIC_TYPE_UNSPECIFIED = 0

            # Type for Pay-As-You-Go traffic.
            ON_DEMAND = 1

            # Type for Provisioned Throughput traffic.
            PROVISIONED_THROUGHPUT = 2
          end
        end
      end
    end
  end
end
