# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A list of boolean values.
        # @!attribute [rw] values
        #   @return [::Array<::Boolean>]
        #     A list of bool values.
        class BoolArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of double values.
        # @!attribute [rw] values
        #   @return [::Array<::Float>]
        #     A list of double values.
        class DoubleArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of int64 values.
        # @!attribute [rw] values
        #   @return [::Array<::Integer>]
        #     A list of int64 values.
        class Int64Array
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of string values.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     A list of string values.
        class StringArray
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A tensor value type.
        # @!attribute [rw] dtype
        #   @return [::Google::Cloud::AIPlatform::V1::Tensor::DataType]
        #     The data type of tensor.
        # @!attribute [rw] shape
        #   @return [::Array<::Integer>]
        #     Shape of the tensor.
        # @!attribute [rw] bool_val
        #   @return [::Array<::Boolean>]
        #     Type specific representations that make it easy to create tensor protos in
        #     all languages.  Only the representation corresponding to "dtype" can
        #     be set.  The values hold the flattened representation of the tensor in
        #     row major order.
        #
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::BOOL BOOL}
        # @!attribute [rw] string_val
        #   @return [::Array<::String>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::STRING STRING}
        # @!attribute [rw] bytes_val
        #   @return [::Array<::String>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::STRING STRING}
        # @!attribute [rw] float_val
        #   @return [::Array<::Float>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::FLOAT FLOAT}
        # @!attribute [rw] double_val
        #   @return [::Array<::Float>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::DOUBLE DOUBLE}
        # @!attribute [rw] int_val
        #   @return [::Array<::Integer>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::INT8 INT_8}
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::INT16 INT_16}
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::INT32 INT_32}
        # @!attribute [rw] int64_val
        #   @return [::Array<::Integer>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::INT64 INT64}
        # @!attribute [rw] uint_val
        #   @return [::Array<::Integer>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::UINT8 UINT8}
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::UINT16 UINT16}
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::UINT32 UINT32}
        # @!attribute [rw] uint64_val
        #   @return [::Array<::Integer>]
        #     {::Google::Cloud::AIPlatform::V1::Tensor::DataType::UINT64 UINT64}
        # @!attribute [rw] list_val
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Tensor>]
        #     A list of tensor values.
        # @!attribute [rw] struct_val
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AIPlatform::V1::Tensor}]
        #     A map of string to tensor.
        # @!attribute [rw] tensor_val
        #   @return [::String]
        #     Serialized raw tensor content.
        class Tensor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AIPlatform::V1::Tensor]
          class StructValEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Data type of the tensor.
          module DataType
            # Not a legal value for DataType. Used to indicate a DataType field has not
            # been set.
            DATA_TYPE_UNSPECIFIED = 0

            # Data types that all computation devices are expected to be
            # capable to support.
            BOOL = 1

            STRING = 2

            FLOAT = 3

            DOUBLE = 4

            INT8 = 5

            INT16 = 6

            INT32 = 7

            INT64 = 8

            UINT8 = 9

            UINT16 = 10

            UINT32 = 11

            UINT64 = 12
          end
        end
      end
    end
  end
end
