# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Represents a TuningJob that runs with Google owned models.
        # @!attribute [rw] base_model
        #   @return [::String]
        #     The base model that is being tuned. See [Supported
        #     models](https://cloud.google.com/vertex-ai/generative-ai/docs/model-reference/tuning#supported_models).
        #
        #     Note: The following fields are mutually exclusive: `base_model`, `pre_tuned_model`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pre_tuned_model
        #   @return [::Google::Cloud::AIPlatform::V1::PreTunedModel]
        #     The pre-tuned model for continuous tuning.
        #
        #     Note: The following fields are mutually exclusive: `pre_tuned_model`, `base_model`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] supervised_tuning_spec
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedTuningSpec]
        #     Tuning Spec for Supervised Fine Tuning.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. Resource name of a TuningJob. Format:
        #     `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
        # @!attribute [rw] tuned_model_display_name
        #   @return [::String]
        #     Optional. The display name of the
        #     {::Google::Cloud::AIPlatform::V1::Model TunedModel}. The name can be up to 128
        #     characters long and can consist of any UTF-8 characters. For continuous
        #     tuning, tuned_model_display_name will by default use the same display name
        #     as the pre-tuned model. If a new display name is provided, the tuning job
        #     will create a new model instead of a new version.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob}.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AIPlatform::V1::JobState]
        #     Output only. The detailed state of the job.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob} was created.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob} for the first time
        #     entered the `JOB_STATE_RUNNING` state.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the TuningJob entered any of the following
        #     {::Google::Cloud::AIPlatform::V1::JobState JobStates}: `JOB_STATE_SUCCEEDED`,
        #     `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time when the
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob} was most recently
        #     updated.
        # @!attribute [r] error
        #   @return [::Google::Rpc::Status]
        #     Output only. Only populated when job's state is `JOB_STATE_FAILED` or
        #     `JOB_STATE_CANCELLED`.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata to organize
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob} and generated resources
        #     such as {::Google::Cloud::AIPlatform::V1::Model Model} and
        #     {::Google::Cloud::AIPlatform::V1::Endpoint Endpoint}.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        # @!attribute [r] experiment
        #   @return [::String]
        #     Output only. The Experiment associated with this
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob}.
        # @!attribute [r] tuned_model
        #   @return [::Google::Cloud::AIPlatform::V1::TunedModel]
        #     Output only. The tuned model resources associated with this
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob}.
        # @!attribute [r] tuning_data_stats
        #   @return [::Google::Cloud::AIPlatform::V1::TuningDataStats]
        #     Output only. The tuning data statistics associated with this
        #     {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob}.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key options for a TuningJob. If this is set,
        #     then all resources created by the TuningJob will be encrypted with the
        #     provided encryption key.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     The service account that the tuningJob workload runs as.
        #     If not specified, the Vertex AI Secure Fine-Tuned Service Agent in the
        #     project will be used. See
        #     https://cloud.google.com/iam/docs/service-agents#vertex-ai-secure-fine-tuning-service-agent
        #
        #     Users starting the pipeline must have the `iam.serviceAccounts.actAs`
        #     permission on this service account.
        class TuningJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The Model Registry Model and Online Prediction Endpoint associated with
        # this {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob}.
        # @!attribute [r] model
        #   @return [::String]
        #     Output only. The resource name of the TunedModel. Format:
        #
        #     `projects/{project}/locations/{location}/models/{model}@{version_id}`
        #
        #     When tuning from a base model, the version ID will be 1.
        #
        #     For continuous tuning, if the provided tuned_model_display_name is set and
        #     different from parent model's display name, the tuned model will have a new
        #     parent model with version 1. Otherwise the version id will be incremented
        #     by 1 from the last version ID in the parent model. E.g.,
        #
        #     `projects/{project}/locations/{location}/models/{model}@{last_version_id +
        #     1}`
        # @!attribute [r] endpoint
        #   @return [::String]
        #     Output only. A resource name of an Endpoint. Format:
        #     `projects/{project}/locations/{location}/endpoints/{endpoint}`.
        # @!attribute [r] checkpoints
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TunedModelCheckpoint>]
        #     Output only. The checkpoints associated with this TunedModel.
        #     This field is only populated for tuning jobs that enable intermediate
        #     checkpoints.
        class TunedModel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Dataset distribution for Supervised Tuning.
        # @!attribute [r] sum
        #   @return [::Integer]
        #     Output only. Sum of a given population of values.
        # @!attribute [r] billable_sum
        #   @return [::Integer]
        #     Output only. Sum of a given population of values that are billable.
        # @!attribute [r] min
        #   @return [::Float]
        #     Output only. The minimum of the population values.
        # @!attribute [r] max
        #   @return [::Float]
        #     Output only. The maximum of the population values.
        # @!attribute [r] mean
        #   @return [::Float]
        #     Output only. The arithmetic mean of the values in the population.
        # @!attribute [r] median
        #   @return [::Float]
        #     Output only. The median of the values in the population.
        # @!attribute [r] p5
        #   @return [::Float]
        #     Output only. The 5th percentile of the values in the population.
        # @!attribute [r] p95
        #   @return [::Float]
        #     Output only. The 95th percentile of the values in the population.
        # @!attribute [r] buckets
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::SupervisedTuningDatasetDistribution::DatasetBucket>]
        #     Output only. Defines the histogram bucket.
        class SupervisedTuningDatasetDistribution
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Dataset bucket used to create a histogram for the distribution given a
          # population of values.
          # @!attribute [r] count
          #   @return [::Float]
          #     Output only. Number of values in the bucket.
          # @!attribute [r] left
          #   @return [::Float]
          #     Output only. Left bound of the bucket.
          # @!attribute [r] right
          #   @return [::Float]
          #     Output only. Right bound of the bucket.
          class DatasetBucket
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Tuning data statistics for Supervised Tuning.
        # @!attribute [r] tuning_dataset_example_count
        #   @return [::Integer]
        #     Output only. Number of examples in the tuning dataset.
        # @!attribute [r] total_tuning_character_count
        #   @return [::Integer]
        #     Output only. Number of tuning characters in the tuning dataset.
        # @!attribute [r] total_billable_character_count
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     Output only. Number of billable characters in the tuning dataset.
        # @!attribute [r] total_billable_token_count
        #   @return [::Integer]
        #     Output only. Number of billable tokens in the tuning dataset.
        # @!attribute [r] tuning_step_count
        #   @return [::Integer]
        #     Output only. Number of tuning steps for this Tuning Job.
        # @!attribute [r] user_input_token_distribution
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedTuningDatasetDistribution]
        #     Output only. Dataset distributions for the user input tokens.
        # @!attribute [r] user_output_token_distribution
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedTuningDatasetDistribution]
        #     Output only. Dataset distributions for the user output tokens.
        # @!attribute [r] user_message_per_example_distribution
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedTuningDatasetDistribution]
        #     Output only. Dataset distributions for the messages per example.
        # @!attribute [r] user_dataset_examples
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Content>]
        #     Output only. Sample user messages in the training dataset uri.
        # @!attribute [r] total_truncated_example_count
        #   @return [::Integer]
        #     Output only. The number of examples in the dataset that have been dropped.
        #     An example can be dropped for reasons including: too many tokens, contains
        #     an invalid image, contains too many images, etc.
        # @!attribute [r] truncated_example_indices
        #   @return [::Array<::Integer>]
        #     Output only. A partial sample of the indices (starting from 1) of the
        #     dropped examples.
        # @!attribute [r] dropped_example_reasons
        #   @return [::Array<::String>]
        #     Output only. For each index in `truncated_example_indices`, the user-facing
        #     reason why the example was dropped.
        class SupervisedTuningDataStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The tuning data statistic values for
        # {::Google::Cloud::AIPlatform::V1::TuningJob TuningJob}.
        # @!attribute [rw] supervised_tuning_data_stats
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedTuningDataStats]
        #     The SFT Tuning data stats.
        class TuningDataStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Hyperparameters for SFT.
        # @!attribute [rw] epoch_count
        #   @return [::Integer]
        #     Optional. Number of complete passes the model makes over the entire
        #     training dataset during training.
        # @!attribute [rw] learning_rate_multiplier
        #   @return [::Float]
        #     Optional. Multiplier for adjusting the default learning rate.
        # @!attribute [rw] adapter_size
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedHyperParameters::AdapterSize]
        #     Optional. Adapter size for tuning.
        class SupervisedHyperParameters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported adapter sizes for tuning.
          module AdapterSize
            # Adapter size is unspecified.
            ADAPTER_SIZE_UNSPECIFIED = 0

            # Adapter size 1.
            ADAPTER_SIZE_ONE = 1

            # Adapter size 2.
            ADAPTER_SIZE_TWO = 6

            # Adapter size 4.
            ADAPTER_SIZE_FOUR = 2

            # Adapter size 8.
            ADAPTER_SIZE_EIGHT = 3

            # Adapter size 16.
            ADAPTER_SIZE_SIXTEEN = 4

            # Adapter size 32.
            ADAPTER_SIZE_THIRTY_TWO = 5
          end
        end

        # Tuning Spec for Supervised Tuning for first party models.
        # @!attribute [rw] training_dataset_uri
        #   @return [::String]
        #     Required. Cloud Storage path to file containing training dataset for
        #     tuning. The dataset must be formatted as a JSONL file.
        # @!attribute [rw] validation_dataset_uri
        #   @return [::String]
        #     Optional. Cloud Storage path to file containing validation dataset for
        #     tuning. The dataset must be formatted as a JSONL file.
        # @!attribute [rw] hyper_parameters
        #   @return [::Google::Cloud::AIPlatform::V1::SupervisedHyperParameters]
        #     Optional. Hyperparameters for SFT.
        # @!attribute [rw] export_last_checkpoint_only
        #   @return [::Boolean]
        #     Optional. If set to true, disable intermediate checkpoints for SFT and only
        #     the last checkpoint will be exported. Otherwise, enable intermediate
        #     checkpoints for SFT. Default is false.
        class SupervisedTuningSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TunedModel Reference for legacy model migration.
        # @!attribute [rw] tuned_model
        #   @return [::String]
        #     Support migration from model registry.
        #
        #     Note: The following fields are mutually exclusive: `tuned_model`, `tuning_job`, `pipeline_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tuning_job
        #   @return [::String]
        #     Support migration from tuning job list page, from gemini-1.0-pro-002
        #     to 1.5 and above.
        #
        #     Note: The following fields are mutually exclusive: `tuning_job`, `tuned_model`, `pipeline_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pipeline_job
        #   @return [::String]
        #     Support migration from tuning job list page, from bison model to gemini
        #     model.
        #
        #     Note: The following fields are mutually exclusive: `pipeline_job`, `tuned_model`, `tuning_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TunedModelRef
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TunedModelCheckpoint for the Tuned Model of a Tuning Job.
        # @!attribute [rw] checkpoint_id
        #   @return [::String]
        #     The ID of the checkpoint.
        # @!attribute [rw] epoch
        #   @return [::Integer]
        #     The epoch of the checkpoint.
        # @!attribute [rw] step
        #   @return [::Integer]
        #     The step of the checkpoint.
        # @!attribute [rw] endpoint
        #   @return [::String]
        #     The Endpoint resource name that the checkpoint is deployed to. Format:
        #     `projects/{project}/locations/{location}/endpoints/{endpoint}`.
        class TunedModelCheckpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pre-tuned model for continuous tuning.
        # @!attribute [rw] tuned_model_name
        #   @return [::String]
        #     The resource name of the Model.
        #     E.g., a model resource name with a specified version id or alias:
        #
        #     `projects/{project}/locations/{location}/models/{model}@{version_id}`
        #
        #     `projects/{project}/locations/{location}/models/{model}@{alias}`
        #
        #     Or, omit the version id to use the default version:
        #
        #     `projects/{project}/locations/{location}/models/{model}`
        # @!attribute [rw] checkpoint_id
        #   @return [::String]
        #     Optional. The source checkpoint id. If not specified, the default
        #     checkpoint will be used.
        # @!attribute [r] base_model
        #   @return [::String]
        #     Output only. The name of the base model this
        #     {::Google::Cloud::AIPlatform::V1::PreTunedModel PreTunedModel} was tuned from.
        class PreTunedModel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
