# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Tool details that the model may use to generate response.
        #
        # A `Tool` is a piece of code that enables the system to interact with
        # external systems to perform an action, or set of actions, outside of
        # knowledge and scope of the model. A Tool object should contain exactly
        # one type of Tool (e.g FunctionDeclaration, Retrieval or
        # GoogleSearchRetrieval).
        # @!attribute [rw] function_declarations
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::FunctionDeclaration>]
        #     Optional. Function tool type.
        #     One or more function declarations to be passed to the model along with the
        #     current user query. Model may decide to call a subset of these functions
        #     by populating {::Google::Cloud::AIPlatform::V1::Part#function_call FunctionCall}
        #     in the response. User should provide a
        #     {::Google::Cloud::AIPlatform::V1::Part#function_response FunctionResponse} for
        #     each function call in the next turn. Based on the function responses, Model
        #     will generate the final response back to the user. Maximum 128 function
        #     declarations can be provided.
        # @!attribute [rw] retrieval
        #   @return [::Google::Cloud::AIPlatform::V1::Retrieval]
        #     Optional. Retrieval tool type.
        #     System will always execute the provided retrieval tool(s) to get external
        #     knowledge to answer the prompt. Retrieval results are presented to the
        #     model for generation.
        # @!attribute [rw] google_search
        #   @return [::Google::Cloud::AIPlatform::V1::Tool::GoogleSearch]
        #     Optional. GoogleSearch tool type.
        #     Tool to support Google Search in Model. Powered by Google.
        # @!attribute [rw] google_search_retrieval
        #   @return [::Google::Cloud::AIPlatform::V1::GoogleSearchRetrieval]
        #     Optional. GoogleSearchRetrieval tool type.
        #     Specialized retrieval tool that is powered by Google search.
        # @!attribute [rw] google_maps
        #   @return [::Google::Cloud::AIPlatform::V1::GoogleMaps]
        #     Optional. GoogleMaps tool type.
        #     Tool to support Google Maps in Model.
        # @!attribute [rw] enterprise_web_search
        #   @return [::Google::Cloud::AIPlatform::V1::EnterpriseWebSearch]
        #     Optional. Tool to support searching public web data, powered by Vertex AI
        #     Search and Sec4 compliance.
        # @!attribute [rw] code_execution
        #   @return [::Google::Cloud::AIPlatform::V1::Tool::CodeExecution]
        #     Optional. CodeExecution tool type.
        #     Enables the model to execute code as part of generation.
        # @!attribute [rw] url_context
        #   @return [::Google::Cloud::AIPlatform::V1::UrlContext]
        #     Optional. Tool to support URL context retrieval.
        # @!attribute [rw] computer_use
        #   @return [::Google::Cloud::AIPlatform::V1::Tool::ComputerUse]
        #     Optional. Tool to support the model interacting directly with the computer.
        #     If enabled, it automatically populates computer-use specific Function
        #     Declarations.
        class Tool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # GoogleSearch tool type.
          # Tool to support Google Search in Model. Powered by Google.
          # @!attribute [rw] exclude_domains
          #   @return [::Array<::String>]
          #     Optional. List of domains to be excluded from the search results.
          #     The default limit is 2000 domains.
          #     Example: ["amazon.com", "facebook.com"].
          # @!attribute [rw] blocking_confidence
          #   @return [::Google::Cloud::AIPlatform::V1::Tool::PhishBlockThreshold]
          #     Optional. Sites with confidence level chosen & above this value will be
          #     blocked from the search results.
          class GoogleSearch
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Tool that executes code generated by the model, and automatically returns
          # the result to the model.
          #
          # See also [ExecutableCode]and [CodeExecutionResult] which are input and
          # output to this tool.
          class CodeExecution
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Tool to support computer use.
          # @!attribute [rw] environment
          #   @return [::Google::Cloud::AIPlatform::V1::Tool::ComputerUse::Environment]
          #     Required. The environment being operated.
          # @!attribute [rw] excluded_predefined_functions
          #   @return [::Array<::String>]
          #     Optional. By default, [predefined
          #     functions](https://cloud.google.com/vertex-ai/generative-ai/docs/computer-use#supported-actions)
          #     are included in the final model call. Some of them can be explicitly
          #     excluded from being automatically included. This can serve two purposes:
          #     1. Using a more restricted / different action space.
          #     2. Improving the definitions / instructions of predefined functions.
          class ComputerUse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Represents the environment being operated, such as a web browser.
            module Environment
              # Defaults to browser.
              ENVIRONMENT_UNSPECIFIED = 0

              # Operates in a web browser.
              ENVIRONMENT_BROWSER = 1
            end
          end

          # These are available confidence level user can set to block malicious urls
          # with chosen confidence and above. For understanding different confidence of
          # webrisk, please refer to
          # https://cloud.google.com/web-risk/docs/reference/rpc/google.cloud.webrisk.v1eap1#confidencelevel
          module PhishBlockThreshold
            # Defaults to unspecified.
            PHISH_BLOCK_THRESHOLD_UNSPECIFIED = 0

            # Blocks Low and above confidence URL that is risky.
            BLOCK_LOW_AND_ABOVE = 30

            # Blocks Medium and above confidence URL that is risky.
            BLOCK_MEDIUM_AND_ABOVE = 40

            # Blocks High and above confidence URL that is risky.
            BLOCK_HIGH_AND_ABOVE = 50

            # Blocks Higher and above confidence URL that is risky.
            BLOCK_HIGHER_AND_ABOVE = 55

            # Blocks Very high and above confidence URL that is risky.
            BLOCK_VERY_HIGH_AND_ABOVE = 60

            # Blocks Extremely high confidence URL that is risky.
            BLOCK_ONLY_EXTREMELY_HIGH = 100
          end
        end

        # Tool to support URL context.
        class UrlContext
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Structured representation of a function declaration as defined by the
        # [OpenAPI 3.0 specification](https://spec.openapis.org/oas/v3.0.3). Included
        # in this declaration are the function name, description, parameters and
        # response type. This FunctionDeclaration is a representation of a block of
        # code that can be used as a `Tool` by the model and executed by the client.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function to call.
        #     Must start with a letter or an underscore.
        #     Must be a-z, A-Z, 0-9, or contain underscores, dots and dashes, with a
        #     maximum length of 64.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description and purpose of the function.
        #     Model uses it to decide how and whether to call the function.
        # @!attribute [rw] parameters
        #   @return [::Google::Cloud::AIPlatform::V1::Schema]
        #     Optional. Describes the parameters to this function in JSON Schema Object
        #     format. Reflects the Open API 3.03 Parameter Object. string Key: the name
        #     of the parameter. Parameter names are case sensitive. Schema Value: the
        #     Schema defining the type used for the parameter. For function with no
        #     parameters, this can be left unset. Parameter names must start with a
        #     letter or an underscore and must only contain chars a-z, A-Z, 0-9, or
        #     underscores with a maximum length of 64. Example with 1 required and 1
        #     optional parameter: type: OBJECT properties:
        #      param1:
        #        type: STRING
        #      param2:
        #        type: INTEGER
        #     required:
        #      - param1
        # @!attribute [rw] parameters_json_schema
        #   @return [::Google::Protobuf::Value]
        #     Optional. Describes the parameters to the function in JSON Schema format.
        #     The schema must describe an object where the properties are the parameters
        #     to the function. For example:
        #
        #     ```
        #     {
        #       "type": "object",
        #       "properties": {
        #         "name": { "type": "string" },
        #         "age": { "type": "integer" }
        #       },
        #       "additionalProperties": false,
        #       "required": ["name", "age"],
        #       "propertyOrdering": ["name", "age"]
        #     }
        #     ```
        #
        #     This field is mutually exclusive with `parameters`.
        # @!attribute [rw] response
        #   @return [::Google::Cloud::AIPlatform::V1::Schema]
        #     Optional. Describes the output from this function in JSON Schema format.
        #     Reflects the Open API 3.03 Response Object. The Schema defines the type
        #     used for the response value of the function.
        # @!attribute [rw] response_json_schema
        #   @return [::Google::Protobuf::Value]
        #     Optional. Describes the output from this function in JSON Schema format.
        #     The value specified by the schema is the response value of the function.
        #
        #     This field is mutually exclusive with `response`.
        class FunctionDeclaration
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A predicted [FunctionCall] returned from the model that contains a string
        # representing the [FunctionDeclaration.name] and a structured JSON object
        # containing the parameters and their values.
        # @!attribute [rw] name
        #   @return [::String]
        #     Optional. The name of the function to call.
        #     Matches [FunctionDeclaration.name].
        # @!attribute [rw] args
        #   @return [::Google::Protobuf::Struct]
        #     Optional. The function parameters and values in JSON object format.
        #     See [FunctionDeclaration.parameters] for parameter details.
        # @!attribute [rw] partial_args
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::PartialArg>]
        #     Optional. The partial argument value of the function call.
        #     If provided, represents the arguments/fields that are streamed
        #     incrementally.
        # @!attribute [rw] will_continue
        #   @return [::Boolean]
        #     Optional. Whether this is the last part of the FunctionCall.
        #     If true, another partial message for the current FunctionCall is expected
        #     to follow.
        class FunctionCall
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Partial argument value of the function call.
        # @!attribute [rw] null_value
        #   @return [::Google::Protobuf::NullValue]
        #     Optional. Represents a null value.
        #
        #     Note: The following fields are mutually exclusive: `null_value`, `number_value`, `string_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] number_value
        #   @return [::Float]
        #     Optional. Represents a double value.
        #
        #     Note: The following fields are mutually exclusive: `number_value`, `null_value`, `string_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     Optional. Represents a string value.
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `null_value`, `number_value`, `bool_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bool_value
        #   @return [::Boolean]
        #     Optional. Represents a boolean value.
        #
        #     Note: The following fields are mutually exclusive: `bool_value`, `null_value`, `number_value`, `string_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] json_path
        #   @return [::String]
        #     Required. A JSON Path (RFC 9535) to the argument being streamed.
        #     https://datatracker.ietf.org/doc/html/rfc9535. e.g. "$.foo.bar[0].data".
        # @!attribute [rw] will_continue
        #   @return [::Boolean]
        #     Optional. Whether this is not the last part of the same json_path.
        #     If true, another PartialArg message for the current json_path is expected
        #     to follow.
        class PartialArg
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A datatype containing media that is part of a `FunctionResponse` message.
        #
        # A `FunctionResponsePart` consists of data which has an associated datatype. A
        # `FunctionResponsePart` can only contain one of the accepted types in
        # `FunctionResponsePart.data`.
        #
        # A `FunctionResponsePart` must have a fixed IANA MIME type identifying the
        # type and subtype of the media if the `inline_data` field is filled with raw
        # bytes.
        # @!attribute [rw] inline_data
        #   @return [::Google::Cloud::AIPlatform::V1::FunctionResponseBlob]
        #     Inline media bytes.
        #
        #     Note: The following fields are mutually exclusive: `inline_data`, `file_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] file_data
        #   @return [::Google::Cloud::AIPlatform::V1::FunctionResponseFileData]
        #     URI based data.
        #
        #     Note: The following fields are mutually exclusive: `file_data`, `inline_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class FunctionResponsePart
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Raw media bytes for function response.
        #
        # Text should not be sent as raw bytes, use the 'text' field.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The IANA standard MIME type of the source data.
        # @!attribute [rw] data
        #   @return [::String]
        #     Required. Raw bytes.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Display name of the blob.
        #
        #     Used to provide a label or filename to distinguish blobs.
        #
        #     This field is only returned in PromptMessage for prompt management.
        #     It is currently used in the Gemini GenerateContent calls only when server
        #     side tools (code_execution, google_search, and url_context) are enabled.
        class FunctionResponseBlob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # URI based data for function response.
        # @!attribute [rw] mime_type
        #   @return [::String]
        #     Required. The IANA standard MIME type of the source data.
        # @!attribute [rw] file_uri
        #   @return [::String]
        #     Required. URI.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Display name of the file data.
        #
        #     Used to provide a label or filename to distinguish file datas.
        #
        #     This field is only returned in PromptMessage for prompt management.
        #     It is currently used in the Gemini GenerateContent calls only when server
        #     side tools (code_execution, google_search, and url_context) are enabled.
        class FunctionResponseFileData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The result output from a [FunctionCall] that contains a string representing
        # the [FunctionDeclaration.name] and a structured JSON object containing any
        # output from the function is used as context to the model. This should contain
        # the result of a [FunctionCall] made based on model prediction.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the function to call.
        #     Matches [FunctionDeclaration.name] and [FunctionCall.name].
        # @!attribute [rw] response
        #   @return [::Google::Protobuf::Struct]
        #     Required. The function response in JSON object format.
        #     Use "output" key to specify function output and "error" key to specify
        #     error details (if any). If "output" and "error" keys are not specified,
        #     then whole "response" is treated as function output.
        # @!attribute [rw] parts
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::FunctionResponsePart>]
        #     Optional. Ordered `Parts` that constitute a function response. Parts may
        #     have different IANA MIME types.
        class FunctionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Code generated by the model that is meant to be executed, and the result
        # returned to the model.
        #
        # Generated when using the [FunctionDeclaration] tool and
        # [FunctionCallingConfig] mode is set to [Mode.CODE].
        # @!attribute [rw] language
        #   @return [::Google::Cloud::AIPlatform::V1::ExecutableCode::Language]
        #     Required. Programming language of the `code`.
        # @!attribute [rw] code
        #   @return [::String]
        #     Required. The code to be executed.
        class ExecutableCode
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported programming languages for the generated code.
          module Language
            # Unspecified language. This value should not be used.
            LANGUAGE_UNSPECIFIED = 0

            # Python >= 3.10, with numpy and simpy available.
            PYTHON = 1
          end
        end

        # Result of executing the [ExecutableCode].
        #
        # Always follows a `part` containing the [ExecutableCode].
        # @!attribute [rw] outcome
        #   @return [::Google::Cloud::AIPlatform::V1::CodeExecutionResult::Outcome]
        #     Required. Outcome of the code execution.
        # @!attribute [rw] output
        #   @return [::String]
        #     Optional. Contains stdout when code execution is successful, stderr or
        #     other description otherwise.
        class CodeExecutionResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enumeration of possible outcomes of the code execution.
          module Outcome
            # Unspecified status. This value should not be used.
            OUTCOME_UNSPECIFIED = 0

            # Code execution completed successfully.
            OUTCOME_OK = 1

            # Code execution finished but with a failure. `stderr` should contain the
            # reason.
            OUTCOME_FAILED = 2

            # Code execution ran for too long, and was cancelled. There may or may not
            # be a partial output present.
            OUTCOME_DEADLINE_EXCEEDED = 3
          end
        end

        # Defines a retrieval tool that model can call to access external knowledge.
        # @!attribute [rw] vertex_ai_search
        #   @return [::Google::Cloud::AIPlatform::V1::VertexAISearch]
        #     Set to use data source powered by Vertex AI Search.
        #
        #     Note: The following fields are mutually exclusive: `vertex_ai_search`, `vertex_rag_store`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vertex_rag_store
        #   @return [::Google::Cloud::AIPlatform::V1::VertexRagStore]
        #     Set to use data source powered by Vertex RAG store.
        #     User data is uploaded via the VertexRagDataService.
        #
        #     Note: The following fields are mutually exclusive: `vertex_rag_store`, `vertex_ai_search`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disable_attribution
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Boolean]
        #     Optional. Deprecated. This option is no longer supported.
        class Retrieval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retrieve from Vertex RAG Store for grounding.
        # @!attribute [rw] rag_resources
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::VertexRagStore::RagResource>]
        #     Optional. The representation of the rag source. It can be used to specify
        #     corpus only or ragfiles. Currently only support one corpus or multiple
        #     files from one corpus. In the future we may open up multiple corpora
        #     support.
        # @!attribute [rw] similarity_top_k
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     Optional. Number of top k results to return from the selected corpora.
        # @!attribute [rw] vector_distance_threshold
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Float]
        #     Optional. Only return results with vector distance smaller than the
        #     threshold.
        # @!attribute [rw] rag_retrieval_config
        #   @return [::Google::Cloud::AIPlatform::V1::RagRetrievalConfig]
        #     Optional. The retrieval config for the Rag query.
        class VertexRagStore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The definition of the Rag resource.
          # @!attribute [rw] rag_corpus
          #   @return [::String]
          #     Optional. RagCorpora resource name.
          #     Format:
          #     `projects/{project}/locations/{location}/ragCorpora/{rag_corpus}`
          # @!attribute [rw] rag_file_ids
          #   @return [::Array<::String>]
          #     Optional. rag_file_id. The files should be in the same rag_corpus set in
          #     rag_corpus field.
          class RagResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Retrieve from Vertex AI Search datastore or engine for grounding.
        # datastore and engine are mutually exclusive.
        # See https://cloud.google.com/products/agent-builder
        # @!attribute [rw] datastore
        #   @return [::String]
        #     Optional. Fully-qualified Vertex AI Search data store resource ID.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
        # @!attribute [rw] engine
        #   @return [::String]
        #     Optional. Fully-qualified Vertex AI Search engine resource ID.
        #     Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
        # @!attribute [rw] max_results
        #   @return [::Integer]
        #     Optional. Number of search results to return per query.
        #     The default value is 10.
        #     The maximumm allowed value is 10.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter strings to be passed to the search API.
        # @!attribute [rw] data_store_specs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::VertexAISearch::DataStoreSpec>]
        #     Specifications that define the specific DataStores to be searched, along
        #     with configurations for those data stores. This is only considered for
        #     Engines with multiple data stores.
        #     It should only be set if engine is used.
        class VertexAISearch
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Define data stores within engine to filter on in a search call and
          # configurations for those data stores. For more information, see
          # https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#datastorespec
          # @!attribute [rw] data_store
          #   @return [::String]
          #     Full resource name of DataStore, such as
          #     Format:
          #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
          # @!attribute [rw] filter
          #   @return [::String]
          #     Optional. Filter specification to filter documents in the data store
          #     specified by data_store field. For more information on filtering, see
          #     [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
          class DataStoreSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Tool to retrieve public web data for grounding, powered by Google.
        # @!attribute [rw] dynamic_retrieval_config
        #   @return [::Google::Cloud::AIPlatform::V1::DynamicRetrievalConfig]
        #     Specifies the dynamic retrieval configuration for the given source.
        class GoogleSearchRetrieval
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tool to retrieve public maps data for grounding, powered by Google.
        # @!attribute [rw] enable_widget
        #   @return [::Boolean]
        #     If true, include the widget context token in the response.
        class GoogleMaps
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tool to search public web data, powered by Vertex AI Search and Sec4
        # compliance.
        # @!attribute [rw] exclude_domains
        #   @return [::Array<::String>]
        #     Optional. List of domains to be excluded from the search results.
        #     The default limit is 2000 domains.
        # @!attribute [rw] blocking_confidence
        #   @return [::Google::Cloud::AIPlatform::V1::Tool::PhishBlockThreshold]
        #     Optional. Sites with confidence level chosen & above this value will be
        #     blocked from the search results.
        class EnterpriseWebSearch
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Describes the options to customize dynamic retrieval.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::AIPlatform::V1::DynamicRetrievalConfig::Mode]
        #     The mode of the predictor to be used in dynamic retrieval.
        # @!attribute [rw] dynamic_threshold
        #   @return [::Float]
        #     Optional. The threshold to be used in dynamic retrieval.
        #     If not set, a system default value is used.
        class DynamicRetrievalConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The mode of the predictor to be used in dynamic retrieval.
          module Mode
            # Always trigger retrieval.
            MODE_UNSPECIFIED = 0

            # Run retrieval only when system decides it is necessary.
            MODE_DYNAMIC = 1
          end
        end

        # Tool config. This config is shared for all tools provided in the request.
        # @!attribute [rw] function_calling_config
        #   @return [::Google::Cloud::AIPlatform::V1::FunctionCallingConfig]
        #     Optional. Function calling config.
        # @!attribute [rw] retrieval_config
        #   @return [::Google::Cloud::AIPlatform::V1::RetrievalConfig]
        #     Optional. Retrieval config.
        class ToolConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Function calling config.
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::AIPlatform::V1::FunctionCallingConfig::Mode]
        #     Optional. Function calling mode.
        # @!attribute [rw] allowed_function_names
        #   @return [::Array<::String>]
        #     Optional. Function names to call. Only set when the Mode is ANY. Function
        #     names should match [FunctionDeclaration.name]. With mode set to ANY, model
        #     will predict a function call from the set of function names provided.
        # @!attribute [rw] stream_function_call_arguments
        #   @return [::Boolean]
        #     Optional. When set to true, arguments of a single function call will be
        #     streamed out in multiple parts/contents/responses. Partial parameter
        #     results will be returned in the [FunctionCall.partial_args] field.
        class FunctionCallingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Function calling mode.
          module Mode
            # Unspecified function calling mode. This value should not be used.
            MODE_UNSPECIFIED = 0

            # Default model behavior, model decides to predict either function calls
            # or natural language response.
            AUTO = 1

            # Model is constrained to always predicting function calls only.
            # If "allowed_function_names" are set, the predicted function calls will be
            # limited to any one of "allowed_function_names", else the predicted
            # function calls will be any one of the provided "function_declarations".
            ANY = 2

            # Model will not predict any function calls. Model behavior is same as when
            # not passing any function declarations.
            NONE = 3
          end
        end

        # Retrieval config.
        # @!attribute [rw] lat_lng
        #   @return [::Google::Type::LatLng]
        #     The location of the user.
        # @!attribute [rw] language_code
        #   @return [::String]
        #     The language code of the user.
        class RetrievalConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies the context retrieval config.
        # @!attribute [rw] top_k
        #   @return [::Integer]
        #     Optional. The number of contexts to retrieve.
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::AIPlatform::V1::RagRetrievalConfig::Filter]
        #     Optional. Config for filters.
        # @!attribute [rw] ranking
        #   @return [::Google::Cloud::AIPlatform::V1::RagRetrievalConfig::Ranking]
        #     Optional. Config for ranking and reranking.
        class RagRetrievalConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Config for filters.
          # @!attribute [rw] vector_distance_threshold
          #   @return [::Float]
          #     Optional. Only returns contexts with vector distance smaller than the
          #     threshold.
          #
          #     Note: The following fields are mutually exclusive: `vector_distance_threshold`, `vector_similarity_threshold`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] vector_similarity_threshold
          #   @return [::Float]
          #     Optional. Only returns contexts with vector similarity larger than the
          #     threshold.
          #
          #     Note: The following fields are mutually exclusive: `vector_similarity_threshold`, `vector_distance_threshold`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] metadata_filter
          #   @return [::String]
          #     Optional. String for metadata filtering.
          class Filter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Config for ranking and reranking.
          # @!attribute [rw] rank_service
          #   @return [::Google::Cloud::AIPlatform::V1::RagRetrievalConfig::Ranking::RankService]
          #     Optional. Config for Rank Service.
          #
          #     Note: The following fields are mutually exclusive: `rank_service`, `llm_ranker`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] llm_ranker
          #   @return [::Google::Cloud::AIPlatform::V1::RagRetrievalConfig::Ranking::LlmRanker]
          #     Optional. Config for LlmRanker.
          #
          #     Note: The following fields are mutually exclusive: `llm_ranker`, `rank_service`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Ranking
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Config for Rank Service.
            # @!attribute [rw] model_name
            #   @return [::String]
            #     Optional. The model name of the rank service.
            #     Format: `semantic-ranker-512@latest`
            class RankService
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Config for LlmRanker.
            # @!attribute [rw] model_name
            #   @return [::String]
            #     Optional. The model name used for ranking.
            #     Format: `gemini-1.5-pro`
            class LlmRanker
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
