# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # TensorboardTimeSeries maps to times series produced in training runs
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the TensorboardTimeSeries.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User provided name of this TensorboardTimeSeries.
        #     This value should be unique among all TensorboardTimeSeries resources
        #     belonging to the same TensorboardRun resource (parent resource).
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of this TensorboardTimeSeries.
        # @!attribute [rw] value_type
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries::ValueType]
        #     Required. Immutable. Type of TensorboardTimeSeries value.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this TensorboardTimeSeries was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this TensorboardTimeSeries was last updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Used to perform a consistent read-modify-write updates. If not set, a blind
        #     "overwrite" update happens.
        # @!attribute [rw] plugin_name
        #   @return [::String]
        #     Immutable. Name of the plugin this time series pertain to. Such as Scalar,
        #     Tensor, Blob
        # @!attribute [rw] plugin_data
        #   @return [::String]
        #     Data of the current plugin, with the size limited to 65KB.
        # @!attribute [r] metadata
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries::Metadata]
        #     Output only. Scalar, Tensor, or Blob metadata for this
        #     TensorboardTimeSeries.
        class TensorboardTimeSeries
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Describes metadata for a TensorboardTimeSeries.
          # @!attribute [r] max_step
          #   @return [::Integer]
          #     Output only. Max step index of all data points within a
          #     TensorboardTimeSeries.
          # @!attribute [r] max_wall_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. Max wall clock timestamp of all data points within a
          #     TensorboardTimeSeries.
          # @!attribute [r] max_blob_sequence_length
          #   @return [::Integer]
          #     Output only. The largest blob sequence length (number of blobs) of all
          #     data points in this time series, if its ValueType is BLOB_SEQUENCE.
          class Metadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An enum representing the value type of a TensorboardTimeSeries.
          module ValueType
            # The value type is unspecified.
            VALUE_TYPE_UNSPECIFIED = 0

            # Used for TensorboardTimeSeries that is a list of scalars.
            # E.g. accuracy of a model over epochs/time.
            SCALAR = 1

            # Used for TensorboardTimeSeries that is a list of tensors.
            # E.g. histograms of weights of layer in a model over epoch/time.
            TENSOR = 2

            # Used for TensorboardTimeSeries that is a list of blob sequences.
            # E.g. set of sample images with labels over epochs/time.
            BLOB_SEQUENCE = 3
          end
        end
      end
    end
  end
end
