# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#create_tensorboard TensorboardService.CreateTensorboard}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create the Tensorboard in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] tensorboard
        #   @return [::Google::Cloud::AIPlatform::V1::Tensorboard]
        #     Required. The Tensorboard to create.
        class CreateTensorboardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#get_tensorboard TensorboardService.GetTensorboard}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Tensorboard resource.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        class GetTensorboardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboards TensorboardService.ListTensorboards}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list Tensorboards.
        #     Format:
        #     `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the Tensorboards that match the filter expression.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of Tensorboards to return. The service may return
        #     fewer than this value. If unspecified, at most 100 Tensorboards are
        #     returned. The maximum value is 100; values above 100 are coerced to
        #     100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboards TensorboardService.ListTensorboards}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboards TensorboardService.ListTensorboards}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListTensorboardsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboards TensorboardService.ListTensorboards}.
        # @!attribute [rw] tensorboards
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Tensorboard>]
        #     The Tensorboards mathching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListTensorboardsRequest#page_token ListTensorboardsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListTensorboardsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#update_tensorboard TensorboardService.UpdateTensorboard}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     Tensorboard resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field is overwritten if it's in the mask. If the
        #     user does not provide a mask then all fields are overwritten if new
        #     values are specified.
        # @!attribute [rw] tensorboard
        #   @return [::Google::Cloud::AIPlatform::V1::Tensorboard]
        #     Required. The Tensorboard's `name` field is used to identify the
        #     Tensorboard to be updated. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        class UpdateTensorboardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#delete_tensorboard TensorboardService.DeleteTensorboard}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Tensorboard to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        class DeleteTensorboardRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_usage TensorboardService.ReadTensorboardUsage}.
        # @!attribute [rw] tensorboard
        #   @return [::String]
        #     Required. The name of the Tensorboard resource.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        class ReadTensorboardUsageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_usage TensorboardService.ReadTensorboardUsage}.
        # @!attribute [rw] monthly_usage_data
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse::PerMonthUsageData}]
        #     Maps year-month (YYYYMM) string to per month usage data.
        class ReadTensorboardUsageResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Per user usage data.
          # @!attribute [rw] username
          #   @return [::String]
          #     User's username
          # @!attribute [rw] view_count
          #   @return [::Integer]
          #     Number of times the user has read data within the Tensorboard.
          class PerUserUsageData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Per month usage data
          # @!attribute [rw] user_usage_data
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse::PerUserUsageData>]
          #     Usage data for each user in the given month.
          class PerMonthUsageData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::AIPlatform::V1::ReadTensorboardUsageResponse::PerMonthUsageData]
          class MonthlyUsageDataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_size TensorboardService.ReadTensorboardSize}.
        # @!attribute [rw] tensorboard
        #   @return [::String]
        #     Required. The name of the Tensorboard resource.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        class ReadTensorboardSizeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_size TensorboardService.ReadTensorboardSize}.
        # @!attribute [rw] storage_size_byte
        #   @return [::Integer]
        #     Payload storage size for the TensorBoard
        class ReadTensorboardSizeResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#create_tensorboard_experiment TensorboardService.CreateTensorboardExperiment}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Tensorboard to create the
        #     TensorboardExperiment in. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        # @!attribute [rw] tensorboard_experiment
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
        #     The TensorboardExperiment to create.
        # @!attribute [rw] tensorboard_experiment_id
        #   @return [::String]
        #     Required. The ID to use for the Tensorboard experiment, which becomes the
        #     final component of the Tensorboard experiment's resource name.
        #
        #     This value should be 1-128 characters, and valid characters
        #     are `/[a-z][0-9]-/`.
        class CreateTensorboardExperimentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#get_tensorboard_experiment TensorboardService.GetTensorboardExperiment}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TensorboardExperiment resource.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        class GetTensorboardExperimentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_experiments TensorboardService.ListTensorboardExperiments}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Tensorboard to list
        #     TensorboardExperiments. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the TensorboardExperiments that match the filter expression.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of TensorboardExperiments to return. The service may
        #     return fewer than this value. If unspecified, at most 50
        #     TensorboardExperiments are returned. The maximum value is 1000; values
        #     above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_experiments TensorboardService.ListTensorboardExperiments}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_experiments TensorboardService.ListTensorboardExperiments}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListTensorboardExperimentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_experiments TensorboardService.ListTensorboardExperiments}.
        # @!attribute [rw] tensorboard_experiments
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardExperiment>]
        #     The TensorboardExperiments mathching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListTensorboardExperimentsRequest#page_token ListTensorboardExperimentsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListTensorboardExperimentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#update_tensorboard_experiment TensorboardService.UpdateTensorboardExperiment}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     TensorboardExperiment resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field is overwritten if it's in the mask. If the
        #     user does not provide a mask then all fields are overwritten if new
        #     values are specified.
        # @!attribute [rw] tensorboard_experiment
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardExperiment]
        #     Required. The TensorboardExperiment's `name` field is used to identify the
        #     TensorboardExperiment to be updated. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        class UpdateTensorboardExperimentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#delete_tensorboard_experiment TensorboardService.DeleteTensorboardExperiment}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TensorboardExperiment to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        class DeleteTensorboardExperimentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#batch_create_tensorboard_runs TensorboardService.BatchCreateTensorboardRuns}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TensorboardExperiment to create the
        #     TensorboardRuns in. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        #     The parent field in the CreateTensorboardRunRequest messages must match
        #     this field.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::CreateTensorboardRunRequest>]
        #     Required. The request message specifying the TensorboardRuns to create.
        #     A maximum of 1000 TensorboardRuns can be created in a batch.
        class BatchCreateTensorboardRunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#batch_create_tensorboard_runs TensorboardService.BatchCreateTensorboardRuns}.
        # @!attribute [rw] tensorboard_runs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardRun>]
        #     The created TensorboardRuns.
        class BatchCreateTensorboardRunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#create_tensorboard_run TensorboardService.CreateTensorboardRun}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TensorboardExperiment to create the
        #     TensorboardRun in. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        # @!attribute [rw] tensorboard_run
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardRun]
        #     Required. The TensorboardRun to create.
        # @!attribute [rw] tensorboard_run_id
        #   @return [::String]
        #     Required. The ID to use for the Tensorboard run, which becomes the final
        #     component of the Tensorboard run's resource name.
        #
        #     This value should be 1-128 characters, and valid characters
        #     are `/[a-z][0-9]-/`.
        class CreateTensorboardRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#get_tensorboard_run TensorboardService.GetTensorboardRun}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TensorboardRun resource.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
        class GetTensorboardRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_blob_data TensorboardService.ReadTensorboardBlobData}.
        # @!attribute [rw] time_series
        #   @return [::String]
        #     Required. The resource name of the TensorboardTimeSeries to list Blobs.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        # @!attribute [rw] blob_ids
        #   @return [::Array<::String>]
        #     IDs of the blobs to read.
        class ReadTensorboardBlobDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_blob_data TensorboardService.ReadTensorboardBlobData}.
        # @!attribute [rw] blobs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardBlob>]
        #     Blob messages containing blob bytes.
        class ReadTensorboardBlobDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_runs TensorboardService.ListTensorboardRuns}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TensorboardExperiment to list
        #     TensorboardRuns. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the TensorboardRuns that match the filter expression.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of TensorboardRuns to return. The service may return
        #     fewer than this value. If unspecified, at most 50 TensorboardRuns are
        #     returned. The maximum value is 1000; values above 1000 are coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_runs TensorboardService.ListTensorboardRuns}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_runs TensorboardService.ListTensorboardRuns}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListTensorboardRunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_runs TensorboardService.ListTensorboardRuns}.
        # @!attribute [rw] tensorboard_runs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardRun>]
        #     The TensorboardRuns mathching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListTensorboardRunsRequest#page_token ListTensorboardRunsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListTensorboardRunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#update_tensorboard_run TensorboardService.UpdateTensorboardRun}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     TensorboardRun resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field is overwritten if it's in the mask. If the
        #     user does not provide a mask then all fields are overwritten if new
        #     values are specified.
        # @!attribute [rw] tensorboard_run
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardRun]
        #     Required. The TensorboardRun's `name` field is used to identify the
        #     TensorboardRun to be updated. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
        class UpdateTensorboardRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#delete_tensorboard_run TensorboardService.DeleteTensorboardRun}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TensorboardRun to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
        class DeleteTensorboardRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#batch_create_tensorboard_time_series TensorboardService.BatchCreateTensorboardTimeSeries}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TensorboardExperiment to create the
        #     TensorboardTimeSeries in.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        #     The TensorboardRuns referenced by the parent fields in the
        #     CreateTensorboardTimeSeriesRequest messages must be sub resources of this
        #     TensorboardExperiment.
        # @!attribute [rw] requests
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::CreateTensorboardTimeSeriesRequest>]
        #     Required. The request message specifying the TensorboardTimeSeries to
        #     create. A maximum of 1000 TensorboardTimeSeries can be created in a batch.
        class BatchCreateTensorboardTimeSeriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#batch_create_tensorboard_time_series TensorboardService.BatchCreateTensorboardTimeSeries}.
        # @!attribute [rw] tensorboard_time_series
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries>]
        #     The created TensorboardTimeSeries.
        class BatchCreateTensorboardTimeSeriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#create_tensorboard_time_series TensorboardService.CreateTensorboardTimeSeries}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TensorboardRun to create the
        #     TensorboardTimeSeries in.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
        # @!attribute [rw] tensorboard_time_series_id
        #   @return [::String]
        #     Optional. The user specified unique ID to use for the
        #     TensorboardTimeSeries, which becomes the final component of the
        #     TensorboardTimeSeries's resource name. This value should match
        #     "[a-z0-9][a-z0-9-]\\{0, 127}"
        # @!attribute [rw] tensorboard_time_series
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
        #     Required. The TensorboardTimeSeries to create.
        class CreateTensorboardTimeSeriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#get_tensorboard_time_series TensorboardService.GetTensorboardTimeSeries}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TensorboardTimeSeries resource.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        class GetTensorboardTimeSeriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_time_series TensorboardService.ListTensorboardTimeSeries}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the TensorboardRun to list
        #     TensorboardTimeSeries. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the TensorboardTimeSeries that match the filter expression.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of TensorboardTimeSeries to return. The service may
        #     return fewer than this value. If unspecified, at most 50
        #     TensorboardTimeSeries are returned. The maximum value is 1000; values
        #     above 1000 are coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_time_series TensorboardService.ListTensorboardTimeSeries}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_time_series TensorboardService.ListTensorboardTimeSeries}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the list.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask specifying which fields to read.
        class ListTensorboardTimeSeriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#list_tensorboard_time_series TensorboardService.ListTensorboardTimeSeries}.
        # @!attribute [rw] tensorboard_time_series
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries>]
        #     The TensorboardTimeSeries mathching the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ListTensorboardTimeSeriesRequest#page_token ListTensorboardTimeSeriesRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ListTensorboardTimeSeriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#update_tensorboard_time_series TensorboardService.UpdateTensorboardTimeSeries}.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten in the
        #     TensorboardTimeSeries resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field is overwritten if it's in the mask. If the
        #     user does not provide a mask then all fields are overwritten if new
        #     values are specified.
        # @!attribute [rw] tensorboard_time_series
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries]
        #     Required. The TensorboardTimeSeries' `name` field is used to identify the
        #     TensorboardTimeSeries to be updated.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        class UpdateTensorboardTimeSeriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#delete_tensorboard_time_series TensorboardService.DeleteTensorboardTimeSeries}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the TensorboardTimeSeries to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        class DeleteTensorboardTimeSeriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#batch_read_tensorboard_time_series_data TensorboardService.BatchReadTensorboardTimeSeriesData}.
        # @!attribute [rw] tensorboard
        #   @return [::String]
        #     Required. The resource name of the Tensorboard containing
        #     TensorboardTimeSeries to read data from. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
        #     The TensorboardTimeSeries referenced by
        #     {::Google::Cloud::AIPlatform::V1::BatchReadTensorboardTimeSeriesDataRequest#time_series time_series}
        #     must be sub resources of this Tensorboard.
        # @!attribute [rw] time_series
        #   @return [::Array<::String>]
        #     Required. The resource names of the TensorboardTimeSeries to read data
        #     from. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        class BatchReadTensorboardTimeSeriesDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#batch_read_tensorboard_time_series_data TensorboardService.BatchReadTensorboardTimeSeriesData}.
        # @!attribute [rw] time_series_data
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TimeSeriesData>]
        #     The returned time series data.
        class BatchReadTensorboardTimeSeriesDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_time_series_data TensorboardService.ReadTensorboardTimeSeriesData}.
        # @!attribute [rw] tensorboard_time_series
        #   @return [::String]
        #     Required. The resource name of the TensorboardTimeSeries to read data from.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        # @!attribute [rw] max_data_points
        #   @return [::Integer]
        #     The maximum number of TensorboardTimeSeries' data to return.
        #
        #     This value should be a positive integer.
        #     This value can be set to -1 to return all data.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Reads the TensorboardTimeSeries' data that match the filter expression.
        class ReadTensorboardTimeSeriesDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#read_tensorboard_time_series_data TensorboardService.ReadTensorboardTimeSeriesData}.
        # @!attribute [rw] time_series_data
        #   @return [::Google::Cloud::AIPlatform::V1::TimeSeriesData]
        #     The returned time series data.
        class ReadTensorboardTimeSeriesDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#write_tensorboard_experiment_data TensorboardService.WriteTensorboardExperimentData}.
        # @!attribute [rw] tensorboard_experiment
        #   @return [::String]
        #     Required. The resource name of the TensorboardExperiment to write data to.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        # @!attribute [rw] write_run_data_requests
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::WriteTensorboardRunDataRequest>]
        #     Required. Requests containing per-run TensorboardTimeSeries data to write.
        class WriteTensorboardExperimentDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#write_tensorboard_experiment_data TensorboardService.WriteTensorboardExperimentData}.
        class WriteTensorboardExperimentDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#write_tensorboard_run_data TensorboardService.WriteTensorboardRunData}.
        # @!attribute [rw] tensorboard_run
        #   @return [::String]
        #     Required. The resource name of the TensorboardRun to write data to.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
        # @!attribute [rw] time_series_data
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TimeSeriesData>]
        #     Required. The TensorboardTimeSeries data to write.
        #     Values with in a time series are indexed by their step value.
        #     Repeated writes to the same step will overwrite the existing value for that
        #     step.
        #     The upper limit of data points per write request is 5000.
        class WriteTensorboardRunDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#write_tensorboard_run_data TensorboardService.WriteTensorboardRunData}.
        class WriteTensorboardRunDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#export_tensorboard_time_series_data TensorboardService.ExportTensorboardTimeSeriesData}.
        # @!attribute [rw] tensorboard_time_series
        #   @return [::String]
        #     Required. The resource name of the TensorboardTimeSeries to export data
        #     from. Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Exports the TensorboardTimeSeries' data that match the filter expression.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of data points to return per page.
        #     The default page_size is 1000. Values must be between 1 and 10000.
        #     Values above 10000 are coerced to 10000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#export_tensorboard_time_series_data ExportTensorboardTimeSeriesData}
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to
        #     {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#export_tensorboard_time_series_data ExportTensorboardTimeSeriesData}
        #     must match the call that provided the page token.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to use to sort the TensorboardTimeSeries' data.
        #     By default, TensorboardTimeSeries' data is returned in a pseudo random
        #     order.
        class ExportTensorboardTimeSeriesDataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::TensorboardService::Client#export_tensorboard_time_series_data TensorboardService.ExportTensorboardTimeSeriesData}.
        # @!attribute [rw] time_series_data_points
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TimeSeriesDataPoint>]
        #     The returned time series data points.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::AIPlatform::V1::ExportTensorboardTimeSeriesDataRequest#page_token page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        class ExportTensorboardTimeSeriesDataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform create Tensorboard.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Tensorboard.
        class CreateTensorboardOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of operations that perform update Tensorboard.
        # @!attribute [rw] generic_metadata
        #   @return [::Google::Cloud::AIPlatform::V1::GenericOperationMetadata]
        #     Operation metadata for Tensorboard.
        class UpdateTensorboardOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
