# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A TensorboardExperiment is a group of TensorboardRuns, that are typically the
        # results of a training job run, in a Tensorboard.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the TensorboardExperiment.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     User provided name of this TensorboardExperiment.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of this TensorboardExperiment.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this TensorboardExperiment was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this TensorboardExperiment was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to organize your
        #     TensorboardExperiment.
        #
        #     Label keys and values cannot be longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     No more than 64 user labels can be associated with one Dataset (System
        #     labels are excluded).
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        #     System reserved label keys are prefixed with `aiplatform.googleapis.com/`
        #     and are immutable. The following system labels exist for each Dataset:
        #
        #     * `aiplatform.googleapis.com/dataset_metadata_schema`: output only. Its
        #        value is the
        #        [metadata_schema's][google.cloud.aiplatform.v1.Dataset.metadata_schema_uri]
        #        title.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Used to perform consistent read-modify-write updates. If not set, a blind
        #     "overwrite" update happens.
        # @!attribute [rw] source
        #   @return [::String]
        #     Immutable. Source of the TensorboardExperiment. Example: a custom training
        #     job.
        class TensorboardExperiment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
