# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # All the data stored in a TensorboardTimeSeries.
        # @!attribute [rw] tensorboard_time_series_id
        #   @return [::String]
        #     Required. The ID of the TensorboardTimeSeries, which will become the final
        #     component of the TensorboardTimeSeries' resource name
        # @!attribute [rw] value_type
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardTimeSeries::ValueType]
        #     Required. Immutable. The value type of this time series. All the values in
        #     this time series data must match this value type.
        # @!attribute [rw] values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TimeSeriesDataPoint>]
        #     Required. Data points in this time series.
        class TimeSeriesData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A TensorboardTimeSeries data point.
        # @!attribute [rw] scalar
        #   @return [::Google::Cloud::AIPlatform::V1::Scalar]
        #     A scalar value.
        #
        #     Note: The following fields are mutually exclusive: `scalar`, `tensor`, `blobs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tensor
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardTensor]
        #     A tensor value.
        #
        #     Note: The following fields are mutually exclusive: `tensor`, `scalar`, `blobs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] blobs
        #   @return [::Google::Cloud::AIPlatform::V1::TensorboardBlobSequence]
        #     A blob sequence value.
        #
        #     Note: The following fields are mutually exclusive: `blobs`, `scalar`, `tensor`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] wall_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Wall clock timestamp when this data point is generated by the end user.
        # @!attribute [rw] step
        #   @return [::Integer]
        #     Step index of this data point within the run.
        class TimeSeriesDataPoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # One point viewable on a scalar metric plot.
        # @!attribute [rw] value
        #   @return [::Float]
        #     Value of the point at this step / timestamp.
        class Scalar
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # One point viewable on a tensor metric plot.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. Serialized form of
        #     https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/framework/tensor.proto
        # @!attribute [rw] version_number
        #   @return [::Integer]
        #     Optional. Version number of TensorProto used to serialize
        #     {::Google::Cloud::AIPlatform::V1::TensorboardTensor#value value}.
        class TensorboardTensor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # One point viewable on a blob metric plot, but mostly just a wrapper message
        # to work around repeated fields can't be used directly within `oneof` fields.
        # @!attribute [rw] values
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::TensorboardBlob>]
        #     List of blobs contained within the sequence.
        class TensorboardBlobSequence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # One blob (e.g, image, graph) viewable on a blob metric plot.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. A URI safe key uniquely identifying a blob. Can be used to
        #     locate the blob stored in the Cloud Storage bucket of the consumer project.
        # @!attribute [rw] data
        #   @return [::String]
        #     Optional. The bytes of the blob is not present unless it's returned by the
        #     ReadTensorboardBlobData endpoint.
        class TensorboardBlob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
