# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Tensorboard is a physical database that stores users' training metrics.
        # A default Tensorboard is provided in each region of a Google Cloud project.
        # If needed users can also create extra Tensorboards in their projects.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the Tensorboard.
        #     Format:
        #     `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User provided name of this Tensorboard.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of this Tensorboard.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key spec for a Tensorboard. If set, this
        #     Tensorboard and all sub-resources of this Tensorboard will be secured by
        #     this key.
        # @!attribute [r] blob_storage_path_prefix
        #   @return [::String]
        #     Output only. Consumer project Cloud Storage path prefix used to store blob
        #     data, which can either be a bucket or directory. Does not end with a '/'.
        # @!attribute [r] run_count
        #   @return [::Integer]
        #     Output only. The number of Runs stored in this Tensorboard.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Tensorboard was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Tensorboard was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels with user-defined metadata to organize your Tensorboards.
        #
        #     Label keys and values can be no longer than 64 characters
        #     (Unicode codepoints), can only contain lowercase letters, numeric
        #     characters, underscores and dashes. International characters are allowed.
        #     No more than 64 user labels can be associated with one Tensorboard
        #     (System labels are excluded).
        #
        #     See https://goo.gl/xmQnxf for more information and examples of labels.
        #     System reserved label keys are prefixed with "aiplatform.googleapis.com/"
        #     and are immutable.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Used to perform a consistent read-modify-write updates. If not set, a blind
        #     "overwrite" update happens.
        # @!attribute [rw] is_default
        #   @return [::Boolean]
        #     Used to indicate if the TensorBoard instance is the default one.
        #     Each project & region can have at most one default TensorBoard instance.
        #     Creation of a default TensorBoard instance and updating an existing
        #     TensorBoard instance to be default will mark all other TensorBoard
        #     instances (if any) as non default.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        class Tensorboard
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
