# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # SpecialistPool represents customers' own workforce to work on their data
        # labeling jobs. It includes a group of specialist managers and workers.
        # Managers are responsible for managing the workers in this pool as well as
        # customers' data labeling jobs associated with this pool. Customers create
        # specialist pool as well as start data labeling jobs on Cloud, managers and
        # workers handle the jobs using CrowdCompute console.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the SpecialistPool.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The user-defined name of the SpecialistPool.
        #     The name can be up to 128 characters long and can consist of any UTF-8
        #     characters.
        #     This field should be unique on project-level.
        # @!attribute [r] specialist_managers_count
        #   @return [::Integer]
        #     Output only. The number of managers in this SpecialistPool.
        # @!attribute [rw] specialist_manager_emails
        #   @return [::Array<::String>]
        #     The email addresses of the managers in the SpecialistPool.
        # @!attribute [r] pending_data_labeling_jobs
        #   @return [::Array<::String>]
        #     Output only. The resource name of the pending data labeling jobs.
        # @!attribute [rw] specialist_worker_emails
        #   @return [::Array<::String>]
        #     The email addresses of workers in the SpecialistPool.
        class SpecialistPool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
