# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # PSC config that is used to automatically create PSC endpoints in the user
        # projects.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. Project id used to create forwarding rule.
        # @!attribute [rw] network
        #   @return [::String]
        #     Required. The full name of the Google Compute Engine
        #     [network](https://cloud.google.com/compute/docs/networks-and-firewalls#networks).
        #     [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/get):
        #     `projects/{project}/global/networks/{network}`.
        # @!attribute [r] ip_address
        #   @return [::String]
        #     Output only. IP address rule created by the PSC service automation.
        # @!attribute [r] forwarding_rule
        #   @return [::String]
        #     Output only. Forwarding rule created by the PSC service automation.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AIPlatform::V1::PSCAutomationState]
        #     Output only. The state of the PSC service automation.
        # @!attribute [r] error_message
        #   @return [::String]
        #     Output only. Error message if the PSC service automation failed.
        class PSCAutomationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents configuration for private service connect.
        # @!attribute [rw] enable_private_service_connect
        #   @return [::Boolean]
        #     Required. If true, expose the IndexEndpoint via private service connect.
        # @!attribute [rw] project_allowlist
        #   @return [::Array<::String>]
        #     A list of Projects from which the forwarding rule will target the service
        #     attachment.
        # @!attribute [rw] psc_automation_configs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::PSCAutomationConfig>]
        #     Optional. List of projects and networks where the PSC endpoints will be
        #     created. This field is used by Online Inference(Prediction) only.
        # @!attribute [r] service_attachment
        #   @return [::String]
        #     Output only. The name of the generated service attachment resource.
        #     This is only populated if the endpoint is deployed with
        #     PrivateServiceConnect.
        class PrivateServiceConnectConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PscAutomatedEndpoints defines the output of the forwarding rule
        # automatically created by each PscAutomationConfig.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Corresponding project_id in pscAutomationConfigs
        # @!attribute [rw] network
        #   @return [::String]
        #     Corresponding network in pscAutomationConfigs.
        # @!attribute [rw] match_address
        #   @return [::String]
        #     Ip Address created by the automated forwarding rule.
        class PscAutomatedEndpoints
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for PSC-I.
        # @!attribute [rw] network_attachment
        #   @return [::String]
        #     Optional. The name of the Compute Engine
        #     [network
        #     attachment](https://cloud.google.com/vpc/docs/about-network-attachments) to
        #     attach to the resource within the region and user project.
        #     To specify this field, you must have already [created a network attachment]
        #     (https://cloud.google.com/vpc/docs/create-manage-network-attachments#create-network-attachments).
        #     This field is only used for resources using PSC-I.
        # @!attribute [rw] dns_peering_configs
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::DnsPeeringConfig>]
        #     Optional. DNS peering configurations. When specified, Vertex AI will
        #     attempt to configure DNS peering zones in the tenant project VPC
        #     to resolve the specified domains using the target network's Cloud DNS.
        #     The user must grant the dns.peer role to the Vertex AI Service Agent
        #     on the target project.
        class PscInterfaceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DNS peering configuration. These configurations are used to create
        # DNS peering zones in the Vertex tenant project VPC, enabling resolution
        # of records within the specified domain hosted in the target network's
        # Cloud DNS.
        # @!attribute [rw] domain
        #   @return [::String]
        #     Required. The DNS name suffix of the zone being peered to, e.g.,
        #     "my-internal-domain.corp.". Must end with a dot.
        # @!attribute [rw] target_project
        #   @return [::String]
        #     Required. The project ID hosting the Cloud DNS managed zone that
        #     contains the 'domain'. The Vertex AI Service Agent requires the
        #     dns.peer role on this project.
        # @!attribute [rw] target_network
        #   @return [::String]
        #     Required. The VPC network name
        #     in the target_project where the DNS zone specified by 'domain' is
        #     visible.
        class DnsPeeringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The state of the PSC service automation.
        module PSCAutomationState
          # Should not be used.
          PSC_AUTOMATION_STATE_UNSPECIFIED = 0

          # The PSC service automation is successful.
          PSC_AUTOMATION_STATE_SUCCESSFUL = 1

          # The PSC service automation has failed.
          PSC_AUTOMATION_STATE_FAILED = 2
        end
      end
    end
  end
end
