# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module Schema
          module TrainingJob
            module Definition
              # A TrainingJob that trains and uploads an AutoML Image Segmentation Model.
              # @!attribute [rw] inputs
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageSegmentationInputs]
              #     The input parameters of this TrainingJob.
              # @!attribute [rw] metadata
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageSegmentationMetadata]
              #     The metadata information.
              class AutoMlImageSegmentation
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # @!attribute [rw] model_type
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageSegmentationInputs::ModelType]
              # @!attribute [rw] budget_milli_node_hours
              #   @return [::Integer]
              #     The training budget of creating this model, expressed in milli node
              #     hours i.e. 1,000 value in this field means 1 node hour. The actual
              #     metadata.costMilliNodeHours will be equal or less than this value.
              #     If further model training ceases to provide any improvements, it will
              #     stop without using the full budget and the metadata.successfulStopReason
              #     will be `model-converged`.
              #     Note, node_hour  = actual_hour * number_of_nodes_involved. Or
              #     actaul_wall_clock_hours = train_budget_milli_node_hours /
              #                               (number_of_nodes_involved * 1000)
              #     For modelType `cloud-high-accuracy-1`(default), the budget must be between
              #     20,000 and 2,000,000 milli node hours, inclusive. The default value is
              #     192,000 which represents one day in wall time
              #     (1000 milli * 24 hours * 8 nodes).
              # @!attribute [rw] base_model_id
              #   @return [::String]
              #     The ID of the `base` model. If it is specified, the new model will be
              #     trained based on the `base` model. Otherwise, the new model will be
              #     trained from scratch. The `base` model must be in the same
              #     Project and Location as the new Model to train, and have the same
              #     modelType.
              class AutoMlImageSegmentationInputs
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                module ModelType
                  # Should not be set.
                  MODEL_TYPE_UNSPECIFIED = 0

                  # A model to be used via prediction calls to uCAIP API. Expected
                  # to have a higher latency, but should also have a higher prediction
                  # quality than other models.
                  CLOUD_HIGH_ACCURACY_1 = 1

                  # A model to be used via prediction calls to uCAIP API. Expected
                  # to have a lower latency but relatively lower prediction quality.
                  CLOUD_LOW_ACCURACY_1 = 2

                  # A model that, in addition to being available within Google
                  # Cloud, can also be exported (see ModelService.ExportModel) as TensorFlow
                  # model and used on a mobile or edge device afterwards.
                  # Expected to have low latency, but may have lower prediction
                  # quality than other mobile models.
                  MOBILE_TF_LOW_LATENCY_1 = 3
                end
              end

              # @!attribute [rw] cost_milli_node_hours
              #   @return [::Integer]
              #     The actual training cost of creating this model, expressed in
              #     milli node hours, i.e. 1,000 value in this field means 1 node hour.
              #     Guaranteed to not exceed inputs.budgetMilliNodeHours.
              # @!attribute [rw] successful_stop_reason
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageSegmentationMetadata::SuccessfulStopReason]
              #     For successful job completions, this is the reason why the job has
              #     finished.
              class AutoMlImageSegmentationMetadata
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                module SuccessfulStopReason
                  # Should not be set.
                  SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0

                  # The inputs.budgetMilliNodeHours had been reached.
                  BUDGET_REACHED = 1

                  # Further training of the Model ceased to increase its quality, since it
                  # already has converged.
                  MODEL_CONVERGED = 2
                end
              end
            end
          end
        end
      end
    end
  end
end
