# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module Schema
          module TrainingJob
            module Definition
              # A TrainingJob that trains and uploads an AutoML Image Object Detection Model.
              # @!attribute [rw] inputs
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageObjectDetectionInputs]
              #     The input parameters of this TrainingJob.
              # @!attribute [rw] metadata
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageObjectDetectionMetadata]
              #     The metadata information
              class AutoMlImageObjectDetection
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end

              # @!attribute [rw] model_type
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageObjectDetectionInputs::ModelType]
              # @!attribute [rw] budget_milli_node_hours
              #   @return [::Integer]
              #     The training budget of creating this model, expressed in milli node
              #     hours i.e. 1,000 value in this field means 1 node hour. The actual
              #     metadata.costMilliNodeHours will be equal or less than this value.
              #     If further model training ceases to provide any improvements, it will
              #     stop without using the full budget and the metadata.successfulStopReason
              #     will be `model-converged`.
              #     Note, node_hour  = actual_hour * number_of_nodes_involved.
              #     For modelType `cloud`(default), the budget must be between 20,000
              #     and 900,000 milli node hours, inclusive. The default value is 216,000
              #     which represents one day in wall time, considering 9 nodes are used.
              #     For model types `mobile-tf-low-latency-1`, `mobile-tf-versatile-1`,
              #     `mobile-tf-high-accuracy-1`
              #     the training budget must be between 1,000 and 100,000 milli node hours,
              #     inclusive. The default value is 24,000 which represents one day in
              #     wall time on a single node that is used.
              # @!attribute [rw] disable_early_stopping
              #   @return [::Boolean]
              #     Use the entire training budget. This disables the early stopping feature.
              #     When false the early stopping feature is enabled, which means that AutoML
              #     Image Object Detection might stop training before the entire training
              #     budget has been used.
              class AutoMlImageObjectDetectionInputs
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                module ModelType
                  # Should not be set.
                  MODEL_TYPE_UNSPECIFIED = 0

                  # A model best tailored to be used within Google Cloud, and which cannot
                  # be exported. Expected to have a higher latency, but should also have a
                  # higher prediction quality than other cloud models.
                  CLOUD_HIGH_ACCURACY_1 = 1

                  # A model best tailored to be used within Google Cloud, and which cannot
                  # be exported. Expected to have a low latency, but may have lower
                  # prediction quality than other cloud models.
                  CLOUD_LOW_LATENCY_1 = 2

                  # A model that, in addition to being available within Google
                  # Cloud can also be exported (see ModelService.ExportModel) and
                  # used on a mobile or edge device with TensorFlow afterwards.
                  # Expected to have low latency, but may have lower prediction
                  # quality than other mobile models.
                  MOBILE_TF_LOW_LATENCY_1 = 3

                  # A model that, in addition to being available within Google
                  # Cloud can also be exported (see ModelService.ExportModel) and
                  # used on a mobile or edge device with TensorFlow afterwards.
                  MOBILE_TF_VERSATILE_1 = 4

                  # A model that, in addition to being available within Google
                  # Cloud, can also be exported (see ModelService.ExportModel) and
                  # used on a mobile or edge device with TensorFlow afterwards.
                  # Expected to have a higher latency, but should also have a higher
                  # prediction quality than other mobile models.
                  MOBILE_TF_HIGH_ACCURACY_1 = 5
                end
              end

              # @!attribute [rw] cost_milli_node_hours
              #   @return [::Integer]
              #     The actual training cost of creating this model, expressed in
              #     milli node hours, i.e. 1,000 value in this field means 1 node hour.
              #     Guaranteed to not exceed inputs.budgetMilliNodeHours.
              # @!attribute [rw] successful_stop_reason
              #   @return [::Google::Cloud::AIPlatform::V1::Schema::TrainingJob::Definition::AutoMlImageObjectDetectionMetadata::SuccessfulStopReason]
              #     For successful job completions, this is the reason why the job has
              #     finished.
              class AutoMlImageObjectDetectionMetadata
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                module SuccessfulStopReason
                  # Should not be set.
                  SUCCESSFUL_STOP_REASON_UNSPECIFIED = 0

                  # The inputs.budgetMilliNodeHours had been reached.
                  BUDGET_REACHED = 1

                  # Further training of the Model ceased to increase its quality, since it
                  # already has converged.
                  MODEL_CONVERGED = 2
                end
              end
            end
          end
        end
      end
    end
  end
end
