# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module Schema
          module Predict
            module Prediction
              # Prediction output format for Video Object Tracking.
              # @!attribute [rw] id
              #   @return [::String]
              #     The resource ID of the AnnotationSpec that had been identified.
              # @!attribute [rw] display_name
              #   @return [::String]
              #     The display name of the AnnotationSpec that had been identified.
              # @!attribute [rw] time_segment_start
              #   @return [::Google::Protobuf::Duration]
              #     The beginning, inclusive, of the video's time segment in which the
              #     object instance has been detected. Expressed as a number of seconds as
              #     measured from the start of the video, with fractions up to a microsecond
              #     precision, and with "s" appended at the end.
              # @!attribute [rw] time_segment_end
              #   @return [::Google::Protobuf::Duration]
              #     The end, inclusive, of the video's time segment in which the
              #     object instance has been detected. Expressed as a number of seconds as
              #     measured from the start of the video, with fractions up to a microsecond
              #     precision, and with "s" appended at the end.
              # @!attribute [rw] confidence
              #   @return [::Google::Protobuf::FloatValue]
              #     The Model's confidence in correction of this prediction, higher
              #     value means higher confidence.
              # @!attribute [rw] frames
              #   @return [::Array<::Google::Cloud::AIPlatform::V1::Schema::Predict::Prediction::VideoObjectTrackingPredictionResult::Frame>]
              #     All of the frames of the video in which a single object instance has been
              #     detected. The bounding boxes in the frames identify the same object.
              class VideoObjectTrackingPredictionResult
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # The fields `xMin`, `xMax`, `yMin`, and `yMax` refer to a bounding box,
                # i.e. the rectangle over the video frame pinpointing the found
                # AnnotationSpec. The coordinates are relative to the frame size, and the
                # point 0,0 is in the top left of the frame.
                # @!attribute [rw] time_offset
                #   @return [::Google::Protobuf::Duration]
                #     A time (frame) of a video in which the object has been detected.
                #     Expressed as a number of seconds as measured from the
                #     start of the video, with fractions up to a microsecond precision, and
                #     with "s" appended at the end.
                # @!attribute [rw] x_min
                #   @return [::Google::Protobuf::FloatValue]
                #     The leftmost coordinate of the bounding box.
                # @!attribute [rw] x_max
                #   @return [::Google::Protobuf::FloatValue]
                #     The rightmost coordinate of the bounding box.
                # @!attribute [rw] y_min
                #   @return [::Google::Protobuf::FloatValue]
                #     The topmost coordinate of the bounding box.
                # @!attribute [rw] y_max
                #   @return [::Google::Protobuf::FloatValue]
                #     The bottommost coordinate of the bounding box.
                class Frame
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end
              end
            end
          end
        end
      end
    end
  end
end
