# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module Schema
          module Predict
            module Prediction
              # Prediction output format for Video Classification.
              # @!attribute [rw] id
              #   @return [::String]
              #     The resource ID of the AnnotationSpec that had been identified.
              # @!attribute [rw] display_name
              #   @return [::String]
              #     The display name of the AnnotationSpec that had been identified.
              # @!attribute [rw] type
              #   @return [::String]
              #     The type of the prediction. The requested types can be configured
              #     via parameters. This will be one of
              #     - segment-classification
              #     - shot-classification
              #     - one-sec-interval-classification
              # @!attribute [rw] time_segment_start
              #   @return [::Google::Protobuf::Duration]
              #     The beginning, inclusive, of the video's time segment in which the
              #     AnnotationSpec has been identified. Expressed as a number of seconds as
              #     measured from the start of the video, with fractions up to a microsecond
              #     precision, and with "s" appended at the end. Note that for
              #     'segment-classification' prediction type, this equals the original
              #     'timeSegmentStart' from the input instance, for other types it is the
              #     start of a shot or a 1 second interval respectively.
              # @!attribute [rw] time_segment_end
              #   @return [::Google::Protobuf::Duration]
              #     The end, exclusive, of the video's time segment in which the
              #     AnnotationSpec has been identified. Expressed as a number of seconds as
              #     measured from the start of the video, with fractions up to a microsecond
              #     precision, and with "s" appended at the end. Note that for
              #     'segment-classification' prediction type, this equals the original
              #     'timeSegmentEnd' from the input instance, for other types it is the end
              #     of a shot or a 1 second interval respectively.
              # @!attribute [rw] confidence
              #   @return [::Google::Protobuf::FloatValue]
              #     The Model's confidence in correction of this prediction, higher
              #     value means higher confidence.
              class VideoClassificationPredictionResult
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end
        end
      end
    end
  end
end
