# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module Schema
          module Predict
            module Prediction
              # Prediction output format for Image Object Detection.
              # @!attribute [rw] ids
              #   @return [::Array<::Integer>]
              #     The resource IDs of the AnnotationSpecs that had been identified, ordered
              #     by the confidence score descendingly.
              # @!attribute [rw] display_names
              #   @return [::Array<::String>]
              #     The display names of the AnnotationSpecs that had been identified, order
              #     matches the IDs.
              # @!attribute [rw] confidences
              #   @return [::Array<::Float>]
              #     The Model's confidences in correctness of the predicted IDs, higher value
              #     means higher confidence. Order matches the Ids.
              # @!attribute [rw] bboxes
              #   @return [::Array<::Google::Protobuf::ListValue>]
              #     Bounding boxes, i.e. the rectangles over the image, that pinpoint
              #     the found AnnotationSpecs. Given in order that matches the IDs. Each
              #     bounding box is an array of 4 numbers `xMin`, `xMax`, `yMin`, and
              #     `yMax`, which represent the extremal coordinates of the box. They are
              #     relative to the image size, and the point 0,0 is in the top left
              #     of the image.
              class ImageObjectDetectionPredictionResult
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end
        end
      end
    end
  end
end
