# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        module Schema
          module Predict
            module Params
              # Prediction model parameters for Video Classification.
              # @!attribute [rw] confidence_threshold
              #   @return [::Float]
              #     The Model only returns predictions with at least this confidence score.
              #     Default value is 0.0
              # @!attribute [rw] max_predictions
              #   @return [::Integer]
              #     The Model only returns up to that many top, by confidence score,
              #     predictions per instance. If this number is very high, the Model may return
              #     fewer predictions. Default value is 10,000.
              # @!attribute [rw] segment_classification
              #   @return [::Boolean]
              #     Set to true to request segment-level classification. Vertex AI returns
              #     labels and their confidence scores for the entire time segment of the
              #     video that user specified in the input instance.
              #     Default value is true
              # @!attribute [rw] shot_classification
              #   @return [::Boolean]
              #     Set to true to request shot-level classification. Vertex AI determines
              #     the boundaries for each camera shot in the entire time segment of the
              #     video that user specified in the input instance. Vertex AI then
              #     returns labels and their confidence scores for each detected shot, along
              #     with the start and end time of the shot.
              #     WARNING: Model evaluation is not done for this classification type,
              #     the quality of it depends on the training data, but there are no metrics
              #     provided to describe that quality.
              #     Default value is false
              # @!attribute [rw] one_sec_interval_classification
              #   @return [::Boolean]
              #     Set to true to request classification for a video at one-second intervals.
              #     Vertex AI returns labels and their confidence scores for each second of
              #     the entire time segment of the video that user specified in the input
              #     WARNING: Model evaluation is not done for this classification type, the
              #     quality of it depends on the training data, but there are no metrics
              #     provided to describe that quality. Default value is false
              class VideoClassificationPredictionParams
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end
        end
      end
    end
  end
end
