# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#create_schedule ScheduleService.CreateSchedule}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to create the Schedule in.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] schedule
        #   @return [::Google::Cloud::AIPlatform::V1::Schedule]
        #     Required. The Schedule to create.
        class CreateScheduleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#get_schedule ScheduleService.GetSchedule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Schedule resource.
        #     Format:
        #     `projects/{project}/locations/{location}/schedules/{schedule}`
        class GetScheduleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#list_schedules ScheduleService.ListSchedules}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location to list the Schedules from.
        #     Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] filter
        #   @return [::String]
        #     Lists the Schedules that match the filter expression. The following
        #     fields are supported:
        #
        #     * `display_name`: Supports `=`, `!=` comparisons, and `:` wildcard.
        #     * `state`: Supports `=` and `!=` comparisons.
        #     * `request`: Supports existence of the <request_type> check.
        #           (e.g. `create_pipeline_job_request:*` --> Schedule has
        #           create_pipeline_job_request).
        #     * `create_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #           Values must be in RFC 3339 format.
        #     * `start_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=` comparisons.
        #           Values must be in RFC 3339 format.
        #     * `end_time`: Supports `=`, `!=`, `<`, `>`, `<=`, `>=` comparisons and `:*`
        #           existence check. Values must be in RFC 3339 format.
        #     * `next_run_time`: Supports `=`, `!=`, `<`, `>`, `<=`, and `>=`
        #           comparisons. Values must be in RFC 3339 format.
        #
        #
        #     Filter expressions can be combined together using logical operators
        #     (`NOT`, `AND` & `OR`).
        #     The syntax to define filter expression is based on
        #     https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * `state="ACTIVE" AND display_name:"my_schedule_*"`
        #     * `NOT display_name="my_schedule"`
        #     * `create_time>"2021-05-18T00:00:00Z"`
        #     * `end_time>"2021-05-18T00:00:00Z" OR NOT end_time:*`
        #     * `create_pipeline_job_request:*`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        #     Default to 100 if not specified.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        #     Typically obtained via
        #     {::Google::Cloud::AIPlatform::V1::ListSchedulesResponse#next_page_token ListSchedulesResponse.next_page_token}
        #     of the previous
        #     {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#list_schedules ScheduleService.ListSchedules}
        #     call.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     A comma-separated list of fields to order by. The default sort order is in
        #     ascending order. Use "desc" after a field name for descending. You can have
        #     multiple order_by fields provided.
        #
        #     For example, using "create_time desc, end_time" will order results by
        #     create time in descending order, and if there are multiple schedules having
        #     the same create time, order them by the end time in ascending order.
        #
        #     If order_by is not specified, it will order by default with create_time in
        #     descending order.
        #
        #     Supported fields:
        #
        #       * `create_time`
        #       * `start_time`
        #       * `end_time`
        #       * `next_run_time`
        class ListSchedulesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#list_schedules ScheduleService.ListSchedules}
        # @!attribute [rw] schedules
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::Schedule>]
        #     List of Schedules in the requested page.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results.
        #     Pass to
        #     {::Google::Cloud::AIPlatform::V1::ListSchedulesRequest#page_token ListSchedulesRequest.page_token}
        #     to obtain that page.
        class ListSchedulesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#delete_schedule ScheduleService.DeleteSchedule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Schedule resource to be deleted.
        #     Format:
        #     `projects/{project}/locations/{location}/schedules/{schedule}`
        class DeleteScheduleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#pause_schedule ScheduleService.PauseSchedule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Schedule resource to be paused.
        #     Format:
        #     `projects/{project}/locations/{location}/schedules/{schedule}`
        class PauseScheduleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#resume_schedule ScheduleService.ResumeSchedule}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Schedule resource to be resumed.
        #     Format:
        #     `projects/{project}/locations/{location}/schedules/{schedule}`
        # @!attribute [rw] catch_up
        #   @return [::Boolean]
        #     Optional. Whether to backfill missed runs when the schedule is resumed from
        #     PAUSED state. If set to true, all missed runs will be scheduled. New runs
        #     will be scheduled after the backfill is complete. This will also update
        #     {::Google::Cloud::AIPlatform::V1::Schedule#catch_up Schedule.catch_up} field.
        #     Default to false.
        class ResumeScheduleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::AIPlatform::V1::ScheduleService::Client#update_schedule ScheduleService.UpdateSchedule}.
        # @!attribute [rw] schedule
        #   @return [::Google::Cloud::AIPlatform::V1::Schedule]
        #     Required. The Schedule which replaces the resource on the server.
        #     The following restrictions will be applied:
        #
        #       * The scheduled request type cannot be changed.
        #       * The non-empty fields cannot be unset.
        #       * The output_only fields will be ignored if specified.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The update mask applies to the resource. See
        #     {::Google::Protobuf::FieldMask google.protobuf.FieldMask}.
        class UpdateScheduleRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
