# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # An instance of a Schedule periodically schedules runs to make API calls based
        # on user specified time specification and API request type.
        # @!attribute [rw] cron
        #   @return [::String]
        #     Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
        #     runs. To explicitly set a timezone to the cron tab, apply a prefix in the
        #     cron tab: "CRON_TZ=$\\{IANA_TIME_ZONE}" or "TZ=$\\{IANA_TIME_ZONE}".
        #     The $\\{IANA_TIME_ZONE} may only be a valid string from IANA time zone
        #     database. For example, "CRON_TZ=America/New_York 1 * * * *", or
        #     "TZ=America/New_York 1 * * * *".
        # @!attribute [rw] create_pipeline_job_request
        #   @return [::Google::Cloud::AIPlatform::V1::CreatePipelineJobRequest]
        #     Request for
        #     {::Google::Cloud::AIPlatform::V1::PipelineService::Client#create_pipeline_job PipelineService.CreatePipelineJob}.
        #     CreatePipelineJobRequest.parent field is required (format:
        #     projects/\\{project}/locations/\\{location}).
        #
        #     Note: The following fields are mutually exclusive: `create_pipeline_job_request`, `create_notebook_execution_job_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] create_notebook_execution_job_request
        #   @return [::Google::Cloud::AIPlatform::V1::CreateNotebookExecutionJobRequest]
        #     Request for
        #     {::Google::Cloud::AIPlatform::V1::NotebookService::Client#create_notebook_execution_job NotebookService.CreateNotebookExecutionJob}.
        #
        #     Note: The following fields are mutually exclusive: `create_notebook_execution_job_request`, `create_pipeline_job_request`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Immutable. The resource name of the Schedule.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. User provided name of the Schedule.
        #     The name can be up to 128 characters long and can consist of any UTF-8
        #     characters.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp after which the first run can be scheduled.
        #     Default to Schedule create time if not specified.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. Timestamp after which no new runs can be scheduled.
        #     If specified, The schedule will be completed when either
        #     end_time is reached or when scheduled_run_count >= max_run_count.
        #     If not specified, new runs will keep getting scheduled until this Schedule
        #     is paused or deleted. Already scheduled runs will be allowed to complete.
        #     Unset if not specified.
        # @!attribute [rw] max_run_count
        #   @return [::Integer]
        #     Optional. Maximum run count of the schedule.
        #     If specified, The schedule will be completed when either
        #     started_run_count >= max_run_count or when end_time is reached.
        #     If not specified, new runs will keep getting scheduled until this Schedule
        #     is paused or deleted. Already scheduled runs will be allowed to complete.
        #     Unset if not specified.
        # @!attribute [r] started_run_count
        #   @return [::Integer]
        #     Output only. The number of runs started by this schedule.
        # @!attribute [r] state
        #   @return [::Google::Cloud::AIPlatform::V1::Schedule::State]
        #     Output only. The state of this Schedule.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Schedule was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Schedule was updated.
        # @!attribute [r] next_run_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Schedule should schedule the next run.
        #     Having a next_run_time in the past means the runs are being started
        #     behind schedule.
        # @!attribute [r] last_pause_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Schedule was last paused.
        #     Unset if never paused.
        # @!attribute [r] last_resume_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this Schedule was last resumed.
        #     Unset if never resumed from pause.
        # @!attribute [rw] max_concurrent_run_count
        #   @return [::Integer]
        #     Required. Maximum number of runs that can be started concurrently for this
        #     Schedule. This is the limit for starting the scheduled requests and not the
        #     execution of the operations/jobs created by the requests (if applicable).
        # @!attribute [rw] allow_queueing
        #   @return [::Boolean]
        #     Optional. Whether new scheduled runs can be queued when max_concurrent_runs
        #     limit is reached. If set to true, new runs will be queued instead of
        #     skipped. Default to false.
        # @!attribute [r] catch_up
        #   @return [::Boolean]
        #     Output only. Whether to backfill missed runs when the schedule is resumed
        #     from PAUSED state. If set to true, all missed runs will be scheduled. New
        #     runs will be scheduled after the backfill is complete. Default to false.
        # @!attribute [r] last_scheduled_run_response
        #   @return [::Google::Cloud::AIPlatform::V1::Schedule::RunResponse]
        #     Output only. Response of the last scheduled run.
        #     This is the response for starting the scheduled requests and not the
        #     execution of the operations/jobs created by the requests (if applicable).
        #     Unset if no run has been scheduled yet.
        class Schedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Status of a scheduled run.
          # @!attribute [rw] scheduled_run_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The scheduled run time based on the user-specified schedule.
          # @!attribute [rw] run_response
          #   @return [::String]
          #     The response of the scheduled run.
          class RunResponse
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible state of the schedule.
          module State
            # Unspecified.
            STATE_UNSPECIFIED = 0

            # The Schedule is active. Runs are being scheduled on the user-specified
            # timespec.
            ACTIVE = 1

            # The schedule is paused. No new runs will be created until the schedule
            # is resumed. Already started runs will be allowed to complete.
            PAUSED = 2

            # The Schedule is completed. No new runs will be scheduled. Already started
            # runs will be allowed to complete. Schedules in completed state cannot be
            # paused or resumed.
            COMPLETED = 3
          end
        end
      end
    end
  end
end
