# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A SavedQuery is a view of the dataset. It references a subset of annotations
        # by problem type and filters.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Resource name of the SavedQuery.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The user-defined name of the SavedQuery.
        #     The name can be up to 128 characters long and can consist of any UTF-8
        #     characters.
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Value]
        #     Some additional information about the SavedQuery.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this SavedQuery was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when SavedQuery was last updated.
        # @!attribute [r] annotation_filter
        #   @return [::String]
        #     Output only. Filters on the Annotations in the dataset.
        # @!attribute [rw] problem_type
        #   @return [::String]
        #     Required. Problem type of the SavedQuery.
        #     Allowed values:
        #
        #     * IMAGE_CLASSIFICATION_SINGLE_LABEL
        #     * IMAGE_CLASSIFICATION_MULTI_LABEL
        #     * IMAGE_BOUNDING_POLY
        #     * IMAGE_BOUNDING_BOX
        #     * TEXT_CLASSIFICATION_SINGLE_LABEL
        #     * TEXT_CLASSIFICATION_MULTI_LABEL
        #     * TEXT_EXTRACTION
        #     * TEXT_SENTIMENT
        #     * VIDEO_CLASSIFICATION
        #     * VIDEO_OBJECT_TRACKING
        # @!attribute [r] annotation_spec_count
        #   @return [::Integer]
        #     Output only. Number of AnnotationSpecs in the context of the SavedQuery.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Used to perform a consistent read-modify-write update. If not set, a blind
        #     "overwrite" update happens.
        # @!attribute [r] support_automl_training
        #   @return [::Boolean]
        #     Output only. If the Annotations belonging to the SavedQuery can be used for
        #     AutoML training.
        class SavedQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
