# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # A ReservationAffinity can be used to configure a Vertex AI resource (e.g., a
        # DeployedModel) to draw its Compute Engine resources from a Shared
        # Reservation, or exclusively from on-demand capacity.
        # @!attribute [rw] reservation_affinity_type
        #   @return [::Google::Cloud::AIPlatform::V1::ReservationAffinity::Type]
        #     Required. Specifies the reservation affinity type.
        # @!attribute [rw] key
        #   @return [::String]
        #     Optional. Corresponds to the label key of a reservation resource. To target
        #     a SPECIFIC_RESERVATION by name, use
        #     `compute.googleapis.com/reservation-name` as the key and specify the name
        #     of your reservation as its value.
        # @!attribute [rw] values
        #   @return [::Array<::String>]
        #     Optional. Corresponds to the label values of a reservation resource. This
        #     must be the full resource name of the reservation.
        class ReservationAffinity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Identifies a type of reservation affinity.
          module Type
            # Default value. This should not be used.
            TYPE_UNSPECIFIED = 0

            # Do not consume from any reserved capacity, only use on-demand.
            NO_RESERVATION = 1

            # Consume any reservation available, falling back to on-demand.
            ANY_RESERVATION = 2

            # Consume from a specific reservation. When chosen, the reservation
            # must be identified via the `key` and `values` fields.
            SPECIFIC_RESERVATION = 3
          end
        end
      end
    end
  end
end
