# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Request message for [ReasoningEngineExecutionService.Query][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ReasoningEngine resource to use.
        #     Format:
        #     `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
        # @!attribute [rw] input
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Input content provided by users in JSON object format. Examples
        #     include text query, function calling parameters, media bytes, etc.
        # @!attribute [rw] class_method
        #   @return [::String]
        #     Optional. Class method to be used for the query.
        #     It is optional and defaults to "query" if unspecified.
        class QueryReasoningEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for [ReasoningEngineExecutionService.Query][]
        # @!attribute [rw] output
        #   @return [::Google::Protobuf::Value]
        #     Response provided by users in JSON object format.
        class QueryReasoningEngineResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for [ReasoningEngineExecutionService.StreamQuery][].
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the ReasoningEngine resource to use.
        #     Format:
        #     `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
        # @!attribute [rw] input
        #   @return [::Google::Protobuf::Struct]
        #     Optional. Input content provided by users in JSON object format. Examples
        #     include text query, function calling parameters, media bytes, etc.
        # @!attribute [rw] class_method
        #   @return [::String]
        #     Optional. Class method to be used for the stream query.
        #     It is optional and defaults to "stream_query" if unspecified.
        class StreamQueryReasoningEngineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
