# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # ReasoningEngine configurations
        # @!attribute [rw] source_code_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::SourceCodeSpec]
        #     Deploy from source code files with a defined entrypoint.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The service account that the Reasoning Engine artifact runs as.
        #     It should have "roles/storage.objectViewer" for reading the user project's
        #     Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
        #     not specified, the Vertex AI Reasoning Engine Service Agent in the project
        #     will be used.
        # @!attribute [rw] package_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::PackageSpec]
        #     Optional. User provided package spec of the ReasoningEngine.
        #     Ignored when users directly specify a deployment image through
        #     `deployment_spec.first_party_image_override`, but keeping the
        #     field_behavior to avoid introducing breaking changes.
        #     The `deployment_source` field should not be set if `package_spec` is
        #     specified.
        # @!attribute [rw] deployment_spec
        #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::DeploymentSpec]
        #     Optional. The specification of a Reasoning Engine deployment.
        # @!attribute [rw] class_methods
        #   @return [::Array<::Google::Protobuf::Struct>]
        #     Optional. Declarations for object class methods in OpenAPI specification
        #     format.
        # @!attribute [rw] agent_framework
        #   @return [::String]
        #     Optional. The OSS agent framework used to develop the agent.
        #     Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
        #     "llama-index", "custom".
        class ReasoningEngineSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # User-provided package specification, containing pickled object and package
          # requirements.
          # @!attribute [rw] pickle_object_gcs_uri
          #   @return [::String]
          #     Optional. The Cloud Storage URI of the pickled python object.
          # @!attribute [rw] dependency_files_gcs_uri
          #   @return [::String]
          #     Optional. The Cloud Storage URI of the dependency files in tar.gz format.
          # @!attribute [rw] requirements_gcs_uri
          #   @return [::String]
          #     Optional. The Cloud Storage URI of the `requirements.txt` file
          # @!attribute [rw] python_version
          #   @return [::String]
          #     Optional. The Python version. Supported values
          #     are 3.9, 3.10, 3.11, 3.12, 3.13. If not specified, the default value
          #     is 3.10.
          class PackageSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The specification of a Reasoning Engine deployment.
          # @!attribute [rw] env
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::EnvVar>]
          #     Optional. Environment variables to be set with the Reasoning Engine
          #     deployment. The environment variables can be updated through the
          #     UpdateReasoningEngine API.
          # @!attribute [rw] secret_env
          #   @return [::Array<::Google::Cloud::AIPlatform::V1::SecretEnvVar>]
          #     Optional. Environment variables where the value is a secret in Cloud
          #     Secret Manager.
          #     To use this feature, add 'Secret Manager Secret Accessor' role
          #     (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
          #     Service Agent.
          # @!attribute [rw] psc_interface_config
          #   @return [::Google::Cloud::AIPlatform::V1::PscInterfaceConfig]
          #     Optional. Configuration for PSC-I.
          # @!attribute [rw] min_instances
          #   @return [::Integer]
          #     Optional. The minimum number of application instances that will be kept
          #     running at all times. Defaults to 1. Range: [0, 10].
          # @!attribute [rw] max_instances
          #   @return [::Integer]
          #     Optional. The maximum number of application instances that can be
          #     launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
          #
          #     If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
          # @!attribute [rw] resource_limits
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. Resource limits for each container. Only 'cpu' and 'memory'
          #     keys are supported. Defaults to \\{"cpu": "4", "memory": "4Gi"}.
          #
          #       * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
          #       more information, go to
          #       https://cloud.google.com/run/docs/configuring/cpu.
          #       * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
          #       * For required cpu on different memory values, go to
          #       https://cloud.google.com/run/docs/configuring/memory-limits
          # @!attribute [rw] container_concurrency
          #   @return [::Integer]
          #     Optional. Concurrency for each container and agent server. Recommended
          #     value: 2 * cpu + 1. Defaults to 9.
          class DeploymentSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class ResourceLimitsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Specification for deploying from source code.
          # @!attribute [rw] inline_source
          #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::SourceCodeSpec::InlineSource]
          #     Source code is provided directly in the request.
          #
          #     Note: The following fields are mutually exclusive: `inline_source`, `developer_connect_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] developer_connect_source
          #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::SourceCodeSpec::DeveloperConnectSource]
          #     Source code is in a Git repository managed by Developer Connect.
          #
          #     Note: The following fields are mutually exclusive: `developer_connect_source`, `inline_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] python_spec
          #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::SourceCodeSpec::PythonSpec]
          #     Configuration for a Python application.
          class SourceCodeSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Specifies source code provided as a byte stream.
            # @!attribute [rw] source_archive
            #   @return [::String]
            #     Required. Input only. The application source code archive, provided as
            #     a compressed tarball (.tar.gz) file.
            class InlineSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies the configuration for fetching source code from a Git
            # repository that is managed by Developer Connect. This includes the
            # repository, revision, and directory to use.
            # @!attribute [rw] git_repository_link
            #   @return [::String]
            #     Required. The Developer Connect Git repository link, formatted as
            #     `projects/*/locations/*/connections/*/gitRepositoryLink/*`.
            # @!attribute [rw] dir
            #   @return [::String]
            #     Required. Directory, relative to the source root, in which to run the
            #     build.
            # @!attribute [rw] revision
            #   @return [::String]
            #     Required. The revision to fetch from the Git repository such as a
            #     branch, a tag, a commit SHA, or any Git ref.
            class DeveloperConnectConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies source code to be fetched from a Git repository managed through
            # the Developer Connect service.
            # @!attribute [rw] config
            #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec::SourceCodeSpec::DeveloperConnectConfig]
            #     Required. The Developer Connect configuration that defines the
            #     specific repository, revision, and directory to use as the source code
            #     root.
            class DeveloperConnectSource
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specification for running a Python application from source.
            # @!attribute [rw] version
            #   @return [::String]
            #     Optional. The version of Python to use. Support version
            #     includes 3.9, 3.10, 3.11, 3.12, 3.13.
            #     If not specified, default value is 3.10.
            # @!attribute [rw] entrypoint_module
            #   @return [::String]
            #     Optional. The Python module to load as the entrypoint, specified as a
            #     fully qualified module name. For example: path.to.agent.
            #     If not specified, defaults to "agent".
            #
            #     The project root will be added to Python sys.path, allowing imports
            #     to be specified relative to the root.
            # @!attribute [rw] entrypoint_object
            #   @return [::String]
            #     Optional. The name of the callable object within the
            #     `entrypoint_module` to use as the application If not specified,
            #     defaults to "root_agent".
            # @!attribute [rw] requirements_file
            #   @return [::String]
            #     Optional. The path to the requirements file, relative to the source
            #     root. If not specified, defaults to "requirements.txt".
            class PythonSpec
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # ReasoningEngine provides a customizable runtime for models to determine
        # which actions to take and in which order.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the ReasoningEngine.
        #     Format:
        #     `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. The display name of the ReasoningEngine.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The description of the ReasoningEngine.
        # @!attribute [rw] spec
        #   @return [::Google::Cloud::AIPlatform::V1::ReasoningEngineSpec]
        #     Optional. Configurations of the ReasoningEngine
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this ReasoningEngine was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when this ReasoningEngine was most recently updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Used to perform consistent read-modify-write updates. If not set,
        #     a blind "overwrite" update happens.
        # @!attribute [rw] encryption_spec
        #   @return [::Google::Cloud::AIPlatform::V1::EncryptionSpec]
        #     Customer-managed encryption key spec for a ReasoningEngine. If set, this
        #     ReasoningEngine and all sub-resources of this ReasoningEngine will be
        #     secured by this key.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels for the ReasoningEngine.
        class ReasoningEngine
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
