# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module AIPlatform
      module V1
        # Post startup script config.
        # @!attribute [rw] post_startup_script
        #   @return [::String]
        #     Optional. Post startup script to run after runtime is started.
        # @!attribute [rw] post_startup_script_url
        #   @return [::String]
        #     Optional. Post startup script url to download. Example:
        #     `gs://bucket/script.sh`
        # @!attribute [rw] post_startup_script_behavior
        #   @return [::Google::Cloud::AIPlatform::V1::PostStartupScriptConfig::PostStartupScriptBehavior]
        #     Optional. Post startup script behavior that defines download and execution
        #     behavior.
        class PostStartupScriptConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a notebook runtime post startup script behavior.
          module PostStartupScriptBehavior
            # Unspecified post startup script behavior.
            POST_STARTUP_SCRIPT_BEHAVIOR_UNSPECIFIED = 0

            # Run post startup script after runtime is started.
            RUN_ONCE = 1

            # Run post startup script after runtime is stopped.
            RUN_EVERY_START = 2

            # Download and run post startup script every time runtime is started.
            DOWNLOAD_AND_RUN_EVERY_START = 3
          end
        end

        # Colab image of the runtime.
        # @!attribute [rw] release_name
        #   @return [::String]
        #     Optional. The release name of the NotebookRuntime Colab image, e.g.
        #     "py310". If not specified, detault to the latest release.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. A human-readable description of the specified colab image
        #     release, populated by the system. Example: "Python 3.10", "Latest - current
        #     Python 3.11"
        class ColabImage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Notebook Software Config. This is passed to the backend when user
        # makes software configurations in UI.
        # @!attribute [rw] colab_image
        #   @return [::Google::Cloud::AIPlatform::V1::ColabImage]
        #     Optional. Google-managed NotebookRuntime colab image.
        # @!attribute [rw] env
        #   @return [::Array<::Google::Cloud::AIPlatform::V1::EnvVar>]
        #     Optional. Environment variables to be passed to the container.
        #     Maximum limit is 100.
        # @!attribute [rw] post_startup_script_config
        #   @return [::Google::Cloud::AIPlatform::V1::PostStartupScriptConfig]
        #     Optional. Post startup script config.
        class NotebookSoftwareConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
